package com.example.myapp

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.runtime.Composable
import androidx.core.splashscreen.SplashScreen.Companion.installSplashScreen
import androidx.navigation.compose.rememberNavController
import com.example.myapp.core.design_system.type.AppTheme
import com.example.myapp.navigation.MyApp

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        installSplashScreen()
        // Edge-to-edge drawing
        enableEdgeToEdge()
        super.onCreate(savedInstanceState)

        setContent {
            MainView()
        }
    }
}

@Composable
private fun MainView() {
    val navController = rememberNavController()

    AppTheme {
        MyApp(
            navController = navController,
        )
    }
}