package com.example.myapp.core.data.repository

import android.os.SystemClock
import com.example.myapp.core.models.MyState
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.withContext
import kotlin.time.Duration
import kotlin.time.Duration.Companion.milliseconds

class MyRepository(
    private val scope: CoroutineScope = CoroutineScope(Dispatchers.Default)
) {
    private val _state = MutableStateFlow(MyState.Stopped)
    val state = _state.asStateFlow()

    suspend fun getCurrentTime(): Duration = withContext(scope.coroutineContext) {
        return@withContext SystemClock.uptimeMillis().milliseconds
    }

    suspend fun start() = withContext(scope.coroutineContext) {
        _state.update { MyState.Started }
    }

    suspend fun pause() = withContext(scope.coroutineContext) {
        _state.update { MyState.Paused }
    }

    suspend fun stop() = withContext(scope.coroutineContext) {
        _state.update { MyState.Stopped }
    }
}