package com.example.myapp.feature.home.navigation

import androidx.lifecycle.viewmodel.compose.viewModel
import androidx.navigation.NavGraphBuilder
import androidx.navigation.compose.composable
import com.example.myapp.feature.home.list.HomeListScreen
import com.example.myapp.feature.home.list.HomeListViewModel
import com.example.myapp.navigation.AppDestination

fun NavGraphBuilder.homeScreen() {
    composable(AppDestination.Home.route) {
        val listViewModel: HomeListViewModel = viewModel(factory = HomeListViewModel.factory())
        HomeListScreen(
            viewModel = listViewModel,
        )
    }
}