import os.path, imp, types, sys, logging
import zipimport_ as zipimport

imp.new_module = types.ModuleType
imp.PY_SOURCE = 1
imp.PY_COMPILED = 2

def load_diregg( egg_path ):
    sys.path.append( egg_path )

def load_zipegg( egg_path ):
    egg_file = os.path.basename( egg_path )
    egg_name = egg_file.split('-',1)[0]
    head = egg_name.split('.')[0]
    
    importer = zipimport.zipimporter( egg_path )

    # we load the head, the importer loads recursively
    importer.load_module( head )
    # we need to import a subpackage 
    __import__( egg_name )

def load_egg( path, fuzzy_match=True ):

    #for attr in ('stdin', 'stdout', 'stderr'):
    #    setattr(sys, attr, getattr(sys, '__%s__' % attr))
            
    #import traceback, pdb
    #pdb.set_trace()

    # to avoid spec'ing a version in the egg, ie load_egg('eggs/zope.component')
    if fuzzy_match:
        if os.sep in path:
            parent, mpath = path.rsplit( os.sep, 1 )
        for p in os.listdir( os.path.dirname(path) ):
            pp = p.split('-')[0]
            #logging.info("%s %s"%(mpath, pp))            
            if mpath == pp:
                path = os.path.join( os.path.dirname( path ), p)
                break

    if os.path.isdir( path ):
        load_diregg( path )
    else:
        load_zipegg( path ) 
    
def load( directory, sorter=None ):
    """ optional sorter to dependency sort the eggs """
    directory = os.path.abspath( directory )
    assert os.path.isdir( directory ), "Invalid Eggs Directory"
    eggs = os.listdir( directory )
    eggs = sorter( eggs )
    eggs = [os.path.join(directory, egg) for egg in eggs]
    map( load_egg, eggs )
