#!/usr/bin/env python
#
# Copyright 2007 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

__author__ = "Vik Singh (viksi@yahoo-inc.com)"

import logging

import wsgiref.handlers
from google.appengine.ext import webapp

from fresh import fresh

class QAHandler(webapp.RequestHandler):

  def get(self):
    query = self.request.get("q")
    self.response.out.write(fresh(query))

class RootHandler(webapp.RequestHandler):

  def get(self):
    self.redirect("/fresh?q=yahoo")


def main():
  logging.getLogger().setLevel(logging.DEBUG)
  application = webapp.WSGIApplication([('/', RootHandler),
                                        ('/fresh', QAHandler)],
                                       debug=True)
  wsgiref.handlers.CGIHandler().run(application)


if __name__ == '__main__':
  main()
