/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

import android.app.Application;
import android.os.Handler;
import android.os.Message;
import com.inputstick.api.ConnectionManager;
import com.inputstick.api.Packet;
import com.inputstick.api.PacketManager;
import com.inputstick.api.bluetooth.BTService;
import com.inputstick.api.init.InitManager;
import com.inputstick.api.init.InitManagerListener;
import java.lang.ref.WeakReference;

public class BTConnectionManager
extends ConnectionManager
implements InitManagerListener {
    private String mMac;
    private byte[] mKey;
    private boolean mIsBT40;
    private InitManager mInitManager;
    private Application mApp;
    protected BTService mBTService;
    private PacketManager mPacketManager;
    private final BTHandler mBTHandler = new BTHandler(this);

    private void onConnecting() {
        this.stateNotify(2);
    }

    private void onConnected() {
        this.stateNotify(3);
        this.mInitManager.onConnected();
    }

    private void onDisconnected() {
        this.stateNotify(0);
        this.mInitManager.onDisconnected();
    }

    private void onFailure(int code) {
        this.setErrorCode(code);
        this.stateNotify(1);
        this.disconnect();
    }

    @Override
    protected void onData(byte[] rawData) {
        byte[] data = this.mPacketManager.bytesToPacket(rawData);
        if (data == null) {
            return;
        }
        this.mInitManager.onData(data);
        super.onData(data);
    }

    public BTConnectionManager(InitManager initManager, Application app, String mac, byte[] key, boolean isBT40) {
        this.mInitManager = initManager;
        this.mMac = mac;
        this.mKey = key;
        this.mApp = app;
        this.mIsBT40 = isBT40;
    }

    public BTConnectionManager(InitManager initManager, Application app, String mac, byte[] key) {
        this(initManager, app, mac, key, false);
    }

    @Override
    public void connect() {
        this.connect(false, 30000);
    }

    public void connect(boolean reflection, int timeout, boolean doNotAsk) {
        this.resetErrorCode();
        if (this.mBTService == null) {
            this.mBTService = new BTService(this.mApp, (Handler)this.mBTHandler);
            this.mPacketManager = new PacketManager(this.mBTService, this.mKey);
            this.mInitManager.init((InitManagerListener)this, this.mPacketManager);
        }
        this.mBTService.setConnectTimeout(timeout);
        this.mBTService.enableReflection(reflection);
        this.mBTService.connect(this.mMac, doNotAsk, this.mIsBT40);
        this.onConnecting();
    }

    public void connect(boolean reflection, int timeout) {
        this.connect(reflection, timeout, false);
    }

    @Override
    public void disconnect() {
        if (this.mBTService != null) {
            this.mBTService.disconnect();
        }
    }

    public void disconnect(int failureCode) {
        this.onFailure(failureCode);
    }

    public String getMac() {
        return this.mMac;
    }

    public void changeKey(byte[] key) {
        this.mKey = key;
        this.mPacketManager.changeKey(this.mKey);
    }

    @Override
    public void sendPacket(Packet p) {
        this.mPacketManager.sendPacket(p);
    }

    public void onInitReady() {
        this.stateNotify(4);
    }

    public void onInitNotReady() {
        this.stateNotify(3);
    }

    public void onInitFailure(int code) {
        this.onFailure(code);
    }

    private static class BTHandler
    extends Handler {
        private final WeakReference<BTConnectionManager> ref;

        BTHandler(BTConnectionManager manager) {
            this.ref = new WeakReference<BTConnectionManager>(manager);
        }

        public void handleMessage(Message msg) {
            BTConnectionManager manager = (BTConnectionManager)this.ref.get();
            if (manager != null) {
                switch (msg.what) {
                    case 1: {
                        manager.onData((byte[])msg.obj);
                        break;
                    }
                    case 2: {
                        manager.onConnected();
                        break;
                    }
                    case 3: {
                        manager.onDisconnected();
                        break;
                    }
                    case 4: {
                        manager.onFailure(msg.arg1);
                        break;
                    }
                    default: {
                        manager.onFailure(256);
                    }
                }
            }
        }
    }
}

