/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

public class HIDInfo {
    private int state;
    private boolean numLock;
    private boolean capsLock;
    private boolean scrollLock;
    private boolean keyboardReportProtocol = true;
    private boolean mouseReportProtocol = true;
    private boolean keyboardReady;
    private boolean mouseReady;
    private boolean consumerReady;
    private boolean rawHIDReady;
    private boolean sentToHostInfo = false;
    private int keyboardReportsSentToHost;
    private int mouseReportsSentToHost;
    private int consumerReportsSentToHost;
    private int rawHIDReportsSentToHost;

    public void update(byte[] data) {
        this.state = data[1];
        byte leds = data[2];
        this.numLock = (leds & 1) != 0;
        this.capsLock = (leds & 2) != 0;
        this.scrollLock = (leds & 4) != 0;
        this.keyboardReportProtocol = data[3] == 1;
        this.keyboardReady = data[4] != 0;
        this.mouseReportProtocol = data[5] == 1;
        this.mouseReady = data[6] != 0;
        this.consumerReady = data[7] != 0;
        if (data.length >= 12 && data[11] == -1) {
            this.sentToHostInfo = true;
            this.keyboardReportsSentToHost = data[8] & 0xFF;
            this.mouseReportsSentToHost = data[9] & 0xFF;
            this.consumerReportsSentToHost = data[10] & 0xFF;
        }
        if (data.length >= 14) {
            this.rawHIDReady = data[12] != 0;
            this.rawHIDReportsSentToHost = data[13] & 0xFF;
        } else {
            this.rawHIDReady = true;
        }
    }

    public void setKeyboardBusy() {
        this.keyboardReady = false;
    }

    public int getState() {
        return this.state;
    }

    public boolean getNumLock() {
        return this.numLock;
    }

    public boolean getCapsLock() {
        return this.capsLock;
    }

    public boolean getScrollLock() {
        return this.scrollLock;
    }

    public boolean isKeyboardReportProtocol() {
        return this.keyboardReportProtocol;
    }

    public boolean isMouseReportProtocol() {
        return this.mouseReportProtocol;
    }

    public boolean isKeyboardReady() {
        return this.keyboardReady;
    }

    public boolean isMouseReady() {
        return this.mouseReady;
    }

    public boolean isConsumerReady() {
        return this.consumerReady;
    }

    public boolean isRawHIDReady() {
        return this.rawHIDReady;
    }

    public boolean isSentToHostInfoAvailable() {
        return this.sentToHostInfo;
    }

    public int getKeyboardReportsSentToHost() {
        return this.keyboardReportsSentToHost;
    }

    public int getMouseReportsSentToHost() {
        return this.mouseReportsSentToHost;
    }

    public int getConsumerReportsSentToHost() {
        return this.consumerReportsSentToHost;
    }

    public int getRawHIDReportsSentToHost() {
        return this.rawHIDReportsSentToHost;
    }
}

