/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import com.inputstick.api.ConnectionManager;
import com.inputstick.api.Packet;
import java.lang.ref.WeakReference;

public class IPCConnectionManager
extends ConnectionManager {
    public static final int SERVICE_CMD_CONNECT = 1;
    public static final int SERVICE_CMD_DISCONNECT = 2;
    public static final int SERVICE_CMD_DATA = 3;
    public static final int SERVICE_CMD_STATE = 4;
    Context mCtx;
    Messenger mService = null;
    boolean mBound;
    boolean initSent;
    final Messenger mMessenger = new Messenger((Handler)new IncomingHandler(this));
    private ServiceConnection mConnection = new /* Unavailable Anonymous Inner Class!! */;

    private void sendConnectMessage() {
        Bundle b = new Bundle();
        b.putLong("TIME", System.currentTimeMillis());
        this.sendMessage(1, 0, 0, b);
    }

    private void sendMessage(int what, int arg1, int arg2, Bundle b) {
        try {
            Message msg = Message.obtain(null, (int)what, (int)arg1, (int)0, null);
            msg.replyTo = this.mMessenger;
            msg.setData(b);
            this.mService.send(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMessage(int what, int arg1, int arg2, byte[] data) {
        Bundle b = new Bundle();
        b.putByteArray("data", data);
        this.sendMessage(what, arg1, arg2, b);
    }

    private void sendMessage(int what, int arg1, int arg2) {
        this.sendMessage(what, arg1, arg2, (Bundle)null);
    }

    @Override
    protected void onData(byte[] data) {
        super.onData(data);
    }

    public IPCConnectionManager(Application app) {
        this.mCtx = app.getApplicationContext();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void connect() {
        PackageManager pm = this.mCtx.getPackageManager();
        boolean exists = true;
        try {
            pm.getPackageInfo("com.inputstick.apps.inputstickutility", 128);
        }
        catch (Exception e) {
            exists = false;
        }
        this.resetErrorCode();
        if (exists) {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName("com.inputstick.apps.inputstickutility", "com.inputstick.apps.inputstickutility.service.InputStickService"));
            intent.putExtra("TIME", System.currentTimeMillis());
            if (Build.VERSION.SDK_INT < 26) {
                this.mCtx.startService(intent);
            } else {
                this.mCtx.startForegroundService(intent);
            }
            this.mCtx.bindService(intent, this.mConnection, 1);
            if (this.mBound) {
                this.sendConnectMessage();
            }
        } else {
            this.setErrorCode(4097);
            this.stateNotify(1);
            this.stateNotify(0);
        }
    }

    @Override
    public void disconnect() {
        if (this.mBound) {
            this.sendMessage(2, 0, 0);
            Intent intent = new Intent();
            intent.setComponent(new ComponentName("com.inputstick.apps.inputstickutility", "com.inputstick.apps.inputstickutility.service.InputStickService"));
            this.mCtx.unbindService(this.mConnection);
            this.mCtx.stopService(intent);
            this.mBound = false;
        } else {
            this.stateNotify(0);
        }
    }

    @Override
    public void sendPacket(Packet p) {
        if (this.mState == 4 || this.mState == 3) {
            if (p.getRespond()) {
                this.sendMessage(3, 1, 0, p.getBytes());
            } else {
                this.sendMessage(3, 0, 0, p.getBytes());
            }
        }
    }

    private static class IncomingHandler
    extends Handler {
        private final WeakReference<IPCConnectionManager> ref;

        IncomingHandler(IPCConnectionManager manager) {
            this.ref = new WeakReference<IPCConnectionManager>(manager);
        }

        public void handleMessage(Message msg) {
            if (this.ref == null) {
                return;
            }
            IPCConnectionManager manager = (IPCConnectionManager)this.ref.get();
            if (manager != null) {
                switch (msg.what) {
                    case 3: {
                        byte[] data = null;
                        Bundle b = msg.getData();
                        if (b == null) break;
                        data = b.getByteArray("data");
                        manager.onData(data);
                        break;
                    }
                    case 4: {
                        boolean forceUpdate = false;
                        if (msg.arg1 == 1) {
                            manager.setErrorCode(msg.arg2);
                            forceUpdate = true;
                        } else if (msg.arg1 == 0 && msg.arg2 > 0) {
                            manager.setDisconnectReason(msg.arg2);
                            forceUpdate = true;
                        }
                        manager.stateNotify(msg.arg1, forceUpdate);
                    }
                }
            }
        }
    }
}

