/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.bluetooth;

import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import com.inputstick.api.Util;
import com.inputstick.api.bluetooth.BT20Connection;
import com.inputstick.api.bluetooth.BTConnection;
import com.inputstick.api.bluetooth.BTService;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.UUID;

public class BT20Connection
extends BTConnection {
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private final BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private ConnectThread mConnectThread;
    private ConnectedThread mConnectedThread;

    public BT20Connection(Application app, BTService btService, String mac, boolean reflections) {
        super(app, btService, mac, reflections);
    }

    @Override
    public void connect() {
        Util.log((int)256, (String)"Connect (2.0)");
        this.cancelThreads();
        BluetoothDevice device = this.mAdapter.getRemoteDevice(this.mMac);
        if (device != null) {
            this.mConnectThread = new ConnectThread(device, this.mReflections);
            this.mConnectThread.start();
        } else {
            this.mBTservice.connectionFailed(false, 262);
        }
    }

    @Override
    public void disconnect() {
        Util.log((int)256, (String)"Disconnect (2.0)");
        this.cancelThreads();
    }

    @Override
    public void setStatusUpdateInterval(int updateRate) {
    }

    @Override
    public void write(byte[] out) {
        this.mConnectedThread.write(out);
    }

    private synchronized void cancelThreads() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
    }

    private class ConnectThread
    extends Thread {
        private final BluetoothSocket mmSocket;

        public ConnectThread(BluetoothDevice device, boolean useReflection) {
            BluetoothSocket tmp = null;
            try {
                if (useReflection) {
                    Method m = device.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                    tmp = (BluetoothSocket)m.invoke((Object)device, 1);
                } else {
                    tmp = device.createRfcommSocketToServiceRecord(MY_UUID);
                }
            }
            catch (IOException e) {
                Util.log((int)2048, (String)"Socket create() failed");
            }
            catch (Exception e) {
                Util.log((int)2048, (String)"Socket create() REFLECTION failed");
                e.printStackTrace();
            }
            this.mmSocket = tmp;
        }

        @Override
        public void run() {
            Util.log((int)256, (String)"BEGIN mConnectThread");
            BT20Connection.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (Exception e) {
                try {
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    Util.log((int)2048, (String)"unable to close() socket during connection failure");
                }
                BT20Connection.this.mBTservice.connectionFailed(true, 0);
                return;
            }
            BT20Connection.this.mConnectThread = null;
            BT20Connection.this.cancelThreads();
            BT20Connection.this.mConnectedThread = new ConnectedThread(BT20Connection.this, this.mmSocket);
            BT20Connection.this.mConnectedThread.start();
            BT20Connection.this.mBTservice.connectionEstablished();
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Util.log((int)2048, (String)"close() of connect socket failed");
            }
        }
    }
}

