/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.hid;

import com.inputstick.api.hid.HIDReport;
import java.util.LinkedList;

public class HIDTransaction {
    public static final byte TRANSACTION_CMD_DEFAULT = 0;
    private int mID;
    private byte mTransactionTypeCmd;
    private LinkedList<HIDReport> reports;

    public HIDTransaction(byte transactionTypeCmd) {
        this.mTransactionTypeCmd = transactionTypeCmd;
        this.reports = new LinkedList();
    }

    public HIDTransaction() {
        this(0);
    }

    public void addReport(HIDReport report) {
        this.reports.add(report);
    }

    public int getReportsCount() {
        return this.reports.size();
    }

    public void setID(int id) {
        this.mID = id;
    }

    public int getID() {
        return this.mID;
    }

    public byte getTransactionTypeCmd() {
        return this.mTransactionTypeCmd;
    }

    public boolean hasNext() {
        return !this.reports.isEmpty();
    }

    public byte[] getNextReport() {
        return this.reports.poll().getBytes();
    }

    public HIDReport getHIDReportAt(int pos) {
        return this.reports.get(pos);
    }

    public HIDTransaction split(int n) {
        HIDTransaction result = new HIDTransaction();
        if (n <= this.reports.size()) {
            while (n > 0) {
                HIDReport report = this.reports.poll();
                result.addReport(report);
                --n;
            }
        }
        return result;
    }

    public int getReportBytesCount() {
        int cnt = 0;
        for (HIDReport r : this.reports) {
            cnt += r.getBytesCount();
        }
        return cnt;
    }
}

