/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import android.content.SharedPreferences;
import com.inputstick.api.layout.KeyboardLayout;

public class RemotePreferences {
    protected KeyboardLayout layout;
    protected int typingSpeed;
    protected boolean showModifiers;
    protected boolean showMouse;
    protected boolean touchScreenMode;
    protected float ratio;
    protected boolean tapToClick;
    protected int mouseSensitivity;
    protected int scrollSensitivity;
    protected int proximityThreshold;
    protected int tapInterval;

    public void reload(SharedPreferences sharedPref) {
        this.layout = KeyboardLayout.getLayout((String)sharedPref.getString("inputstick_keyboard_layout", "en-US"));
        this.showModifiers = true;
        try {
            this.typingSpeed = Integer.parseInt(sharedPref.getString("inputstick_typing_speed", "1"));
            if (this.typingSpeed < 0 && this.typingSpeed > 100) {
                this.typingSpeed = 1;
            }
        }
        catch (Exception e) {
            this.typingSpeed = 1;
        }
        this.showMouse = true;
        this.touchScreenMode = sharedPref.getString("inputstick_mousepad_mode", "mouse").equals("touchscreen");
        this.ratio = 0.0f;
        this.tapToClick = sharedPref.getBoolean("inputstick_tap_to_click", true);
        this.mouseSensitivity = sharedPref.getInt("inputstick_sensitivity_mouse", 50);
        this.scrollSensitivity = sharedPref.getInt("inputstick_sensitivity_scroll", 50);
        this.tapInterval = 500;
        this.proximityThreshold = 0;
    }

    public KeyboardLayout getKeyboardLayout() {
        return this.layout;
    }

    public boolean showModifiersArea() {
        return this.showModifiers;
    }

    public int getTypingSpeed() {
        return this.typingSpeed;
    }

    public boolean showMouseArea() {
        return this.showMouse;
    }

    public float getMousePadRatio() {
        if (this.touchScreenMode) {
            return this.ratio;
        }
        return 0.0f;
    }

    public boolean isInTouchScreenMode() {
        return this.touchScreenMode;
    }

    public boolean isTapToClick() {
        return this.tapToClick;
    }

    public int getMouseSensitivity() {
        return this.mouseSensitivity;
    }

    public int getScrollSensitivity() {
        return this.scrollSensitivity;
    }

    public int getTouchProximity() {
        return this.proximityThreshold;
    }

    public int getTapInterval() {
        return this.tapInterval;
    }
}

