/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity.contextaware;

import android.content.Context;
import androidx.activity.contextaware.OnContextAvailableListener;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/activity/contextaware/ContextAwareHelper;", "", "()V", "context", "Landroid/content/Context;", "listeners", "", "Landroidx/activity/contextaware/OnContextAvailableListener;", "addOnContextAvailableListener", "", "listener", "clearAvailableContext", "dispatchOnContextAvailable", "peekAvailableContext", "removeOnContextAvailableListener", "activity_release"})
public final class ContextAwareHelper {
    @NotNull
    private final Set<OnContextAvailableListener> listeners = new CopyOnWriteArraySet();
    @Nullable
    private volatile Context context;

    @Nullable
    public final Context peekAvailableContext() {
        return this.context;
    }

    public final void addOnContextAvailableListener(@NotNull OnContextAvailableListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        Context context = this.context;
        if (context != null) {
            Context it = context;
            boolean bl = false;
            listener2.onContextAvailable(it);
        }
        this.listeners.add(listener2);
    }

    public final void removeOnContextAvailableListener(@NotNull OnContextAvailableListener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.listeners.remove(listener2);
    }

    public final void dispatchOnContextAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        for (OnContextAvailableListener listener2 : this.listeners) {
            listener2.onContextAvailable(context);
        }
    }

    public final void clearAvailableContext() {
        this.context = null;
    }
}

