/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.os.LocaleList;
import androidx.annotation.RequiresApi;
import androidx.core.os.LocaleListCompat;
import java.util.LinkedHashSet;
import java.util.Locale;

@RequiresApi(value=24)
final class LocaleOverlayHelper {
    private LocaleOverlayHelper() {
    }

    static LocaleListCompat combineLocalesIfOverlayExists(LocaleListCompat overlayLocales, LocaleListCompat baseLocales) {
        if (overlayLocales == null || overlayLocales.isEmpty()) {
            return LocaleListCompat.getEmptyLocaleList();
        }
        return LocaleOverlayHelper.combineLocales(overlayLocales, baseLocales);
    }

    static LocaleListCompat combineLocalesIfOverlayExists(LocaleList overlayLocales, LocaleList baseLocales) {
        if (overlayLocales == null || overlayLocales.isEmpty()) {
            return LocaleListCompat.getEmptyLocaleList();
        }
        return LocaleOverlayHelper.combineLocales(LocaleListCompat.wrap(overlayLocales), LocaleListCompat.wrap(baseLocales));
    }

    private static LocaleListCompat combineLocales(LocaleListCompat overlayLocales, LocaleListCompat baseLocales) {
        LinkedHashSet<Locale> combinedLocales = new LinkedHashSet<Locale>();
        for (int i = 0; i < overlayLocales.size() + baseLocales.size(); ++i) {
            Locale currLocale = i < overlayLocales.size() ? overlayLocales.get(i) : baseLocales.get(i - overlayLocales.size());
            if (currLocale == null) continue;
            combinedLocales.add(currLocale);
        }
        return LocaleListCompat.create(combinedLocales.toArray(new Locale[combinedLocales.size()]));
    }
}

