/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view;

import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class WindowCallbackWrapper
implements Window.Callback {
    final Window.Callback mWrapped;

    public WindowCallbackWrapper(Window.Callback wrapped) {
        if (wrapped == null) {
            throw new IllegalArgumentException("Window callback may not be null");
        }
        this.mWrapped = wrapped;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.mWrapped.dispatchKeyEvent(event);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        return this.mWrapped.dispatchKeyShortcutEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        return this.mWrapped.dispatchTouchEvent(event);
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        return this.mWrapped.dispatchTrackballEvent(event);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        return this.mWrapped.dispatchGenericMotionEvent(event);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return this.mWrapped.dispatchPopulateAccessibilityEvent(event);
    }

    public View onCreatePanelView(int featureId) {
        return this.mWrapped.onCreatePanelView(featureId);
    }

    public boolean onCreatePanelMenu(int featureId, Menu menu2) {
        return this.mWrapped.onCreatePanelMenu(featureId, menu2);
    }

    public boolean onPreparePanel(int featureId, View view, Menu menu2) {
        return this.mWrapped.onPreparePanel(featureId, view, menu2);
    }

    public boolean onMenuOpened(int featureId, Menu menu2) {
        return this.mWrapped.onMenuOpened(featureId, menu2);
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        return this.mWrapped.onMenuItemSelected(featureId, item);
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams attrs) {
        this.mWrapped.onWindowAttributesChanged(attrs);
    }

    public void onContentChanged() {
        this.mWrapped.onContentChanged();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        this.mWrapped.onWindowFocusChanged(hasFocus);
    }

    public void onAttachedToWindow() {
        this.mWrapped.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        this.mWrapped.onDetachedFromWindow();
    }

    public void onPanelClosed(int featureId, Menu menu2) {
        this.mWrapped.onPanelClosed(featureId, menu2);
    }

    @RequiresApi(value=23)
    public boolean onSearchRequested(SearchEvent searchEvent) {
        return Api23Impl.onSearchRequested(this.mWrapped, searchEvent);
    }

    public boolean onSearchRequested() {
        return this.mWrapped.onSearchRequested();
    }

    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback2) {
        return this.mWrapped.onWindowStartingActionMode(callback2);
    }

    @RequiresApi(value=23)
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback2, int type) {
        return Api23Impl.onWindowStartingActionMode(this.mWrapped, callback2, type);
    }

    public void onActionModeStarted(ActionMode mode) {
        this.mWrapped.onActionModeStarted(mode);
    }

    public void onActionModeFinished(ActionMode mode) {
        this.mWrapped.onActionModeFinished(mode);
    }

    @RequiresApi(value=24)
    public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> data, Menu menu2, int deviceId) {
        Api24Impl.onProvideKeyboardShortcuts(this.mWrapped, data, menu2, deviceId);
    }

    @RequiresApi(value=26)
    public void onPointerCaptureChanged(boolean hasCapture) {
        Api26Impl.onPointerCaptureChanged(this.mWrapped, hasCapture);
    }

    public final Window.Callback getWrapped() {
        return this.mWrapped;
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static boolean onSearchRequested(Window.Callback callback2, SearchEvent searchEvent) {
            return callback2.onSearchRequested(searchEvent);
        }

        @DoNotInline
        static ActionMode onWindowStartingActionMode(Window.Callback windowCallback, ActionMode.Callback actionModeCallback, int i) {
            return windowCallback.onWindowStartingActionMode(actionModeCallback, i);
        }
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static void onProvideKeyboardShortcuts(Window.Callback callback2, List<KeyboardShortcutGroup> data, Menu menu2, int deviceId) {
            callback2.onProvideKeyboardShortcuts(data, menu2, deviceId);
        }
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        static void onPointerCaptureChanged(Window.Callback callback2, boolean hasCapture) {
            callback2.onPointerCaptureChanged(hasCapture);
        }
    }
}

