/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.text.Selection;
import android.text.Spannable;
import android.util.Log;
import android.view.DragEvent;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.view.ContentInfoCompat;
import androidx.core.view.ViewCompat;

final class AppCompatReceiveContentHelper {
    private static final String LOG_TAG = "ReceiveContent";

    private AppCompatReceiveContentHelper() {
    }

    static boolean maybeHandleMenuActionViaPerformReceiveContent(@NonNull TextView view, int actionId) {
        ClipData clip;
        if (Build.VERSION.SDK_INT >= 31 || ViewCompat.getOnReceiveContentMimeTypes((View)view) == null || actionId != 0x1020022 && actionId != 16908337) {
            return false;
        }
        ClipboardManager cm = (ClipboardManager)view.getContext().getSystemService("clipboard");
        ClipData clipData = clip = cm == null ? null : cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            ContentInfoCompat payload = new ContentInfoCompat.Builder(clip, 1).setFlags(actionId == 0x1020022 ? 0 : 1).build();
            ViewCompat.performReceiveContent((View)view, payload);
        }
        return true;
    }

    static boolean maybeHandleDragEventViaPerformReceiveContent(@NonNull View view, @NonNull DragEvent event) {
        if (Build.VERSION.SDK_INT >= 31 || Build.VERSION.SDK_INT < 24 || event.getLocalState() != null || ViewCompat.getOnReceiveContentMimeTypes(view) == null) {
            return false;
        }
        Activity activity = AppCompatReceiveContentHelper.tryGetActivity(view);
        if (activity == null) {
            Log.i((String)LOG_TAG, (String)("Can't handle drop: no activity: view=" + view));
            return false;
        }
        if (event.getAction() == 1) {
            return !(view instanceof TextView);
        }
        if (event.getAction() == 3) {
            return view instanceof TextView ? OnDropApi24Impl.onDropForTextView(event, (TextView)view, activity) : OnDropApi24Impl.onDropForView(event, view, activity);
        }
        return false;
    }

    @Nullable
    static Activity tryGetActivity(@NonNull View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    @RequiresApi(value=24)
    private static final class OnDropApi24Impl {
        private OnDropApi24Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoNotInline
        static boolean onDropForTextView(@NonNull DragEvent event, @NonNull TextView view, @NonNull Activity activity) {
            activity.requestDragAndDropPermissions(event);
            int offset = view.getOffsetForPosition(event.getX(), event.getY());
            view.beginBatchEdit();
            try {
                Selection.setSelection((Spannable)((Spannable)view.getText()), (int)offset);
                ContentInfoCompat payload = new ContentInfoCompat.Builder(event.getClipData(), 3).build();
                ViewCompat.performReceiveContent((View)view, payload);
            }
            finally {
                view.endBatchEdit();
            }
            return true;
        }

        @DoNotInline
        static boolean onDropForView(@NonNull DragEvent event, @NonNull View view, @NonNull Activity activity) {
            activity.requestDragAndDropPermissions(event);
            ContentInfoCompat payload = new ContentInfoCompat.Builder(event.getClipData(), 3).build();
            ViewCompat.performReceiveContent(view, payload);
            return true;
        }
    }
}

