/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassifier;
import android.widget.TextView;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;

final class AppCompatTextClassifierHelper {
    @NonNull
    private TextView mTextView;
    @Nullable
    private TextClassifier mTextClassifier;

    AppCompatTextClassifierHelper(@NonNull TextView textView) {
        this.mTextView = Preconditions.checkNotNull(textView);
    }

    @RequiresApi(api=26)
    public void setTextClassifier(@Nullable TextClassifier textClassifier) {
        this.mTextClassifier = textClassifier;
    }

    @RequiresApi(api=26)
    @NonNull
    public TextClassifier getTextClassifier() {
        if (this.mTextClassifier == null) {
            return Api26Impl.getTextClassifier(this.mTextView);
        }
        return this.mTextClassifier;
    }

    @RequiresApi(value=26)
    private static final class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        @NonNull
        static TextClassifier getTextClassifier(@NonNull TextView textView) {
            TextClassificationManager tcm = (TextClassificationManager)textView.getContext().getSystemService(TextClassificationManager.class);
            if (tcm != null) {
                return tcm.getTextClassifier();
            }
            return TextClassifier.NO_OP;
        }
    }
}

