/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.R;
import androidx.appcompat.graphics.drawable.DrawableWrapperCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.core.widget.ListViewAutoScrollHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class DropDownListView
extends ListView {
    public static final int INVALID_POSITION = -1;
    public static final int NO_POSITION = -1;
    private final Rect mSelectorRect = new Rect();
    private int mSelectionLeftPadding = 0;
    private int mSelectionTopPadding = 0;
    private int mSelectionRightPadding = 0;
    private int mSelectionBottomPadding = 0;
    private int mMotionPosition;
    private GateKeeperDrawable mSelector;
    private boolean mListSelectionHidden;
    private boolean mHijackFocus;
    private boolean mDrawsInPressedState;
    private ViewPropertyAnimatorCompat mClickAnimation;
    private ListViewAutoScrollHelper mScrollHelper;
    ResolveHoverRunnable mResolveHoverRunnable;

    DropDownListView(@NonNull Context context, boolean hijackFocus) {
        super(context, null, R.attr.dropDownListViewStyle);
        this.mHijackFocus = hijackFocus;
        this.setCacheColorHint(0);
    }

    private boolean superIsSelectedChildViewEnabled() {
        if (Build.VERSION.SDK_INT >= 33) {
            return Api33Impl.isSelectedChildViewEnabled((AbsListView)this);
        }
        return PreApi33Impl.isSelectedChildViewEnabled((AbsListView)this);
    }

    private void superSetSelectedChildViewEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 33) {
            Api33Impl.setSelectedChildViewEnabled((AbsListView)this, enabled);
        } else {
            PreApi33Impl.setSelectedChildViewEnabled((AbsListView)this, enabled);
        }
    }

    public boolean isInTouchMode() {
        return this.mHijackFocus && this.mListSelectionHidden || super.isInTouchMode();
    }

    public boolean hasWindowFocus() {
        return this.mHijackFocus || super.hasWindowFocus();
    }

    public boolean isFocused() {
        return this.mHijackFocus || super.isFocused();
    }

    public boolean hasFocus() {
        return this.mHijackFocus || super.hasFocus();
    }

    public void setSelector(Drawable sel) {
        this.mSelector = sel != null ? new GateKeeperDrawable(sel) : null;
        super.setSelector((Drawable)this.mSelector);
        Rect padding = new Rect();
        if (sel != null) {
            sel.getPadding(padding);
        }
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
    }

    protected void drawableStateChanged() {
        if (this.mResolveHoverRunnable != null) {
            return;
        }
        super.drawableStateChanged();
        this.setSelectorEnabled(true);
        this.updateSelectorStateCompat();
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean drawSelectorOnTop = false;
        this.drawSelectorCompat(canvas);
        super.dispatchDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mMotionPosition = this.pointToPosition((int)ev.getX(), (int)ev.getY());
            }
        }
        if (this.mResolveHoverRunnable != null) {
            this.mResolveHoverRunnable.cancel();
        }
        return super.onTouchEvent(ev);
    }

    public int lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.getAdapter();
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        int count2 = adapter.getCount();
        if (!this.getAdapter().areAllItemsEnabled()) {
            if (lookDown) {
                for (position = Math.max(0, position); position < count2 && !adapter.isEnabled(position); ++position) {
                }
            } else {
                for (position = Math.min(position, count2 - 1); position >= 0 && !adapter.isEnabled(position); --position) {
                }
            }
            if (position < 0 || position >= count2) {
                return -1;
            }
            return position;
        }
        if (position < 0 || position >= count2) {
            return -1;
        }
        return position;
    }

    public int measureHeightOfChildrenCompat(int widthMeasureSpec, int startPosition, int endPosition, int maxHeight, int disallowPartialChildPosition) {
        int paddingTop = this.getListPaddingTop();
        int paddingBottom = this.getListPaddingBottom();
        int reportedDividerHeight = this.getDividerHeight();
        Drawable divider = this.getDivider();
        ListAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return paddingTop + paddingBottom;
        }
        int returnedHeight = paddingTop + paddingBottom;
        int dividerHeight = reportedDividerHeight > 0 && divider != null ? reportedDividerHeight : 0;
        int prevHeightWithoutPartialChild = 0;
        View child = null;
        int viewType = 0;
        int count2 = adapter.getCount();
        for (int i = 0; i < count2; ++i) {
            ViewGroup.LayoutParams childLp;
            int newType = adapter.getItemViewType(i);
            if (newType != viewType) {
                child = null;
                viewType = newType;
            }
            if ((childLp = (child = adapter.getView(i, child, (ViewGroup)this)).getLayoutParams()) == null) {
                childLp = this.generateDefaultLayoutParams();
                child.setLayoutParams(childLp);
            }
            int heightMeasureSpec = childLp.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)childLp.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            child.measure(widthMeasureSpec, heightMeasureSpec);
            child.forceLayout();
            if (i > 0) {
                returnedHeight += dividerHeight;
            }
            if ((returnedHeight += child.getMeasuredHeight()) >= maxHeight) {
                return disallowPartialChildPosition >= 0 && i > disallowPartialChildPosition && prevHeightWithoutPartialChild > 0 && returnedHeight != maxHeight ? prevHeightWithoutPartialChild : maxHeight;
            }
            if (disallowPartialChildPosition < 0 || i < disallowPartialChildPosition) continue;
            prevHeightWithoutPartialChild = returnedHeight;
        }
        return returnedHeight;
    }

    private void setSelectorEnabled(boolean enabled) {
        if (this.mSelector != null) {
            this.mSelector.setEnabled(enabled);
        }
    }

    public boolean onHoverEvent(@NonNull MotionEvent ev) {
        if (Build.VERSION.SDK_INT < 26) {
            return super.onHoverEvent(ev);
        }
        int action = ev.getActionMasked();
        if (action == 10 && this.mResolveHoverRunnable == null) {
            this.mResolveHoverRunnable = new ResolveHoverRunnable();
            this.mResolveHoverRunnable.post();
        }
        boolean handled = super.onHoverEvent(ev);
        if (action == 9 || action == 7) {
            int position = this.pointToPosition((int)ev.getX(), (int)ev.getY());
            if (position != -1 && position != this.getSelectedItemPosition()) {
                View hoveredItem = this.getChildAt(position - this.getFirstVisiblePosition());
                if (hoveredItem.isEnabled()) {
                    this.requestFocus();
                    if (Build.VERSION.SDK_INT >= 30 && Api30Impl.canPositionSelectorForHoveredItem()) {
                        Api30Impl.positionSelectorForHoveredItem(this, position, hoveredItem);
                    } else {
                        this.setSelectionFromTop(position, hoveredItem.getTop() - this.getTop());
                    }
                }
                this.updateSelectorStateCompat();
            }
        } else {
            this.setSelection(-1);
        }
        return handled;
    }

    protected void onDetachedFromWindow() {
        this.mResolveHoverRunnable = null;
        super.onDetachedFromWindow();
    }

    public boolean onForwardedEvent(MotionEvent event, int activePointerId) {
        boolean handledEvent = true;
        boolean clearPressedItem = false;
        int actionMasked = event.getActionMasked();
        switch (actionMasked) {
            case 3: {
                handledEvent = false;
                break;
            }
            case 1: {
                handledEvent = false;
            }
            case 2: {
                int y;
                int activeIndex = event.findPointerIndex(activePointerId);
                if (activeIndex < 0) {
                    handledEvent = false;
                    break;
                }
                int x = (int)event.getX(activeIndex);
                int position = this.pointToPosition(x, y = (int)event.getY(activeIndex));
                if (position == -1) {
                    clearPressedItem = true;
                    break;
                }
                View child = this.getChildAt(position - this.getFirstVisiblePosition());
                this.setPressedItem(child, position, x, y);
                handledEvent = true;
                if (actionMasked != 1) break;
                this.clickPressedItem(child, position);
            }
        }
        if (!handledEvent || clearPressedItem) {
            this.clearPressedItem();
        }
        if (handledEvent) {
            if (this.mScrollHelper == null) {
                this.mScrollHelper = new ListViewAutoScrollHelper(this);
            }
            this.mScrollHelper.setEnabled(true);
            this.mScrollHelper.onTouch((View)this, event);
        } else if (this.mScrollHelper != null) {
            this.mScrollHelper.setEnabled(false);
        }
        return handledEvent;
    }

    private void clickPressedItem(View child, int position) {
        long id2 = this.getItemIdAtPosition(position);
        this.performItemClick(child, position, id2);
    }

    void setListSelectionHidden(boolean hideListSelection) {
        this.mListSelectionHidden = hideListSelection;
    }

    private void updateSelectorStateCompat() {
        Drawable selector = this.getSelector();
        if (selector != null && this.touchModeDrawsInPressedStateCompat() && this.isPressed()) {
            selector.setState(this.getDrawableState());
        }
    }

    private void drawSelectorCompat(Canvas canvas) {
        Drawable selector;
        if (!this.mSelectorRect.isEmpty() && (selector = this.getSelector()) != null) {
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    private void positionSelectorLikeTouchCompat(int position, View sel, float x, float y) {
        this.positionSelectorLikeFocusCompat(position, sel);
        Drawable selector = this.getSelector();
        if (selector != null && position != -1) {
            DrawableCompat.setHotspot(selector, x, y);
        }
    }

    private void positionSelectorLikeFocusCompat(int position, View sel) {
        boolean manageState;
        Drawable selector = this.getSelector();
        boolean bl = manageState = selector != null && position != -1;
        if (manageState) {
            selector.setVisible(false, false);
        }
        this.positionSelectorCompat(position, sel);
        if (manageState) {
            Rect bounds = this.mSelectorRect;
            float x = bounds.exactCenterX();
            float y = bounds.exactCenterY();
            selector.setVisible(this.getVisibility() == 0, false);
            DrawableCompat.setHotspot(selector, x, y);
        }
    }

    private void positionSelectorCompat(int position, View sel) {
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        selectorRect.left -= this.mSelectionLeftPadding;
        selectorRect.top -= this.mSelectionTopPadding;
        selectorRect.right += this.mSelectionRightPadding;
        selectorRect.bottom += this.mSelectionBottomPadding;
        boolean isChildViewEnabled = this.superIsSelectedChildViewEnabled();
        if (sel.isEnabled() != isChildViewEnabled) {
            this.superSetSelectedChildViewEnabled(!isChildViewEnabled);
            if (position != -1) {
                this.refreshDrawableState();
            }
        }
    }

    private void clearPressedItem() {
        this.mDrawsInPressedState = false;
        this.setPressed(false);
        this.drawableStateChanged();
        View motionView = this.getChildAt(this.mMotionPosition - this.getFirstVisiblePosition());
        if (motionView != null) {
            motionView.setPressed(false);
        }
        if (this.mClickAnimation != null) {
            this.mClickAnimation.cancel();
            this.mClickAnimation = null;
        }
    }

    private void setPressedItem(View child, int position, float x, float y) {
        View motionView;
        this.mDrawsInPressedState = true;
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.drawableHotspotChanged((View)this, x, y);
        }
        if (!this.isPressed()) {
            this.setPressed(true);
        }
        this.layoutChildren();
        if (this.mMotionPosition != -1 && (motionView = this.getChildAt(this.mMotionPosition - this.getFirstVisiblePosition())) != null && motionView != child && motionView.isPressed()) {
            motionView.setPressed(false);
        }
        this.mMotionPosition = position;
        float childX = x - (float)child.getLeft();
        float childY = y - (float)child.getTop();
        if (Build.VERSION.SDK_INT >= 21) {
            Api21Impl.drawableHotspotChanged(child, childX, childY);
        }
        if (!child.isPressed()) {
            child.setPressed(true);
        }
        this.positionSelectorLikeTouchCompat(position, child, x, y);
        this.setSelectorEnabled(false);
        this.refreshDrawableState();
    }

    private boolean touchModeDrawsInPressedStateCompat() {
        return this.mDrawsInPressedState;
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static boolean isSelectedChildViewEnabled(AbsListView view) {
            return view.isSelectedChildViewEnabled();
        }

        @DoNotInline
        static void setSelectedChildViewEnabled(AbsListView view, boolean enabled) {
            view.setSelectedChildViewEnabled(enabled);
        }
    }

    static class PreApi33Impl {
        private static final Field sIsChildViewEnabled;

        private PreApi33Impl() {
        }

        static boolean isSelectedChildViewEnabled(AbsListView view) {
            if (sIsChildViewEnabled != null) {
                try {
                    return sIsChildViewEnabled.getBoolean(view);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        static void setSelectedChildViewEnabled(AbsListView view, boolean enabled) {
            if (sIsChildViewEnabled != null) {
                try {
                    sIsChildViewEnabled.set(view, enabled);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        static {
            Field isChildViewEnabled = null;
            try {
                isChildViewEnabled = AbsListView.class.getDeclaredField("mIsChildViewEnabled");
                isChildViewEnabled.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            sIsChildViewEnabled = isChildViewEnabled;
        }
    }

    private static class GateKeeperDrawable
    extends DrawableWrapperCompat {
        private boolean mEnabled = true;

        GateKeeperDrawable(Drawable drawable2) {
            super(drawable2);
        }

        void setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }

        @Override
        public boolean setState(int[] stateSet) {
            if (this.mEnabled) {
                return super.setState(stateSet);
            }
            return false;
        }

        @Override
        public void draw(@NonNull Canvas canvas) {
            if (this.mEnabled) {
                super.draw(canvas);
            }
        }

        @Override
        public void setHotspot(float x, float y) {
            if (this.mEnabled) {
                super.setHotspot(x, y);
            }
        }

        @Override
        public void setHotspotBounds(int left, int top, int right, int bottom) {
            if (this.mEnabled) {
                super.setHotspotBounds(left, top, right, bottom);
            }
        }

        @Override
        public boolean setVisible(boolean visible, boolean restart) {
            if (this.mEnabled) {
                return super.setVisible(visible, restart);
            }
            return false;
        }
    }

    private class ResolveHoverRunnable
    implements Runnable {
        ResolveHoverRunnable() {
        }

        @Override
        public void run() {
            DropDownListView.this.mResolveHoverRunnable = null;
            DropDownListView.this.drawableStateChanged();
        }

        public void cancel() {
            DropDownListView.this.mResolveHoverRunnable = null;
            DropDownListView.this.removeCallbacks(this);
        }

        public void post() {
            DropDownListView.this.post(this);
        }
    }

    @RequiresApi(value=30)
    static class Api30Impl {
        private static Method sPositionSelector;
        private static Method sSetSelectedPositionInt;
        private static Method sSetNextSelectedPositionInt;
        private static boolean sHasMethods;

        private Api30Impl() {
        }

        static boolean canPositionSelectorForHoveredItem() {
            return sHasMethods;
        }

        @SuppressLint(value={"BanUncheckedReflection"})
        static void positionSelectorForHoveredItem(DropDownListView view, int position, View sel) {
            try {
                sPositionSelector.invoke((Object)view, position, sel, false, -1, -1);
                sSetSelectedPositionInt.invoke((Object)view, position);
                sSetNextSelectedPositionInt.invoke((Object)view, position);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        static {
            try {
                sPositionSelector = AbsListView.class.getDeclaredMethod("positionSelector", Integer.TYPE, View.class, Boolean.TYPE, Float.TYPE, Float.TYPE);
                sPositionSelector.setAccessible(true);
                sSetSelectedPositionInt = AdapterView.class.getDeclaredMethod("setSelectedPositionInt", Integer.TYPE);
                sSetSelectedPositionInt.setAccessible(true);
                sSetNextSelectedPositionInt = AdapterView.class.getDeclaredMethod("setNextSelectedPositionInt", Integer.TYPE);
                sSetNextSelectedPositionInt.setAccessible(true);
                sHasMethods = true;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static void drawableHotspotChanged(View view, float x, float y) {
            view.drawableHotspotChanged(x, y);
        }
    }
}

