/*
 * Decompiled with CFR 0.152.
 */
package androidx.arch.core.executor;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.arch.core.executor.DefaultTaskExecutor;
import androidx.arch.core.executor.TaskExecutor;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class ArchTaskExecutor
extends TaskExecutor {
    private static volatile ArchTaskExecutor sInstance;
    @NonNull
    private TaskExecutor mDelegate;
    @NonNull
    private final TaskExecutor mDefaultTaskExecutor;
    @NonNull
    private static final Executor sMainThreadExecutor;
    @NonNull
    private static final Executor sIOThreadExecutor;

    private ArchTaskExecutor() {
        this.mDelegate = this.mDefaultTaskExecutor = new DefaultTaskExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ArchTaskExecutor getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<ArchTaskExecutor> clazz = ArchTaskExecutor.class;
        synchronized (ArchTaskExecutor.class) {
            if (sInstance == null) {
                sInstance = new ArchTaskExecutor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setDelegate(@Nullable TaskExecutor taskExecutor) {
        this.mDelegate = taskExecutor == null ? this.mDefaultTaskExecutor : taskExecutor;
    }

    @Override
    public void executeOnDiskIO(@NonNull Runnable runnable2) {
        this.mDelegate.executeOnDiskIO(runnable2);
    }

    @Override
    public void postToMainThread(@NonNull Runnable runnable2) {
        this.mDelegate.postToMainThread(runnable2);
    }

    @NonNull
    public static Executor getMainThreadExecutor() {
        return sMainThreadExecutor;
    }

    @NonNull
    public static Executor getIOThreadExecutor() {
        return sIOThreadExecutor;
    }

    @Override
    public boolean isMainThread() {
        return this.mDelegate.isMainThread();
    }

    static {
        sMainThreadExecutor = command2 -> ArchTaskExecutor.getInstance().postToMainThread(command2);
        sIOThreadExecutor = command2 -> ArchTaskExecutor.getInstance().executeOnDiskIO(command2);
    }
}

