/*
 * Decompiled with CFR 0.152.
 */
package androidx.arch.core.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class SafeIterableMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    Entry<K, V> mStart;
    private Entry<K, V> mEnd;
    private final WeakHashMap<SupportRemove<K, V>, Boolean> mIterators = new WeakHashMap();
    private int mSize = 0;

    @Nullable
    protected Entry<K, V> get(K k) {
        Entry<K, V> currentNode = this.mStart;
        while (currentNode != null && !currentNode.mKey.equals(k)) {
            currentNode = currentNode.mNext;
        }
        return currentNode;
    }

    public V putIfAbsent(@NonNull K key, @NonNull V v) {
        Entry<K, V> entry = this.get(key);
        if (entry != null) {
            return entry.mValue;
        }
        this.put(key, v);
        return null;
    }

    Entry<K, V> put(@NonNull K key, @NonNull V v) {
        Entry<K, V> newEntry = new Entry<K, V>(key, v);
        ++this.mSize;
        if (this.mEnd == null) {
            this.mStart = newEntry;
            this.mEnd = this.mStart;
            return newEntry;
        }
        this.mEnd.mNext = newEntry;
        newEntry.mPrevious = this.mEnd;
        this.mEnd = newEntry;
        return newEntry;
    }

    public V remove(@NonNull K key) {
        Entry<K, V> toRemove = this.get(key);
        if (toRemove == null) {
            return null;
        }
        --this.mSize;
        if (!this.mIterators.isEmpty()) {
            for (SupportRemove<K, V> iter : this.mIterators.keySet()) {
                iter.supportRemove(toRemove);
            }
        }
        if (toRemove.mPrevious != null) {
            toRemove.mPrevious.mNext = toRemove.mNext;
        } else {
            this.mStart = toRemove.mNext;
        }
        if (toRemove.mNext != null) {
            toRemove.mNext.mPrevious = toRemove.mPrevious;
        } else {
            this.mEnd = toRemove.mPrevious;
        }
        toRemove.mNext = null;
        toRemove.mPrevious = null;
        return toRemove.mValue;
    }

    public int size() {
        return this.mSize;
    }

    @Override
    @NonNull
    public Iterator<Map.Entry<K, V>> iterator() {
        AscendingIterator<K, V> iterator2 = new AscendingIterator<K, V>(this.mStart, this.mEnd);
        this.mIterators.put(iterator2, false);
        return iterator2;
    }

    @NonNull
    public Iterator<Map.Entry<K, V>> descendingIterator() {
        DescendingIterator<K, V> iterator2 = new DescendingIterator<K, V>(this.mEnd, this.mStart);
        this.mIterators.put(iterator2, false);
        return iterator2;
    }

    @NonNull
    public IteratorWithAdditions iteratorWithAdditions() {
        IteratorWithAdditions iterator2 = new IteratorWithAdditions();
        this.mIterators.put(iterator2, false);
        return iterator2;
    }

    @Nullable
    public Map.Entry<K, V> eldest() {
        return this.mStart;
    }

    @Nullable
    public Map.Entry<K, V> newest() {
        return this.mEnd;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeIterableMap)) {
            return false;
        }
        SafeIterableMap map2 = (SafeIterableMap)obj;
        if (this.size() != map2.size()) {
            return false;
        }
        Iterator<Map.Entry<K, V>> iterator1 = this.iterator();
        Iterator<Map.Entry<K, V>> iterator2 = map2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Map.Entry<K, V> next1 = iterator1.next();
            Map.Entry<K, V> next2 = iterator2.next();
            if ((next1 != null || next2 == null) && (next1 == null || next1.equals(next2))) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> kvEntry : this) {
            h += kvEntry.hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<Map.Entry<K, V>> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            builder.append(iterator2.next().toString());
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        @NonNull
        final K mKey;
        @NonNull
        final V mValue;
        Entry<K, V> mNext;
        Entry<K, V> mPrevious;

        Entry(@NonNull K key, @NonNull V value) {
            this.mKey = key;
            this.mValue = value;
        }

        @Override
        @NonNull
        public K getKey() {
            return this.mKey;
        }

        @Override
        @NonNull
        public V getValue() {
            return this.mValue;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("An entry modification is not supported");
        }

        public String toString() {
            return this.mKey + "=" + this.mValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            return this.mKey.equals(entry.mKey) && this.mValue.equals(entry.mValue);
        }

        @Override
        public int hashCode() {
            return this.mKey.hashCode() ^ this.mValue.hashCode();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static abstract class SupportRemove<K, V> {
        abstract void supportRemove(@NonNull Entry<K, V> var1);
    }

    static class AscendingIterator<K, V>
    extends ListIterator<K, V> {
        AscendingIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            super(start, expectedEnd);
        }

        @Override
        Entry<K, V> forward(Entry<K, V> entry) {
            return entry.mNext;
        }

        @Override
        Entry<K, V> backward(Entry<K, V> entry) {
            return entry.mPrevious;
        }
    }

    private static class DescendingIterator<K, V>
    extends ListIterator<K, V> {
        DescendingIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            super(start, expectedEnd);
        }

        @Override
        Entry<K, V> forward(Entry<K, V> entry) {
            return entry.mPrevious;
        }

        @Override
        Entry<K, V> backward(Entry<K, V> entry) {
            return entry.mNext;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public class IteratorWithAdditions
    extends SupportRemove<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private Entry<K, V> mCurrent;
        private boolean mBeforeStart = true;

        IteratorWithAdditions() {
        }

        @Override
        void supportRemove(@NonNull Entry<K, V> entry) {
            if (entry == this.mCurrent) {
                this.mCurrent = this.mCurrent.mPrevious;
                this.mBeforeStart = this.mCurrent == null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.mBeforeStart) {
                return SafeIterableMap.this.mStart != null;
            }
            return this.mCurrent != null && this.mCurrent.mNext != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.mBeforeStart) {
                this.mBeforeStart = false;
                this.mCurrent = SafeIterableMap.this.mStart;
            } else {
                this.mCurrent = this.mCurrent != null ? this.mCurrent.mNext : null;
            }
            return this.mCurrent;
        }
    }

    private static abstract class ListIterator<K, V>
    extends SupportRemove<K, V>
    implements Iterator<Map.Entry<K, V>> {
        Entry<K, V> mExpectedEnd;
        Entry<K, V> mNext;

        ListIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            this.mExpectedEnd = expectedEnd;
            this.mNext = start;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public void supportRemove(@NonNull Entry<K, V> entry) {
            if (this.mExpectedEnd == entry && entry == this.mNext) {
                this.mNext = null;
                this.mExpectedEnd = null;
            }
            if (this.mExpectedEnd == entry) {
                this.mExpectedEnd = this.backward(this.mExpectedEnd);
            }
            if (this.mNext == entry) {
                this.mNext = this.nextNode();
            }
        }

        private Entry<K, V> nextNode() {
            if (this.mNext == this.mExpectedEnd || this.mExpectedEnd == null) {
                return null;
            }
            return this.forward(this.mNext);
        }

        @Override
        public Map.Entry<K, V> next() {
            Entry<K, V> result2 = this.mNext;
            this.mNext = this.nextNode();
            return result2;
        }

        abstract Entry<K, V> forward(Entry<K, V> var1);

        abstract Entry<K, V> backward(Entry<K, V> var1);
    }
}

