/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.MotionWidget;

public class CustomVariable {
    private static final String TAG = "TransitionLayout";
    String mName;
    private int mType;
    private int mIntegerValue = Integer.MIN_VALUE;
    private float mFloatValue = Float.NaN;
    private String mStringValue = null;
    boolean mBooleanValue;

    public CustomVariable copy() {
        return new CustomVariable(this);
    }

    public CustomVariable(CustomVariable c) {
        this.mName = c.mName;
        this.mType = c.mType;
        this.mIntegerValue = c.mIntegerValue;
        this.mFloatValue = c.mFloatValue;
        this.mStringValue = c.mStringValue;
        this.mBooleanValue = c.mBooleanValue;
    }

    public CustomVariable(String name, int type, String value) {
        this.mName = name;
        this.mType = type;
        this.mStringValue = value;
    }

    public CustomVariable(String name, int type, int value) {
        this.mName = name;
        this.mType = type;
        if (type == 901) {
            this.mFloatValue = value;
        } else {
            this.mIntegerValue = value;
        }
    }

    public CustomVariable(String name, int type, float value) {
        this.mName = name;
        this.mType = type;
        this.mFloatValue = value;
    }

    public CustomVariable(String name, int type, boolean value) {
        this.mName = name;
        this.mType = type;
        this.mBooleanValue = value;
    }

    public static String colorString(int v) {
        String str = "00000000" + Integer.toHexString(v);
        return "#" + str.substring(str.length() - 8);
    }

    public String toString() {
        String str = this.mName + ':';
        switch (this.mType) {
            case 900: {
                return str + this.mIntegerValue;
            }
            case 901: {
                return str + this.mFloatValue;
            }
            case 902: {
                return str + CustomVariable.colorString(this.mIntegerValue);
            }
            case 903: {
                return str + this.mStringValue;
            }
            case 904: {
                return str + Boolean.valueOf(this.mBooleanValue);
            }
            case 905: {
                return str + this.mFloatValue;
            }
        }
        return str + "????";
    }

    public int getType() {
        return this.mType;
    }

    public boolean getBooleanValue() {
        return this.mBooleanValue;
    }

    public float getFloatValue() {
        return this.mFloatValue;
    }

    public int getColorValue() {
        return this.mIntegerValue;
    }

    public int getIntegerValue() {
        return this.mIntegerValue;
    }

    public String getStringValue() {
        return this.mStringValue;
    }

    public boolean isContinuous() {
        switch (this.mType) {
            case 903: 
            case 904: 
            case 906: {
                return false;
            }
        }
        return true;
    }

    public void setFloatValue(float value) {
        this.mFloatValue = value;
    }

    public void setBooleanValue(boolean value) {
        this.mBooleanValue = value;
    }

    public void setIntValue(int value) {
        this.mIntegerValue = value;
    }

    public void setStringValue(String value) {
        this.mStringValue = value;
    }

    public int numberOfInterpolatedValues() {
        switch (this.mType) {
            case 902: {
                return 4;
            }
        }
        return 1;
    }

    public float getValueToInterpolate() {
        switch (this.mType) {
            case 900: {
                return this.mIntegerValue;
            }
            case 901: {
                return this.mFloatValue;
            }
            case 902: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 904: {
                return this.mBooleanValue ? 1.0f : 0.0f;
            }
            case 905: {
                return this.mFloatValue;
            }
        }
        return Float.NaN;
    }

    public void getValuesToInterpolate(float[] ret) {
        switch (this.mType) {
            case 900: {
                ret[0] = this.mIntegerValue;
                break;
            }
            case 901: {
                ret[0] = this.mFloatValue;
                break;
            }
            case 902: {
                int a = 0xFF & this.mIntegerValue >> 24;
                int r = 0xFF & this.mIntegerValue >> 16;
                int g = 0xFF & this.mIntegerValue >> 8;
                int b = 0xFF & this.mIntegerValue;
                float f_r = (float)Math.pow((float)r / 255.0f, 2.2);
                float f_g = (float)Math.pow((float)g / 255.0f, 2.2);
                float f_b = (float)Math.pow((float)b / 255.0f, 2.2);
                ret[0] = f_r;
                ret[1] = f_g;
                ret[2] = f_b;
                ret[3] = (float)a / 255.0f;
                break;
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 904: {
                ret[0] = this.mBooleanValue ? 1.0f : 0.0f;
                break;
            }
            case 905: {
                ret[0] = this.mFloatValue;
            }
        }
    }

    public void setValue(float[] value) {
        switch (this.mType) {
            case 900: 
            case 906: {
                this.mIntegerValue = (int)value[0];
                break;
            }
            case 901: 
            case 905: {
                this.mFloatValue = value[0];
                break;
            }
            case 902: {
                float f_r = value[0];
                float f_g = value[1];
                float f_b = value[2];
                int r = 0xFF & Math.round((float)Math.pow(f_r, 0.5) * 255.0f);
                int g = 0xFF & Math.round((float)Math.pow(f_g, 0.5) * 255.0f);
                int b = 0xFF & Math.round((float)Math.pow(f_b, 0.5) * 255.0f);
                int a = 0xFF & Math.round(value[3] * 255.0f);
                this.mIntegerValue = a << 24 | r << 16 | g << 8 | b;
                break;
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 904: {
                this.mBooleanValue = (double)value[0] > 0.5;
            }
        }
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        int p = (int)(0.5f + 255.0f * value * (1.0f - saturation));
        int q = (int)(0.5f + 255.0f * value * (1.0f - f * saturation));
        int t = (int)(0.5f + 255.0f * value * (1.0f - (1.0f - f) * saturation));
        int v = (int)(0.5f + 255.0f * value);
        switch (h) {
            case 0: {
                return 0xFF000000 | (v << 16) + (t << 8) + p;
            }
            case 1: {
                return 0xFF000000 | (q << 16) + (v << 8) + p;
            }
            case 2: {
                return 0xFF000000 | (p << 16) + (v << 8) + t;
            }
            case 3: {
                return 0xFF000000 | (p << 16) + (q << 8) + v;
            }
            case 4: {
                return 0xFF000000 | (t << 16) + (p << 8) + v;
            }
            case 5: {
                return 0xFF000000 | (v << 16) + (p << 8) + q;
            }
        }
        return 0;
    }

    public boolean diff(CustomVariable CustomAttribute2) {
        if (CustomAttribute2 == null || this.mType != CustomAttribute2.mType) {
            return false;
        }
        switch (this.mType) {
            case 900: 
            case 906: {
                return this.mIntegerValue == CustomAttribute2.mIntegerValue;
            }
            case 901: {
                return this.mFloatValue == CustomAttribute2.mFloatValue;
            }
            case 902: {
                return this.mIntegerValue == CustomAttribute2.mIntegerValue;
            }
            case 903: {
                return this.mIntegerValue == CustomAttribute2.mIntegerValue;
            }
            case 904: {
                return this.mBooleanValue == CustomAttribute2.mBooleanValue;
            }
            case 905: {
                return this.mFloatValue == CustomAttribute2.mFloatValue;
            }
        }
        return false;
    }

    public CustomVariable(String name, int attributeType) {
        this.mName = name;
        this.mType = attributeType;
    }

    public CustomVariable(String name, int attributeType, Object value) {
        this.mName = name;
        this.mType = attributeType;
        this.setValue(value);
    }

    public CustomVariable(CustomVariable source, Object value) {
        this.mName = source.mName;
        this.mType = source.mType;
        this.setValue(value);
    }

    public void setValue(Object value) {
        switch (this.mType) {
            case 900: 
            case 906: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case 901: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            case 902: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case 903: {
                this.mStringValue = (String)value;
                break;
            }
            case 904: {
                this.mBooleanValue = (Boolean)value;
                break;
            }
            case 905: {
                this.mFloatValue = ((Float)value).floatValue();
            }
        }
    }

    private static int clamp(int c) {
        int N = 255;
        c &= ~(c >> 31);
        c -= N;
        c &= c >> 31;
        return c += N;
    }

    public int getInterpolatedColor(float[] value) {
        int r = CustomVariable.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
        int g = CustomVariable.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
        int b = CustomVariable.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
        int a = CustomVariable.clamp((int)(value[3] * 255.0f));
        int color2 = a << 24 | r << 16 | g << 8 | b;
        return color2;
    }

    public void setInterpolatedValue(MotionWidget view, float[] value) {
        switch (this.mType) {
            case 900: {
                view.setCustomAttribute(this.mName, this.mType, (int)value[0]);
                break;
            }
            case 902: {
                int r = CustomVariable.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
                int g = CustomVariable.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
                int b = CustomVariable.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
                int a = CustomVariable.clamp((int)(value[3] * 255.0f));
                int color2 = a << 24 | r << 16 | g << 8 | b;
                view.setCustomAttribute(this.mName, this.mType, color2);
                break;
            }
            case 903: 
            case 906: {
                throw new RuntimeException("unable to interpolate " + this.mName);
            }
            case 904: {
                view.setCustomAttribute(this.mName, this.mType, value[0] > 0.5f);
                break;
            }
            case 901: 
            case 905: {
                view.setCustomAttribute(this.mName, this.mType, value[0]);
            }
        }
    }

    public static int rgbaTocColor(float r, float g, float b, float a) {
        int ir = CustomVariable.clamp((int)(r * 255.0f));
        int ig = CustomVariable.clamp((int)(g * 255.0f));
        int ib = CustomVariable.clamp((int)(b * 255.0f));
        int ia = CustomVariable.clamp((int)(a * 255.0f));
        int color2 = ia << 24 | ir << 16 | ig << 8 | ib;
        return color2;
    }

    public void applyToWidget(MotionWidget view) {
        switch (this.mType) {
            case 900: 
            case 902: 
            case 906: {
                view.setCustomAttribute(this.mName, this.mType, this.mIntegerValue);
                break;
            }
            case 903: {
                view.setCustomAttribute(this.mName, this.mType, this.mStringValue);
                break;
            }
            case 904: {
                view.setCustomAttribute(this.mName, this.mType, this.mBooleanValue);
                break;
            }
            case 901: 
            case 905: {
                view.setCustomAttribute(this.mName, this.mType, this.mFloatValue);
            }
        }
    }

    public String getName() {
        return this.mName;
    }
}

