/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.state.WidgetFrame;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.Set;

public class MotionWidget
implements TypedValues {
    WidgetFrame widgetFrame = new WidgetFrame();
    Motion motion = new Motion();
    PropertySet propertySet = new PropertySet();
    private float mProgress;
    float mTransitionPathRotate;
    public static final int VISIBILITY_MODE_NORMAL = 0;
    public static final int VISIBILITY_MODE_IGNORE = 1;
    private static final int INTERNAL_MATCH_PARENT = -1;
    private static final int INTERNAL_WRAP_CONTENT = -2;
    public static final int INVISIBLE = 0;
    public static final int VISIBLE = 4;
    private static final int INTERNAL_MATCH_CONSTRAINT = -3;
    private static final int INTERNAL_WRAP_CONTENT_CONSTRAINED = -4;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_PORTRATE_OF_RIGHT = 1;
    public static final int ROTATE_PORTRATE_OF_LEFT = 2;
    public static final int ROTATE_RIGHT_OF_PORTRATE = 3;
    public static final int ROTATE_LEFT_OF_PORTRATE = 4;
    public static final int UNSET = -1;
    public static final int MATCH_CONSTRAINT = 0;
    public static final int PARENT_ID = 0;
    public static final int FILL_PARENT = -1;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    public static final int GONE_UNSET = Integer.MIN_VALUE;
    public static final int MATCH_CONSTRAINT_WRAP = 1;

    public MotionWidget() {
    }

    public MotionWidget getParent() {
        return null;
    }

    public MotionWidget findViewById(int mTransformPivotTarget) {
        return null;
    }

    public void setVisibility(int visibility) {
        this.propertySet.visibility = visibility;
    }

    public String getName() {
        return this.widgetFrame.getId();
    }

    public void layout(int l, int t, int r, int b) {
        this.setBounds(l, t, r, b);
    }

    public String toString() {
        return this.widgetFrame.left + ", " + this.widgetFrame.top + ", " + this.widgetFrame.right + ", " + this.widgetFrame.bottom;
    }

    public void setBounds(int left, int top, int right, int bottom) {
        if (this.widgetFrame == null) {
            this.widgetFrame = new WidgetFrame((ConstraintWidget)null);
        }
        this.widgetFrame.top = top;
        this.widgetFrame.left = left;
        this.widgetFrame.right = right;
        this.widgetFrame.bottom = bottom;
    }

    public MotionWidget(WidgetFrame f) {
        this.widgetFrame = f;
    }

    @Override
    public boolean setValue(int id2, int value) {
        return this.setValueAttributes(id2, value);
    }

    @Override
    public boolean setValue(int id2, float value) {
        boolean set = this.setValueAttributes(id2, value);
        if (set) {
            return true;
        }
        return this.setValueMotion(id2, value);
    }

    @Override
    public boolean setValue(int id2, String value) {
        return this.setValueMotion(id2, value);
    }

    @Override
    public boolean setValue(int id2, boolean value) {
        return false;
    }

    public boolean setValueMotion(int id2, int value) {
        switch (id2) {
            case 605: {
                this.motion.mAnimateRelativeTo = value;
                break;
            }
            case 606: {
                this.motion.mAnimateCircleAngleTo = value;
                break;
            }
            case 607: {
                this.motion.mPathMotionArc = value;
                break;
            }
            case 608: {
                this.motion.mDrawPath = value;
                break;
            }
            case 609: {
                this.motion.mPolarRelativeTo = value;
                break;
            }
            case 610: {
                this.motion.mQuantizeMotionSteps = value;
                break;
            }
            case 611: {
                this.motion.mQuantizeInterpolatorType = value;
                break;
            }
            case 612: {
                this.motion.mQuantizeInterpolatorID = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValueMotion(int id2, String value) {
        switch (id2) {
            case 603: {
                this.motion.mTransitionEasing = value;
                break;
            }
            case 604: {
                this.motion.mQuantizeInterpolatorString = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValueMotion(int id2, float value) {
        switch (id2) {
            case 600: {
                this.motion.mMotionStagger = value;
                break;
            }
            case 601: {
                this.motion.mPathRotate = value;
                break;
            }
            case 602: {
                this.motion.mQuantizeMotionPhase = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValueAttributes(int id2, float value) {
        switch (id2) {
            case 303: {
                this.widgetFrame.alpha = value;
                break;
            }
            case 304: {
                this.widgetFrame.translationX = value;
                break;
            }
            case 305: {
                this.widgetFrame.translationY = value;
                break;
            }
            case 306: {
                this.widgetFrame.translationZ = value;
                break;
            }
            case 308: {
                this.widgetFrame.rotationX = value;
                break;
            }
            case 309: {
                this.widgetFrame.rotationY = value;
                break;
            }
            case 310: {
                this.widgetFrame.rotationZ = value;
                break;
            }
            case 311: {
                this.widgetFrame.scaleX = value;
                break;
            }
            case 312: {
                this.widgetFrame.scaleY = value;
                break;
            }
            case 313: {
                this.widgetFrame.pivotX = value;
                break;
            }
            case 314: {
                this.widgetFrame.pivotY = value;
                break;
            }
            case 315: {
                this.mProgress = value;
                break;
            }
            case 316: {
                this.mTransitionPathRotate = value;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public float getValueAttributes(int id2) {
        switch (id2) {
            case 303: {
                return this.widgetFrame.alpha;
            }
            case 304: {
                return this.widgetFrame.translationX;
            }
            case 305: {
                return this.widgetFrame.translationY;
            }
            case 306: {
                return this.widgetFrame.translationZ;
            }
            case 308: {
                return this.widgetFrame.rotationX;
            }
            case 309: {
                return this.widgetFrame.rotationY;
            }
            case 310: {
                return this.widgetFrame.rotationZ;
            }
            case 311: {
                return this.widgetFrame.scaleX;
            }
            case 312: {
                return this.widgetFrame.scaleY;
            }
            case 313: {
                return this.widgetFrame.pivotX;
            }
            case 314: {
                return this.widgetFrame.pivotY;
            }
            case 315: {
                return this.mProgress;
            }
            case 316: {
                return this.mTransitionPathRotate;
            }
        }
        return Float.NaN;
    }

    @Override
    public int getId(String name) {
        int ret = TypedValues.AttributesType.getId(name);
        if (ret != -1) {
            return ret;
        }
        return TypedValues.MotionType.getId(name);
    }

    public int getTop() {
        return this.widgetFrame.top;
    }

    public int getLeft() {
        return this.widgetFrame.left;
    }

    public int getBottom() {
        return this.widgetFrame.bottom;
    }

    public int getRight() {
        return this.widgetFrame.right;
    }

    public void setPivotX(float px) {
        this.widgetFrame.pivotX = px;
    }

    public void setPivotY(float py) {
        this.widgetFrame.pivotY = py;
    }

    public float getRotationX() {
        return this.widgetFrame.rotationX;
    }

    public void setRotationX(float rotationX) {
        this.widgetFrame.rotationX = rotationX;
    }

    public float getRotationY() {
        return this.widgetFrame.rotationY;
    }

    public void setRotationY(float rotationY) {
        this.widgetFrame.rotationY = rotationY;
    }

    public float getRotationZ() {
        return this.widgetFrame.rotationZ;
    }

    public void setRotationZ(float rotationZ) {
        this.widgetFrame.rotationZ = rotationZ;
    }

    public float getTranslationX() {
        return this.widgetFrame.translationX;
    }

    public void setTranslationX(float translationX) {
        this.widgetFrame.translationX = translationX;
    }

    public float getTranslationY() {
        return this.widgetFrame.translationY;
    }

    public void setTranslationY(float translationY) {
        this.widgetFrame.translationY = translationY;
    }

    public void setTranslationZ(float tz) {
        this.widgetFrame.translationZ = tz;
    }

    public float getTranslationZ() {
        return this.widgetFrame.translationZ;
    }

    public float getScaleX() {
        return this.widgetFrame.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.widgetFrame.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.widgetFrame.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.widgetFrame.scaleY = scaleY;
    }

    public int getVisibility() {
        return this.propertySet.visibility;
    }

    public float getPivotX() {
        return this.widgetFrame.pivotX;
    }

    public float getPivotY() {
        return this.widgetFrame.pivotY;
    }

    public float getAlpha() {
        return this.propertySet.alpha;
    }

    public int getX() {
        return this.widgetFrame.left;
    }

    public int getY() {
        return this.widgetFrame.top;
    }

    public int getWidth() {
        return this.widgetFrame.right - this.widgetFrame.left;
    }

    public int getHeight() {
        return this.widgetFrame.bottom - this.widgetFrame.top;
    }

    public WidgetFrame getWidgetFrame() {
        return this.widgetFrame;
    }

    public Set<String> getCustomAttributeNames() {
        return this.widgetFrame.getCustomAttributeNames();
    }

    public void setCustomAttribute(String name, int type, float value) {
        this.widgetFrame.setCustomAttribute(name, type, value);
    }

    public void setCustomAttribute(String name, int type, int value) {
        this.widgetFrame.setCustomAttribute(name, type, value);
    }

    public void setCustomAttribute(String name, int type, boolean value) {
        this.widgetFrame.setCustomAttribute(name, type, value);
    }

    public void setCustomAttribute(String name, int type, String value) {
        this.widgetFrame.setCustomAttribute(name, type, value);
    }

    public CustomVariable getCustomAttribute(String name) {
        return this.widgetFrame.getCustomAttribute(name);
    }

    public void setInterpolatedValue(CustomAttribute attribute, float[] mCache) {
        this.widgetFrame.setCustomAttribute(attribute.mName, 901, mCache[0]);
    }

    public static class PropertySet {
        public int visibility = 4;
        public int mVisibilityMode = 0;
        public float alpha = 1.0f;
        public float mProgress = Float.NaN;
    }

    public static class Motion {
        public int mAnimateRelativeTo = -1;
        public int mAnimateCircleAngleTo = 0;
        public String mTransitionEasing = null;
        public int mPathMotionArc = -1;
        public int mDrawPath = 0;
        public float mMotionStagger = Float.NaN;
        public int mPolarRelativeTo = -1;
        public float mPathRotate = Float.NaN;
        public float mQuantizeMotionPhase = Float.NaN;
        public int mQuantizeMotionSteps = -1;
        public String mQuantizeInterpolatorString = null;
        public int mQuantizeInterpolatorType = -3;
        public int mQuantizeInterpolatorID = -1;
        private static final int INTERPOLATOR_REFERENCE_ID = -2;
        private static final int SPLINE_STRING = -1;
        private static final int INTERPOLATOR_UNDEFINED = -3;
    }
}

