/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.motion.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;

public class MotionKeyCycle
extends MotionKey {
    private static final String TAG = "KeyCycle";
    static final String NAME = "KeyCycle";
    public static final String WAVE_PERIOD = "wavePeriod";
    public static final String WAVE_OFFSET = "waveOffset";
    public static final String WAVE_PHASE = "wavePhase";
    public static final String WAVE_SHAPE = "waveShape";
    public static final int SHAPE_SIN_WAVE = 0;
    public static final int SHAPE_SQUARE_WAVE = 1;
    public static final int SHAPE_TRIANGLE_WAVE = 2;
    public static final int SHAPE_SAW_WAVE = 3;
    public static final int SHAPE_REVERSE_SAW_WAVE = 4;
    public static final int SHAPE_COS_WAVE = 5;
    public static final int SHAPE_BOUNCE = 6;
    private String mTransitionEasing = null;
    private int mCurveFit = 0;
    private int mWaveShape = -1;
    private String mCustomWaveShape = null;
    private float mWavePeriod = Float.NaN;
    private float mWaveOffset = 0.0f;
    private float mWavePhase = 0.0f;
    private float mProgress = Float.NaN;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    public static final int KEY_TYPE = 4;

    public MotionKeyCycle() {
        this.mType = 4;
        this.mCustom = new HashMap();
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotationZ");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("pathRotate");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (this.mCustom.size() > 0) {
            for (String s : this.mCustom.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
    }

    @Override
    public boolean setValue(int type, int value) {
        switch (type) {
            case 401: {
                this.mCurveFit = value;
                return true;
            }
            case 421: {
                this.mWaveShape = value;
                return true;
            }
        }
        boolean ret = this.setValue(type, (float)value);
        if (ret) {
            return true;
        }
        return super.setValue(type, value);
    }

    @Override
    public boolean setValue(int type, String value) {
        switch (type) {
            case 420: {
                this.mTransitionEasing = value;
                return true;
            }
            case 422: {
                this.mCustomWaveShape = value;
                return true;
            }
        }
        return super.setValue(type, value);
    }

    @Override
    public boolean setValue(int type, float value) {
        switch (type) {
            case 403: {
                this.mAlpha = value;
                break;
            }
            case 304: {
                this.mTranslationX = value;
                break;
            }
            case 305: {
                this.mTranslationY = value;
                break;
            }
            case 306: {
                this.mTranslationZ = value;
                break;
            }
            case 307: {
                this.mElevation = value;
                break;
            }
            case 308: {
                this.mRotationX = value;
                break;
            }
            case 309: {
                this.mRotationY = value;
                break;
            }
            case 310: {
                this.mRotation = value;
                break;
            }
            case 311: {
                this.mScaleX = value;
                break;
            }
            case 312: {
                this.mScaleY = value;
                break;
            }
            case 315: {
                this.mProgress = value;
                break;
            }
            case 416: {
                this.mTransitionPathRotate = value;
                break;
            }
            case 423: {
                this.mWavePeriod = value;
                break;
            }
            case 424: {
                this.mWaveOffset = value;
                break;
            }
            case 425: {
                this.mWavePhase = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    public float getValue(String key) {
        switch (key) {
            case "alpha": {
                return this.mAlpha;
            }
            case "elevation": {
                return this.mElevation;
            }
            case "rotationZ": {
                return this.mRotation;
            }
            case "rotationX": {
                return this.mRotationX;
            }
            case "rotationY": {
                return this.mRotationY;
            }
            case "pathRotate": {
                return this.mTransitionPathRotate;
            }
            case "scaleX": {
                return this.mScaleX;
            }
            case "scaleY": {
                return this.mScaleY;
            }
            case "translationX": {
                return this.mTranslationX;
            }
            case "translationY": {
                return this.mTranslationY;
            }
            case "translationZ": {
                return this.mTranslationZ;
            }
            case "offset": {
                return this.mWaveOffset;
            }
            case "phase": {
                return this.mWavePhase;
            }
            case "progress": {
                return this.mProgress;
            }
        }
        return Float.NaN;
    }

    @Override
    public MotionKey clone() {
        return null;
    }

    @Override
    public int getId(String name) {
        switch (name) {
            case "curveFit": {
                return 401;
            }
            case "visibility": {
                return 402;
            }
            case "alpha": {
                return 403;
            }
            case "translationX": {
                return 304;
            }
            case "translationY": {
                return 305;
            }
            case "translationZ": {
                return 306;
            }
            case "rotationX": {
                return 308;
            }
            case "rotationY": {
                return 309;
            }
            case "rotationZ": {
                return 310;
            }
            case "scaleX": {
                return 311;
            }
            case "scaleY": {
                return 312;
            }
            case "pivotX": {
                return 313;
            }
            case "pivotY": {
                return 314;
            }
            case "progress": {
                return 315;
            }
            case "pathRotate": {
                return 416;
            }
            case "easing": {
                return 420;
            }
            case "period": {
                return 423;
            }
            case "waveShape": {
                return 421;
            }
            case "phase": {
                return 425;
            }
            case "offset": {
                return 424;
            }
            case "customWave": {
                return 422;
            }
        }
        return -1;
    }

    public void addCycleValues(HashMap<String, KeyCycleOscillator> oscSet) {
        for (String key : oscSet.keySet()) {
            KeyCycleOscillator osc;
            if (key.startsWith("CUSTOM")) {
                KeyCycleOscillator osc2;
                String customKey = key.substring("CUSTOM".length() + 1);
                CustomVariable cValue = (CustomVariable)this.mCustom.get(customKey);
                if (cValue == null || cValue.getType() != 901 || (osc2 = oscSet.get(key)) == null) continue;
                osc2.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, -1, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, cValue.getValueToInterpolate(), cValue);
                continue;
            }
            float value = this.getValue(key);
            if (Float.isNaN(value) || (osc = oscSet.get(key)) == null) continue;
            osc.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, -1, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, value);
        }
    }

    public void dump() {
        System.out.println("MotionKeyCycle{mWaveShape=" + this.mWaveShape + ", mWavePeriod=" + this.mWavePeriod + ", mWaveOffset=" + this.mWaveOffset + ", mWavePhase=" + this.mWavePhase + ", mRotation=" + this.mRotation + '}');
    }

    public void printAttributes() {
        HashSet<String> nameSet = new HashSet<String>();
        this.getAttributeNames(nameSet);
        Utils.log(" ------------- " + this.mFramePosition + " -------------");
        Utils.log("MotionKeyCycle{Shape=" + this.mWaveShape + ", Period=" + this.mWavePeriod + ", Offset=" + this.mWaveOffset + ", Phase=" + this.mWavePhase + '}');
        String[] names = nameSet.toArray(new String[0]);
        for (int i = 0; i < names.length; ++i) {
            int id2 = TypedValues.AttributesType.getId(names[i]);
            Utils.log(names[i] + ":" + this.getValue(names[i]));
        }
    }
}

