/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.MonotonicCurveFit;
import java.util.Arrays;

public class StepCurve
extends Easing {
    private static final boolean DEBUG = false;
    MonotonicCurveFit mCurveFit;

    StepCurve(String configString) {
        String tmp;
        this.str = configString;
        double[] values2 = new double[this.str.length() / 2];
        int start = configString.indexOf(40) + 1;
        int off1 = configString.indexOf(44, start);
        int count2 = 0;
        while (off1 != -1) {
            tmp = configString.substring(start, off1).trim();
            values2[count2++] = Double.parseDouble(tmp);
            start = off1 + 1;
            off1 = configString.indexOf(44, start);
        }
        off1 = configString.indexOf(41, start);
        tmp = configString.substring(start, off1).trim();
        values2[count2++] = Double.parseDouble(tmp);
        this.mCurveFit = StepCurve.genSpline(Arrays.copyOf(values2, count2));
    }

    private static MonotonicCurveFit genSpline(String str) {
        String wave = str;
        String[] sp = wave.split("\\s+");
        double[] values2 = new double[sp.length];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = Double.parseDouble(sp[i]);
        }
        return StepCurve.genSpline(values2);
    }

    private static MonotonicCurveFit genSpline(double[] values2) {
        int length = values2.length * 3 - 2;
        int len = values2.length - 1;
        double gap = 1.0 / (double)len;
        double[][] points = new double[length][1];
        double[] time = new double[length];
        for (int i = 0; i < values2.length; ++i) {
            double v;
            points[i + len][0] = v = values2[i];
            time[i + len] = (double)i * gap;
            if (i <= 0) continue;
            points[i + len * 2][0] = v + 1.0;
            time[i + len * 2] = (double)i * gap + 1.0;
            points[i - 1][0] = v - 1.0 - gap;
            time[i - 1] = (double)i * gap + -1.0 - gap;
        }
        MonotonicCurveFit ms = new MonotonicCurveFit(time, points);
        System.out.println(" 0 " + ms.getPos(0.0, 0));
        System.out.println(" 1 " + ms.getPos(1.0, 0));
        return ms;
    }

    @Override
    public double getDiff(double x) {
        return this.mCurveFit.getSlope(x, 0);
    }

    @Override
    public double get(double x) {
        return this.mCurveFit.getPos(x, 0);
    }
}

