/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.state.RegistryCallback;
import java.util.HashMap;
import java.util.Set;

public class Registry {
    private static final Registry sRegistry = new Registry();
    private HashMap<String, RegistryCallback> mCallbacks = new HashMap();

    public static Registry getInstance() {
        return sRegistry;
    }

    public void register(String name, RegistryCallback callback2) {
        this.mCallbacks.put(name, callback2);
    }

    public void unregister(String name, RegistryCallback callback2) {
        this.mCallbacks.remove(name);
    }

    public void updateContent(String name, String content) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            callback2.onNewMotionScene(content);
        }
    }

    public void updateProgress(String name, float progress) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            callback2.onProgress(progress);
        }
    }

    public String currentContent(String name) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            return callback2.currentMotionScene();
        }
        return null;
    }

    public String currentLayoutInformation(String name) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            return callback2.currentLayoutInformation();
        }
        return null;
    }

    public void setDrawDebug(String name, int debugMode) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            callback2.setDrawDebug(debugMode);
        }
    }

    public void setLayoutInformationMode(String name, int mode) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            callback2.setLayoutInformationMode(mode);
        }
    }

    public Set<String> getLayoutList() {
        return this.mCallbacks.keySet();
    }

    public long getLastModified(String name) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            return callback2.getLastModified();
        }
        return Long.MAX_VALUE;
    }

    public void updateDimensions(String name, int width, int height) {
        RegistryCallback callback2 = this.mCallbacks.get(name);
        if (callback2 != null) {
            callback2.onDimensions(width, height);
        }
    }
}

