/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.motion.Motion;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKeyAttributes;
import androidx.constraintlayout.core.motion.key.MotionKeyCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.TypedBundle;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.state.Interpolator;
import androidx.constraintlayout.core.state.WidgetFrame;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.util.ArrayList;
import java.util.HashMap;

public class Transition
implements TypedValues {
    public static final int START = 0;
    public static final int END = 1;
    public static final int INTERPOLATED = 2;
    static final int EASE_IN_OUT = 0;
    static final int EASE_IN = 1;
    static final int EASE_OUT = 2;
    static final int LINEAR = 3;
    static final int BOUNCE = 4;
    static final int OVERSHOOT = 5;
    static final int ANTICIPATE = 6;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    HashMap<Integer, HashMap<String, KeyPosition>> keyPositions = new HashMap();
    private HashMap<String, WidgetState> state = new HashMap();
    TypedBundle mBundle = new TypedBundle();
    private int mDefaultInterpolator = 0;
    private String mDefaultInterpolatorString = null;
    private Easing mEasing = null;
    private int mAutoTransition = 0;
    private int mDuration = 400;
    private float mStagger = 0.0f;

    public static Interpolator getInterpolator(int interpolator2, String interpolatorString) {
        switch (interpolator2) {
            case -1: {
                return v -> (float)Easing.getInterpolator(interpolatorString).get(v);
            }
            case 0: {
                return v -> (float)Easing.getInterpolator("standard").get(v);
            }
            case 1: {
                return v -> (float)Easing.getInterpolator("accelerate").get(v);
            }
            case 2: {
                return v -> (float)Easing.getInterpolator("decelerate").get(v);
            }
            case 3: {
                return v -> (float)Easing.getInterpolator("linear").get(v);
            }
            case 6: {
                return v -> (float)Easing.getInterpolator("anticipate").get(v);
            }
            case 5: {
                return v -> (float)Easing.getInterpolator("overshoot").get(v);
            }
            case 4: {
                return v -> (float)Easing.getInterpolator("spline(0.0, 0.2, 0.4, 0.6, 0.8 ,1.0, 0.8, 1.0, 0.9, 1.0)").get(v);
            }
        }
        return null;
    }

    public KeyPosition findPreviousPosition(String target, int frameNumber) {
        while (frameNumber >= 0) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map2 = this.keyPositions.get(frameNumber);
            if (map2 != null && (keyPosition = map2.get(target)) != null) {
                return keyPosition;
            }
            --frameNumber;
        }
        return null;
    }

    public KeyPosition findNextPosition(String target, int frameNumber) {
        while (frameNumber <= 100) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map2 = this.keyPositions.get(frameNumber);
            if (map2 != null && (keyPosition = map2.get(target)) != null) {
                return keyPosition;
            }
            ++frameNumber;
        }
        return null;
    }

    public int getNumberKeyPositions(WidgetFrame frame) {
        int numKeyPositions = 0;
        for (int frameNumber = 0; frameNumber <= 100; ++frameNumber) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map2 = this.keyPositions.get(frameNumber);
            if (map2 == null || (keyPosition = map2.get(frame.widget.stringId)) == null) continue;
            ++numKeyPositions;
        }
        return numKeyPositions;
    }

    public Motion getMotion(String id2) {
        return this.getWidgetState((String)id2, null, (int)0).motionControl;
    }

    public void fillKeyPositions(WidgetFrame frame, float[] x, float[] y, float[] pos) {
        int numKeyPositions = 0;
        for (int frameNumber = 0; frameNumber <= 100; ++frameNumber) {
            KeyPosition keyPosition;
            HashMap<String, KeyPosition> map2 = this.keyPositions.get(frameNumber);
            if (map2 == null || (keyPosition = map2.get(frame.widget.stringId)) == null) continue;
            x[numKeyPositions] = keyPosition.x;
            y[numKeyPositions] = keyPosition.y;
            pos[numKeyPositions] = keyPosition.frame;
            ++numKeyPositions;
        }
    }

    public boolean hasPositionKeyframes() {
        return this.keyPositions.size() > 0;
    }

    public void setTransitionProperties(TypedBundle bundle) {
        bundle.applyDelta(this.mBundle);
        bundle.applyDelta(this);
    }

    @Override
    public boolean setValue(int id2, int value) {
        return false;
    }

    @Override
    public boolean setValue(int id2, float value) {
        if (id2 == 706) {
            this.mStagger = value;
        }
        return false;
    }

    @Override
    public boolean setValue(int id2, String value) {
        if (id2 == 705) {
            this.mDefaultInterpolatorString = value;
            this.mEasing = Easing.getInterpolator(this.mDefaultInterpolatorString);
        }
        return false;
    }

    @Override
    public boolean setValue(int id2, boolean value) {
        return false;
    }

    @Override
    public int getId(String name) {
        return 0;
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public void clear() {
        this.state.clear();
    }

    public boolean contains(String key) {
        return this.state.containsKey(key);
    }

    public void addKeyPosition(String target, TypedBundle bundle) {
        this.getWidgetState(target, null, 0).setKeyPosition(bundle);
    }

    public void addKeyAttribute(String target, TypedBundle bundle) {
        this.getWidgetState(target, null, 0).setKeyAttribute(bundle);
    }

    public void addKeyCycle(String target, TypedBundle bundle) {
        this.getWidgetState(target, null, 0).setKeyCycle(bundle);
    }

    public void addKeyPosition(String target, int frame, int type, float x, float y) {
        TypedBundle bundle = new TypedBundle();
        bundle.add(510, 2);
        bundle.add(100, frame);
        bundle.add(506, x);
        bundle.add(507, y);
        this.getWidgetState(target, null, 0).setKeyPosition(bundle);
        KeyPosition keyPosition = new KeyPosition(target, frame, type, x, y);
        HashMap<String, KeyPosition> map2 = this.keyPositions.get(frame);
        if (map2 == null) {
            map2 = new HashMap();
            this.keyPositions.put(frame, map2);
        }
        map2.put(target, keyPosition);
    }

    public void addCustomFloat(int state, String widgetId, String property, float value) {
        WidgetState widgetState = this.getWidgetState(widgetId, null, state);
        WidgetFrame frame = widgetState.getFrame(state);
        frame.addCustomFloat(property, value);
    }

    public void addCustomColor(int state, String widgetId, String property, int color2) {
        WidgetState widgetState = this.getWidgetState(widgetId, null, state);
        WidgetFrame frame = widgetState.getFrame(state);
        frame.addCustomColor(property, color2);
    }

    public void updateFrom(ConstraintWidgetContainer container, int state) {
        ArrayList<ConstraintWidget> children2 = container.getChildren();
        int count2 = children2.size();
        for (int i = 0; i < count2; ++i) {
            ConstraintWidget child = children2.get(i);
            WidgetState widgetState = this.getWidgetState(child.stringId, null, state);
            widgetState.update(child, state);
        }
    }

    public void interpolate(int parentWidth, int parentHeight, float progress) {
        if (this.mEasing != null) {
            progress = (float)this.mEasing.get(progress);
        }
        for (String key : this.state.keySet()) {
            WidgetState widget = this.state.get(key);
            widget.interpolate(parentWidth, parentHeight, progress, this);
        }
    }

    public WidgetFrame getStart(String id2) {
        WidgetState widgetState = this.state.get(id2);
        if (widgetState == null) {
            return null;
        }
        return widgetState.start;
    }

    public WidgetFrame getEnd(String id2) {
        WidgetState widgetState = this.state.get(id2);
        if (widgetState == null) {
            return null;
        }
        return widgetState.end;
    }

    public WidgetFrame getInterpolated(String id2) {
        WidgetState widgetState = this.state.get(id2);
        if (widgetState == null) {
            return null;
        }
        return widgetState.interpolated;
    }

    public float[] getPath(String id2) {
        WidgetState widgetState = this.state.get(id2);
        int duration = 1000;
        int frames = duration / 16;
        float[] mPoints = new float[frames * 2];
        widgetState.motionControl.buildPath(mPoints, frames);
        return mPoints;
    }

    public int getKeyFrames(String id2, float[] rectangles, int[] pathMode, int[] position) {
        WidgetState widgetState = this.state.get(id2);
        return widgetState.motionControl.buildKeyFrames(rectangles, pathMode, position);
    }

    private WidgetState getWidgetState(String widgetId) {
        return this.state.get(widgetId);
    }

    private WidgetState getWidgetState(String widgetId, ConstraintWidget child, int transitionState) {
        WidgetState widgetState = this.state.get(widgetId);
        if (widgetState == null) {
            widgetState = new WidgetState();
            this.mBundle.applyDelta(widgetState.motionControl);
            this.state.put(widgetId, widgetState);
            if (child != null) {
                widgetState.update(child, transitionState);
            }
        }
        return widgetState;
    }

    public WidgetFrame getStart(ConstraintWidget child) {
        return this.getWidgetState((String)child.stringId, null, (int)0).start;
    }

    public WidgetFrame getEnd(ConstraintWidget child) {
        return this.getWidgetState((String)child.stringId, null, (int)1).end;
    }

    public WidgetFrame getInterpolated(ConstraintWidget child) {
        return this.getWidgetState((String)child.stringId, null, (int)2).interpolated;
    }

    public Interpolator getInterpolator() {
        return Transition.getInterpolator(this.mDefaultInterpolator, this.mDefaultInterpolatorString);
    }

    public int getAutoTransition() {
        return this.mAutoTransition;
    }

    static class KeyPosition {
        int frame;
        String target;
        int type;
        float x;
        float y;

        public KeyPosition(String target, int frame, int type, float x, float y) {
            this.target = target;
            this.frame = frame;
            this.type = type;
            this.x = x;
            this.y = y;
        }
    }

    static class WidgetState {
        WidgetFrame start;
        WidgetFrame end;
        WidgetFrame interpolated;
        Motion motionControl;
        MotionWidget motionWidgetStart;
        MotionWidget motionWidgetEnd;
        MotionWidget motionWidgetInterpolated;
        KeyCache myKeyCache = new KeyCache();
        int myParentHeight = -1;
        int myParentWidth = -1;

        public WidgetState() {
            this.start = new WidgetFrame();
            this.end = new WidgetFrame();
            this.interpolated = new WidgetFrame();
            this.motionWidgetStart = new MotionWidget(this.start);
            this.motionWidgetEnd = new MotionWidget(this.end);
            this.motionWidgetInterpolated = new MotionWidget(this.interpolated);
            this.motionControl = new Motion(this.motionWidgetStart);
            this.motionControl.setStart(this.motionWidgetStart);
            this.motionControl.setEnd(this.motionWidgetEnd);
        }

        public void setKeyPosition(TypedBundle prop) {
            MotionKeyPosition keyPosition = new MotionKeyPosition();
            prop.applyDelta(keyPosition);
            this.motionControl.addKey(keyPosition);
        }

        public void setKeyAttribute(TypedBundle prop) {
            MotionKeyAttributes keyAttributes = new MotionKeyAttributes();
            prop.applyDelta(keyAttributes);
            this.motionControl.addKey(keyAttributes);
        }

        public void setKeyCycle(TypedBundle prop) {
            MotionKeyCycle keyAttributes = new MotionKeyCycle();
            prop.applyDelta(keyAttributes);
            this.motionControl.addKey(keyAttributes);
        }

        public void update(ConstraintWidget child, int state) {
            if (state == 0) {
                this.start.update(child);
                this.motionControl.setStart(this.motionWidgetStart);
            } else if (state == 1) {
                this.end.update(child);
                this.motionControl.setEnd(this.motionWidgetEnd);
            }
            this.myParentWidth = -1;
        }

        public WidgetFrame getFrame(int type) {
            if (type == 0) {
                return this.start;
            }
            if (type == 1) {
                return this.end;
            }
            return this.interpolated;
        }

        public void interpolate(int parentWidth, int parentHeight, float progress, Transition transition) {
            this.myParentHeight = parentHeight;
            this.myParentWidth = parentWidth;
            this.motionControl.setup(parentWidth, parentHeight, 1.0f, System.nanoTime());
            WidgetFrame.interpolate(parentWidth, parentHeight, this.interpolated, this.start, this.end, transition, progress);
            this.interpolated.interpolatedPos = progress;
            this.motionControl.interpolate(this.motionWidgetInterpolated, progress, System.nanoTime(), this.myKeyCache);
        }
    }
}

