/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.helpers.ChainReference;

public class VerticalChainReference
extends ChainReference {
    public VerticalChainReference(State state) {
        super(state, State.Helper.VERTICAL_CHAIN);
    }

    @Override
    public void apply() {
        ConstraintReference reference;
        ConstraintReference first2 = null;
        ConstraintReference previous = null;
        for (Object key : this.mReferences) {
            reference = this.mState.constraints(key);
            reference.clearVertical();
        }
        for (Object key : this.mReferences) {
            reference = this.mState.constraints(key);
            if (first2 == null) {
                first2 = reference;
                if (this.mTopToTop != null) {
                    first2.topToTop(this.mTopToTop).margin(this.mMarginTop).marginGone(this.mMarginTopGone);
                } else if (this.mTopToBottom != null) {
                    first2.topToBottom(this.mTopToBottom).margin(this.mMarginTop).marginGone(this.mMarginTopGone);
                } else {
                    first2.topToTop(State.PARENT);
                }
            }
            if (previous != null) {
                previous.bottomToTop(reference.getKey());
                reference.topToBottom(previous.getKey());
            }
            previous = reference;
        }
        if (previous != null) {
            if (this.mBottomToTop != null) {
                previous.bottomToTop(this.mBottomToTop).margin(this.mMarginBottom).marginGone(this.mMarginBottomGone);
            } else if (this.mBottomToBottom != null) {
                previous.bottomToBottom(this.mBottomToBottom).margin(this.mMarginBottom).marginGone(this.mMarginBottomGone);
            } else {
                previous.bottomToBottom(State.PARENT);
            }
        }
        if (first2 == null) {
            return;
        }
        if (this.mBias != 0.5f) {
            first2.verticalBias(this.mBias);
        }
        switch (this.mStyle) {
            case SPREAD: {
                first2.setVerticalChainStyle(0);
                break;
            }
            case SPREAD_INSIDE: {
                first2.setVerticalChainStyle(1);
                break;
            }
            case PACKED: {
                first2.setVerticalChainStyle(2);
            }
        }
    }
}

