/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.Optimizer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import java.util.ArrayList;

public class BasicMeasure {
    private static final boolean DEBUG = false;
    private static final int MODE_SHIFT = 30;
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    public static final int FIXED = -3;
    private final ArrayList<ConstraintWidget> mVariableDimensionsWidgets = new ArrayList();
    private Measure mMeasure = new Measure();
    private ConstraintWidgetContainer constraintWidgetContainer;

    public void updateHierarchy(ConstraintWidgetContainer layout2) {
        this.mVariableDimensionsWidgets.clear();
        int childCount = layout2.mChildren.size();
        for (int i = 0; i < childCount; ++i) {
            ConstraintWidget widget = (ConstraintWidget)layout2.mChildren.get(i);
            if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            this.mVariableDimensionsWidgets.add(widget);
        }
        layout2.invalidateGraph();
    }

    public BasicMeasure(ConstraintWidgetContainer constraintWidgetContainer) {
        this.constraintWidgetContainer = constraintWidgetContainer;
    }

    private void measureChildren(ConstraintWidgetContainer layout2) {
        int childCount = layout2.mChildren.size();
        boolean optimize = layout2.optimizeFor(64);
        Measurer measurer = layout2.getMeasurer();
        for (int i = 0; i < childCount; ++i) {
            boolean skip;
            ConstraintWidget child = (ConstraintWidget)layout2.mChildren.get(i);
            if (child instanceof Guideline || child instanceof Barrier || child.isInVirtualLayout() || optimize && child.horizontalRun != null && child.verticalRun != null && child.horizontalRun.dimension.resolved && child.verticalRun.dimension.resolved) continue;
            ConstraintWidget.DimensionBehaviour widthBehavior = child.getDimensionBehaviour(0);
            ConstraintWidget.DimensionBehaviour heightBehavior = child.getDimensionBehaviour(1);
            boolean bl = skip = widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultWidth != 1 && heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultHeight != 1;
            if (!skip && layout2.optimizeFor(1) && !(child instanceof VirtualLayout)) {
                if (widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultWidth == 0 && heightBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && !child.isInHorizontalChain()) {
                    skip = true;
                }
                if (heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultHeight == 0 && widthBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && !child.isInHorizontalChain()) {
                    skip = true;
                }
                if ((widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) && child.mDimensionRatio > 0.0f) {
                    skip = true;
                }
            }
            if (skip) continue;
            this.measure(measurer, child, Measure.SELF_DIMENSIONS);
            if (layout2.mMetrics == null) continue;
            ++layout2.mMetrics.measuredWidgets;
        }
        measurer.didMeasures();
    }

    private void solveLinearSystem(ConstraintWidgetContainer layout2, String reason, int pass, int w, int h) {
        int minWidth = layout2.getMinWidth();
        int minHeight = layout2.getMinHeight();
        layout2.setMinWidth(0);
        layout2.setMinHeight(0);
        layout2.setWidth(w);
        layout2.setHeight(h);
        layout2.setMinWidth(minWidth);
        layout2.setMinHeight(minHeight);
        this.constraintWidgetContainer.setPass(pass);
        this.constraintWidgetContainer.layout();
    }

    public long solverMeasure(ConstraintWidgetContainer layout2, int optimizationLevel, int paddingX, int paddingY, int widthMode, int widthSize, int heightMode, int heightSize, int lastMeasureWidth, int lastMeasureHeight) {
        boolean optimize;
        Measurer measurer = layout2.getMeasurer();
        long layoutTime = 0L;
        int childCount = layout2.mChildren.size();
        int startingWidth = layout2.getWidth();
        int startingHeight = layout2.getHeight();
        boolean optimizeWrap = Optimizer.enabled(optimizationLevel, 128);
        boolean bl = optimize = optimizeWrap || Optimizer.enabled(optimizationLevel, 64);
        if (optimize) {
            for (int i = 0; i < childCount; ++i) {
                boolean ratio;
                ConstraintWidget child = (ConstraintWidget)layout2.mChildren.get(i);
                boolean matchWidth = child.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean matchHeight = child.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean bl2 = ratio = matchWidth && matchHeight && child.getDimensionRatio() > 0.0f;
                if (child.isInHorizontalChain() && ratio) {
                    optimize = false;
                    break;
                }
                if (child.isInVerticalChain() && ratio) {
                    optimize = false;
                    break;
                }
                if (child instanceof VirtualLayout) {
                    optimize = false;
                    break;
                }
                if (!child.isInHorizontalChain() && !child.isInVerticalChain()) continue;
                optimize = false;
                break;
            }
        }
        if (optimize && LinearSystem.sMetrics != null) {
            ++LinearSystem.sMetrics.measures;
        }
        boolean allSolved = false;
        boolean bl3 = widthMode == 0x40000000 && heightMode == 0x40000000 || optimizeWrap;
        int computations = 0;
        if (optimize &= bl3) {
            widthSize = Math.min(layout2.getMaxWidth(), widthSize);
            heightSize = Math.min(layout2.getMaxHeight(), heightSize);
            if (widthMode == 0x40000000 && layout2.getWidth() != widthSize) {
                layout2.setWidth(widthSize);
                layout2.invalidateGraph();
            }
            if (heightMode == 0x40000000 && layout2.getHeight() != heightSize) {
                layout2.setHeight(heightSize);
                layout2.invalidateGraph();
            }
            if (widthMode == 0x40000000 && heightMode == 0x40000000) {
                allSolved = layout2.directMeasure(optimizeWrap);
                computations = 2;
            } else {
                allSolved = layout2.directMeasureSetup(optimizeWrap);
                if (widthMode == 0x40000000) {
                    allSolved &= layout2.directMeasureWithOrientation(optimizeWrap, 0);
                    ++computations;
                }
                if (heightMode == 0x40000000) {
                    allSolved &= layout2.directMeasureWithOrientation(optimizeWrap, 1);
                    ++computations;
                }
            }
            if (allSolved) {
                layout2.updateFromRuns(widthMode == 0x40000000, heightMode == 0x40000000);
            }
        }
        if (!allSolved || computations != 2) {
            int optimizations = layout2.getOptimizationLevel();
            if (childCount > 0) {
                this.measureChildren(layout2);
            }
            this.updateHierarchy(layout2);
            int sizeDependentWidgetsCount = this.mVariableDimensionsWidgets.size();
            if (childCount > 0) {
                this.solveLinearSystem(layout2, "First pass", 0, startingWidth, startingHeight);
            }
            if (sizeDependentWidgetsCount > 0) {
                boolean needSolverPass = false;
                boolean containerWrapWidth = layout2.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                boolean containerWrapHeight = layout2.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                int minWidth = Math.max(layout2.getWidth(), this.constraintWidgetContainer.getMinWidth());
                int minHeight = Math.max(layout2.getHeight(), this.constraintWidgetContainer.getMinHeight());
                for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                    ConstraintWidget widget = this.mVariableDimensionsWidgets.get(i);
                    if (!(widget instanceof VirtualLayout)) continue;
                    int preWidth = widget.getWidth();
                    int preHeight = widget.getHeight();
                    needSolverPass |= this.measure(measurer, widget, Measure.TRY_GIVEN_DIMENSIONS);
                    if (layout2.mMetrics != null) {
                        ++layout2.mMetrics.measuredMatchWidgets;
                    }
                    int measuredWidth = widget.getWidth();
                    int measuredHeight = widget.getHeight();
                    if (measuredWidth != preWidth) {
                        widget.setWidth(measuredWidth);
                        if (containerWrapWidth && widget.getRight() > minWidth) {
                            int w = widget.getRight() + widget.getAnchor(ConstraintAnchor.Type.RIGHT).getMargin();
                            minWidth = Math.max(minWidth, w);
                        }
                        needSolverPass = true;
                    }
                    if (measuredHeight != preHeight) {
                        widget.setHeight(measuredHeight);
                        if (containerWrapHeight && widget.getBottom() > minHeight) {
                            int h = widget.getBottom() + widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin();
                            minHeight = Math.max(minHeight, h);
                        }
                        needSolverPass = true;
                    }
                    VirtualLayout virtualLayout = (VirtualLayout)widget;
                    needSolverPass |= virtualLayout.needSolverPass();
                }
                int maxIterations = 2;
                for (int j = 0; j < maxIterations; ++j) {
                    for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                        ConstraintWidget widget = this.mVariableDimensionsWidgets.get(i);
                        if (widget instanceof Helper && !(widget instanceof VirtualLayout) || widget instanceof Guideline || widget.getVisibility() == 8 || optimize && widget.horizontalRun.dimension.resolved && widget.verticalRun.dimension.resolved || widget instanceof VirtualLayout) continue;
                        int preWidth = widget.getWidth();
                        int preHeight = widget.getHeight();
                        int preBaselineDistance = widget.getBaselineDistance();
                        int measureStrategy = Measure.TRY_GIVEN_DIMENSIONS;
                        if (j == maxIterations - 1) {
                            measureStrategy = Measure.USE_GIVEN_DIMENSIONS;
                        }
                        boolean hasMeasure = this.measure(measurer, widget, measureStrategy);
                        needSolverPass |= hasMeasure;
                        if (layout2.mMetrics != null) {
                            ++layout2.mMetrics.measuredMatchWidgets;
                        }
                        int measuredWidth = widget.getWidth();
                        int measuredHeight = widget.getHeight();
                        if (measuredWidth != preWidth) {
                            widget.setWidth(measuredWidth);
                            if (containerWrapWidth && widget.getRight() > minWidth) {
                                int w = widget.getRight() + widget.getAnchor(ConstraintAnchor.Type.RIGHT).getMargin();
                                minWidth = Math.max(minWidth, w);
                            }
                            needSolverPass = true;
                        }
                        if (measuredHeight != preHeight) {
                            widget.setHeight(measuredHeight);
                            if (containerWrapHeight && widget.getBottom() > minHeight) {
                                int h = widget.getBottom() + widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin();
                                minHeight = Math.max(minHeight, h);
                            }
                            needSolverPass = true;
                        }
                        if (!widget.hasBaseline() || preBaselineDistance == widget.getBaselineDistance()) continue;
                        needSolverPass = true;
                    }
                    if (!needSolverPass) break;
                    this.solveLinearSystem(layout2, "intermediate pass", 1 + j, startingWidth, startingHeight);
                    needSolverPass = false;
                }
            }
            layout2.setOptimizationLevel(optimizations);
        }
        return layoutTime;
    }

    private boolean measure(Measurer measurer, ConstraintWidget widget, int measureStrategy) {
        boolean verticalUseRatio;
        this.mMeasure.horizontalBehavior = widget.getHorizontalDimensionBehaviour();
        this.mMeasure.verticalBehavior = widget.getVerticalDimensionBehaviour();
        this.mMeasure.horizontalDimension = widget.getWidth();
        this.mMeasure.verticalDimension = widget.getHeight();
        this.mMeasure.measuredNeedsSolverPass = false;
        this.mMeasure.measureStrategy = measureStrategy;
        boolean horizontalMatchConstraints = this.mMeasure.horizontalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        boolean verticalMatchConstraints = this.mMeasure.verticalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        boolean horizontalUseRatio = horizontalMatchConstraints && widget.mDimensionRatio > 0.0f;
        boolean bl = verticalUseRatio = verticalMatchConstraints && widget.mDimensionRatio > 0.0f;
        if (horizontalUseRatio && widget.mResolvedMatchConstraintDefault[0] == 4) {
            this.mMeasure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
        }
        if (verticalUseRatio && widget.mResolvedMatchConstraintDefault[1] == 4) {
            this.mMeasure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
        }
        measurer.measure(widget, this.mMeasure);
        widget.setWidth(this.mMeasure.measuredWidth);
        widget.setHeight(this.mMeasure.measuredHeight);
        widget.setHasBaseline(this.mMeasure.measuredHasBaseline);
        widget.setBaselineDistance(this.mMeasure.measuredBaseline);
        this.mMeasure.measureStrategy = Measure.SELF_DIMENSIONS;
        return this.mMeasure.measuredNeedsSolverPass;
    }

    public static class Measure {
        public static int SELF_DIMENSIONS = 0;
        public static int TRY_GIVEN_DIMENSIONS = 1;
        public static int USE_GIVEN_DIMENSIONS = 2;
        public ConstraintWidget.DimensionBehaviour horizontalBehavior;
        public ConstraintWidget.DimensionBehaviour verticalBehavior;
        public int horizontalDimension;
        public int verticalDimension;
        public int measuredWidth;
        public int measuredHeight;
        public int measuredBaseline;
        public boolean measuredHasBaseline;
        public boolean measuredNeedsSolverPass;
        public int measureStrategy;
    }

    public static interface Measurer {
        public void measure(ConstraintWidget var1, Measure var2);

        public void didMeasures();
    }
}

