/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ChainHead;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import java.util.ArrayList;

public class Direct {
    private static final boolean DEBUG = false;
    private static final boolean APPLY_MATCH_PARENT = false;
    private static BasicMeasure.Measure measure = new BasicMeasure.Measure();
    private static final boolean EARLY_TERMINATION = true;
    private static int hcount = 0;
    private static int vcount = 0;

    public static void solvingPass(ConstraintWidgetContainer layout2, BasicMeasure.Measurer measurer) {
        Barrier barrier;
        int position;
        Guideline guideline;
        ConstraintWidget child;
        int i;
        ConstraintWidget.DimensionBehaviour horizontal = layout2.getHorizontalDimensionBehaviour();
        ConstraintWidget.DimensionBehaviour vertical = layout2.getVerticalDimensionBehaviour();
        hcount = 0;
        vcount = 0;
        long time = 0L;
        layout2.resetFinalResolution();
        ArrayList<ConstraintWidget> children2 = layout2.getChildren();
        int count2 = children2.size();
        for (int i2 = 0; i2 < count2; ++i2) {
            ConstraintWidget child2 = children2.get(i2);
            child2.resetFinalResolution();
        }
        boolean isRtl = layout2.isRtl();
        if (horizontal == ConstraintWidget.DimensionBehaviour.FIXED) {
            layout2.setFinalHorizontal(0, layout2.getWidth());
        } else {
            layout2.setFinalLeft(0);
        }
        boolean hasGuideline = false;
        boolean hasBarrier = false;
        for (i = 0; i < count2; ++i) {
            child = children2.get(i);
            if (child instanceof Guideline) {
                guideline = (Guideline)child;
                if (guideline.getOrientation() != 1) continue;
                if (guideline.getRelativeBegin() != -1) {
                    guideline.setFinalValue(guideline.getRelativeBegin());
                } else if (guideline.getRelativeEnd() != -1 && layout2.isResolvedHorizontally()) {
                    guideline.setFinalValue(layout2.getWidth() - guideline.getRelativeEnd());
                } else if (layout2.isResolvedHorizontally()) {
                    position = (int)(0.5f + guideline.getRelativePercent() * (float)layout2.getWidth());
                    guideline.setFinalValue(position);
                }
                hasGuideline = true;
                continue;
            }
            if (!(child instanceof Barrier) || (barrier = (Barrier)child).getOrientation() != 0) continue;
            hasBarrier = true;
        }
        if (hasGuideline) {
            for (i = 0; i < count2; ++i) {
                child = children2.get(i);
                if (!(child instanceof Guideline) || (guideline = (Guideline)child).getOrientation() != 1) continue;
                Direct.horizontalSolvingPass(0, guideline, measurer, isRtl);
            }
        }
        Direct.horizontalSolvingPass(0, layout2, measurer, isRtl);
        if (hasBarrier) {
            for (i = 0; i < count2; ++i) {
                child = children2.get(i);
                if (!(child instanceof Barrier) || (barrier = (Barrier)child).getOrientation() != 0) continue;
                Direct.solveBarrier(0, barrier, measurer, 0, isRtl);
            }
        }
        if (vertical == ConstraintWidget.DimensionBehaviour.FIXED) {
            layout2.setFinalVertical(0, layout2.getHeight());
        } else {
            layout2.setFinalTop(0);
        }
        hasGuideline = false;
        hasBarrier = false;
        for (i = 0; i < count2; ++i) {
            child = children2.get(i);
            if (child instanceof Guideline) {
                guideline = (Guideline)child;
                if (guideline.getOrientation() != 0) continue;
                if (guideline.getRelativeBegin() != -1) {
                    guideline.setFinalValue(guideline.getRelativeBegin());
                } else if (guideline.getRelativeEnd() != -1 && layout2.isResolvedVertically()) {
                    guideline.setFinalValue(layout2.getHeight() - guideline.getRelativeEnd());
                } else if (layout2.isResolvedVertically()) {
                    position = (int)(0.5f + guideline.getRelativePercent() * (float)layout2.getHeight());
                    guideline.setFinalValue(position);
                }
                hasGuideline = true;
                continue;
            }
            if (!(child instanceof Barrier) || (barrier = (Barrier)child).getOrientation() != 1) continue;
            hasBarrier = true;
        }
        if (hasGuideline) {
            for (i = 0; i < count2; ++i) {
                child = children2.get(i);
                if (!(child instanceof Guideline) || (guideline = (Guideline)child).getOrientation() != 0) continue;
                Direct.verticalSolvingPass(1, guideline, measurer);
            }
        }
        Direct.verticalSolvingPass(0, layout2, measurer);
        if (hasBarrier) {
            for (i = 0; i < count2; ++i) {
                child = children2.get(i);
                if (!(child instanceof Barrier) || (barrier = (Barrier)child).getOrientation() != 1) continue;
                Direct.solveBarrier(0, barrier, measurer, 1, isRtl);
            }
        }
        for (i = 0; i < count2; ++i) {
            child = children2.get(i);
            if (!child.isMeasureRequested() || !Direct.canMeasure(0, child)) continue;
            ConstraintWidgetContainer.measure(0, child, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
            if (child instanceof Guideline) {
                if (((Guideline)child).getOrientation() == 0) {
                    Direct.verticalSolvingPass(0, child, measurer);
                    continue;
                }
                Direct.horizontalSolvingPass(0, child, measurer, isRtl);
                continue;
            }
            Direct.horizontalSolvingPass(0, child, measurer, isRtl);
            Direct.verticalSolvingPass(0, child, measurer);
        }
    }

    private static void solveBarrier(int level, Barrier barrier, BasicMeasure.Measurer measurer, int orientation, boolean isRtl) {
        if (barrier.allSolved()) {
            if (orientation == 0) {
                Direct.horizontalSolvingPass(level + 1, barrier, measurer, isRtl);
            } else {
                Direct.verticalSolvingPass(level + 1, barrier, measurer);
            }
        }
    }

    public static String ls(int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        builder.append("+-(" + level + ") ");
        return builder.toString();
    }

    private static void horizontalSolvingPass(int level, ConstraintWidget layout2, BasicMeasure.Measurer measurer, boolean isRtl) {
        boolean bothConnected;
        ConstraintWidget widget;
        if (layout2.isHorizontalSolvingPassDone()) {
            return;
        }
        ++hcount;
        if (!(layout2 instanceof ConstraintWidgetContainer) && layout2.isMeasureRequested() && Direct.canMeasure(level + 1, layout2)) {
            BasicMeasure.Measure measure = new BasicMeasure.Measure();
            ConstraintWidgetContainer.measure(level + 1, layout2, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
        }
        ConstraintAnchor left = layout2.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = layout2.getAnchor(ConstraintAnchor.Type.RIGHT);
        int l = left.getFinalValue();
        int r = right.getFinalValue();
        if (left.getDependents() != null && left.hasFinalValue()) {
            for (ConstraintAnchor first2 : left.getDependents()) {
                widget = first2.mOwner;
                int x1 = 0;
                int x2 = 0;
                boolean canMeasure = Direct.canMeasure(level + 1, widget);
                if (widget.isMeasureRequested() && canMeasure) {
                    BasicMeasure.Measure measure = new BasicMeasure.Measure();
                    ConstraintWidgetContainer.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
                }
                boolean bl = bothConnected = first2 == widget.mLeft && widget.mRight.mTarget != null && widget.mRight.mTarget.hasFinalValue() || first2 == widget.mRight && widget.mLeft.mTarget != null && widget.mLeft.mTarget.hasFinalValue();
                if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure) {
                    if (widget.isMeasureRequested()) continue;
                    if (first2 == widget.mLeft && widget.mRight.mTarget == null) {
                        x1 = l + widget.mLeft.getMargin();
                        x2 = x1 + widget.getWidth();
                        widget.setFinalHorizontal(x1, x2);
                        Direct.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                        continue;
                    }
                    if (first2 == widget.mRight && widget.mLeft.mTarget == null) {
                        x2 = l - widget.mRight.getMargin();
                        x1 = x2 - widget.getWidth();
                        widget.setFinalHorizontal(x1, x2);
                        Direct.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                        continue;
                    }
                    if (!bothConnected || widget.isInHorizontalChain()) continue;
                    Direct.solveHorizontalCenterConstraints(level + 1, measurer, widget, isRtl);
                    continue;
                }
                if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.mMatchConstraintMaxWidth < 0 || widget.mMatchConstraintMinWidth < 0 || widget.getVisibility() != 8 && (widget.mMatchConstraintDefaultWidth != 0 || widget.getDimensionRatio() != 0.0f) || widget.isInHorizontalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInHorizontalChain()) continue;
                Direct.solveHorizontalMatchConstraint(level + 1, layout2, measurer, widget, isRtl);
            }
        }
        if (layout2 instanceof Guideline) {
            return;
        }
        if (right.getDependents() != null && right.hasFinalValue()) {
            for (ConstraintAnchor first2 : right.getDependents()) {
                widget = first2.mOwner;
                boolean canMeasure = Direct.canMeasure(level + 1, widget);
                if (widget.isMeasureRequested() && canMeasure) {
                    BasicMeasure.Measure measure = new BasicMeasure.Measure();
                    ConstraintWidgetContainer.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
                }
                int x1 = 0;
                int x2 = 0;
                boolean bl = bothConnected = first2 == widget.mLeft && widget.mRight.mTarget != null && widget.mRight.mTarget.hasFinalValue() || first2 == widget.mRight && widget.mLeft.mTarget != null && widget.mLeft.mTarget.hasFinalValue();
                if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure) {
                    if (widget.isMeasureRequested()) continue;
                    if (first2 == widget.mLeft && widget.mRight.mTarget == null) {
                        x1 = r + widget.mLeft.getMargin();
                        x2 = x1 + widget.getWidth();
                        widget.setFinalHorizontal(x1, x2);
                        Direct.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                        continue;
                    }
                    if (first2 == widget.mRight && widget.mLeft.mTarget == null) {
                        x2 = r - widget.mRight.getMargin();
                        x1 = x2 - widget.getWidth();
                        widget.setFinalHorizontal(x1, x2);
                        Direct.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
                        continue;
                    }
                    if (!bothConnected || widget.isInHorizontalChain()) continue;
                    Direct.solveHorizontalCenterConstraints(level + 1, measurer, widget, isRtl);
                    continue;
                }
                if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.mMatchConstraintMaxWidth < 0 || widget.mMatchConstraintMinWidth < 0 || widget.getVisibility() != 8 && (widget.mMatchConstraintDefaultWidth != 0 || widget.getDimensionRatio() != 0.0f) || widget.isInHorizontalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInHorizontalChain()) continue;
                Direct.solveHorizontalMatchConstraint(level + 1, layout2, measurer, widget, isRtl);
            }
        }
        layout2.markHorizontalSolvingPassDone();
    }

    private static void verticalSolvingPass(int level, ConstraintWidget layout2, BasicMeasure.Measurer measurer) {
        ConstraintAnchor baseline;
        boolean bothConnected;
        boolean canMeasure;
        ConstraintWidget widget;
        if (layout2.isVerticalSolvingPassDone()) {
            return;
        }
        ++vcount;
        if (!(layout2 instanceof ConstraintWidgetContainer) && layout2.isMeasureRequested() && Direct.canMeasure(level + 1, layout2)) {
            BasicMeasure.Measure measure = new BasicMeasure.Measure();
            ConstraintWidgetContainer.measure(level + 1, layout2, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
        }
        ConstraintAnchor top = layout2.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = layout2.getAnchor(ConstraintAnchor.Type.BOTTOM);
        int t = top.getFinalValue();
        int b = bottom.getFinalValue();
        if (top.getDependents() != null && top.hasFinalValue()) {
            for (ConstraintAnchor first2 : top.getDependents()) {
                widget = first2.mOwner;
                int y1 = 0;
                int y2 = 0;
                canMeasure = Direct.canMeasure(level + 1, widget);
                if (widget.isMeasureRequested() && canMeasure) {
                    BasicMeasure.Measure measure = new BasicMeasure.Measure();
                    ConstraintWidgetContainer.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
                }
                boolean bl = bothConnected = first2 == widget.mTop && widget.mBottom.mTarget != null && widget.mBottom.mTarget.hasFinalValue() || first2 == widget.mBottom && widget.mTop.mTarget != null && widget.mTop.mTarget.hasFinalValue();
                if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure) {
                    if (widget.isMeasureRequested()) continue;
                    if (first2 == widget.mTop && widget.mBottom.mTarget == null) {
                        y1 = t + widget.mTop.getMargin();
                        y2 = y1 + widget.getHeight();
                        widget.setFinalVertical(y1, y2);
                        Direct.verticalSolvingPass(level + 1, widget, measurer);
                        continue;
                    }
                    if (first2 == widget.mBottom && widget.mTop.mTarget == null) {
                        y2 = t - widget.mBottom.getMargin();
                        y1 = y2 - widget.getHeight();
                        widget.setFinalVertical(y1, y2);
                        Direct.verticalSolvingPass(level + 1, widget, measurer);
                        continue;
                    }
                    if (!bothConnected || widget.isInVerticalChain()) continue;
                    Direct.solveVerticalCenterConstraints(level + 1, measurer, widget);
                    continue;
                }
                if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.mMatchConstraintMaxHeight < 0 || widget.mMatchConstraintMinHeight < 0 || widget.getVisibility() != 8 && (widget.mMatchConstraintDefaultHeight != 0 || widget.getDimensionRatio() != 0.0f) || widget.isInVerticalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInVerticalChain()) continue;
                Direct.solveVerticalMatchConstraint(level + 1, layout2, measurer, widget);
            }
        }
        if (layout2 instanceof Guideline) {
            return;
        }
        if (bottom.getDependents() != null && bottom.hasFinalValue()) {
            for (ConstraintAnchor first2 : bottom.getDependents()) {
                widget = first2.mOwner;
                boolean canMeasure2 = Direct.canMeasure(level + 1, widget);
                if (widget.isMeasureRequested() && canMeasure2) {
                    BasicMeasure.Measure measure = new BasicMeasure.Measure();
                    ConstraintWidgetContainer.measure(level + 1, widget, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
                }
                int y1 = 0;
                int y2 = 0;
                boolean bl = bothConnected = first2 == widget.mTop && widget.mBottom.mTarget != null && widget.mBottom.mTarget.hasFinalValue() || first2 == widget.mBottom && widget.mTop.mTarget != null && widget.mTop.mTarget.hasFinalValue();
                if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || canMeasure2) {
                    if (widget.isMeasureRequested()) continue;
                    if (first2 == widget.mTop && widget.mBottom.mTarget == null) {
                        y1 = b + widget.mTop.getMargin();
                        y2 = y1 + widget.getHeight();
                        widget.setFinalVertical(y1, y2);
                        Direct.verticalSolvingPass(level + 1, widget, measurer);
                        continue;
                    }
                    if (first2 == widget.mBottom && widget.mTop.mTarget == null) {
                        y2 = b - widget.mBottom.getMargin();
                        y1 = y2 - widget.getHeight();
                        widget.setFinalVertical(y1, y2);
                        Direct.verticalSolvingPass(level + 1, widget, measurer);
                        continue;
                    }
                    if (!bothConnected || widget.isInVerticalChain()) continue;
                    Direct.solveVerticalCenterConstraints(level + 1, measurer, widget);
                    continue;
                }
                if (widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.mMatchConstraintMaxHeight < 0 || widget.mMatchConstraintMinHeight < 0 || widget.getVisibility() != 8 && (widget.mMatchConstraintDefaultHeight != 0 || widget.getDimensionRatio() != 0.0f) || widget.isInVerticalChain() || widget.isInVirtualLayout() || !bothConnected || widget.isInVerticalChain()) continue;
                Direct.solveVerticalMatchConstraint(level + 1, layout2, measurer, widget);
            }
        }
        if ((baseline = layout2.getAnchor(ConstraintAnchor.Type.BASELINE)).getDependents() != null && baseline.hasFinalValue()) {
            int baselineValue = baseline.getFinalValue();
            for (ConstraintAnchor first3 : baseline.getDependents()) {
                ConstraintWidget widget2 = first3.mOwner;
                canMeasure = Direct.canMeasure(level + 1, widget2);
                if (widget2.isMeasureRequested() && canMeasure) {
                    BasicMeasure.Measure measure = new BasicMeasure.Measure();
                    ConstraintWidgetContainer.measure(level + 1, widget2, measurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
                }
                if (widget2.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && !canMeasure || widget2.isMeasureRequested() || first3 != widget2.mBaseline) continue;
                widget2.setFinalBaseline(baselineValue + first3.getMargin());
                Direct.verticalSolvingPass(level + 1, widget2, measurer);
            }
        }
        layout2.markVerticalSolvingPassDone();
    }

    private static void solveHorizontalCenterConstraints(int level, BasicMeasure.Measurer measurer, ConstraintWidget widget, boolean isRtl) {
        float bias = widget.getHorizontalBiasPercent();
        int start = widget.mLeft.mTarget.getFinalValue();
        int end = widget.mRight.mTarget.getFinalValue();
        int s1 = start + widget.mLeft.getMargin();
        int s2 = end - widget.mRight.getMargin();
        if (start == end) {
            bias = 0.5f;
            s1 = start;
            s2 = end;
        }
        int width = widget.getWidth();
        int distance = s2 - s1 - width;
        if (s1 > s2) {
            distance = s1 - s2 - width;
        }
        int d1 = distance > 0 ? (int)(0.5f + bias * (float)distance) : (int)(bias * (float)distance);
        int x1 = s1 + d1;
        int x2 = x1 + width;
        if (s1 > s2) {
            x1 = s1 + d1;
            x2 = x1 - width;
        }
        widget.setFinalHorizontal(x1, x2);
        Direct.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
    }

    private static void solveVerticalCenterConstraints(int level, BasicMeasure.Measurer measurer, ConstraintWidget widget) {
        float bias = widget.getVerticalBiasPercent();
        int start = widget.mTop.mTarget.getFinalValue();
        int end = widget.mBottom.mTarget.getFinalValue();
        int s1 = start + widget.mTop.getMargin();
        int s2 = end - widget.mBottom.getMargin();
        if (start == end) {
            bias = 0.5f;
            s1 = start;
            s2 = end;
        }
        int height = widget.getHeight();
        int distance = s2 - s1 - height;
        if (s1 > s2) {
            distance = s1 - s2 - height;
        }
        int d1 = distance > 0 ? (int)(0.5f + bias * (float)distance) : (int)(bias * (float)distance);
        int y1 = s1 + d1;
        int y2 = y1 + height;
        if (s1 > s2) {
            y1 = s1 - d1;
            y2 = y1 - height;
        }
        widget.setFinalVertical(y1, y2);
        Direct.verticalSolvingPass(level + 1, widget, measurer);
    }

    private static void solveHorizontalMatchConstraint(int level, ConstraintWidget layout2, BasicMeasure.Measurer measurer, ConstraintWidget widget, boolean isRtl) {
        float bias = widget.getHorizontalBiasPercent();
        int s1 = widget.mLeft.mTarget.getFinalValue() + widget.mLeft.getMargin();
        int s2 = widget.mRight.mTarget.getFinalValue() - widget.mRight.getMargin();
        if (s2 >= s1) {
            int width = widget.getWidth();
            if (widget.getVisibility() != 8) {
                if (widget.mMatchConstraintDefaultWidth == 2) {
                    int parentWidth = 0;
                    parentWidth = layout2 instanceof ConstraintWidgetContainer ? layout2.getWidth() : layout2.getParent().getWidth();
                    width = (int)(0.5f * widget.getHorizontalBiasPercent() * (float)parentWidth);
                } else if (widget.mMatchConstraintDefaultWidth == 0) {
                    width = s2 - s1;
                }
                width = Math.max(widget.mMatchConstraintMinWidth, width);
                if (widget.mMatchConstraintMaxWidth > 0) {
                    width = Math.min(widget.mMatchConstraintMaxWidth, width);
                }
            }
            int distance = s2 - s1 - width;
            int d1 = (int)(0.5f + bias * (float)distance);
            int x1 = s1 + d1;
            int x2 = x1 + width;
            widget.setFinalHorizontal(x1, x2);
            Direct.horizontalSolvingPass(level + 1, widget, measurer, isRtl);
        }
    }

    private static void solveVerticalMatchConstraint(int level, ConstraintWidget layout2, BasicMeasure.Measurer measurer, ConstraintWidget widget) {
        float bias = widget.getVerticalBiasPercent();
        int s1 = widget.mTop.mTarget.getFinalValue() + widget.mTop.getMargin();
        int s2 = widget.mBottom.mTarget.getFinalValue() - widget.mBottom.getMargin();
        if (s2 >= s1) {
            int height = widget.getHeight();
            if (widget.getVisibility() != 8) {
                if (widget.mMatchConstraintDefaultHeight == 2) {
                    int parentHeight = 0;
                    parentHeight = layout2 instanceof ConstraintWidgetContainer ? layout2.getHeight() : layout2.getParent().getHeight();
                    height = (int)(0.5f * bias * (float)parentHeight);
                } else if (widget.mMatchConstraintDefaultHeight == 0) {
                    height = s2 - s1;
                }
                height = Math.max(widget.mMatchConstraintMinHeight, height);
                if (widget.mMatchConstraintMaxHeight > 0) {
                    height = Math.min(widget.mMatchConstraintMaxHeight, height);
                }
            }
            int distance = s2 - s1 - height;
            int d1 = (int)(0.5f + bias * (float)distance);
            int y1 = s1 + d1;
            int y2 = y1 + height;
            widget.setFinalVertical(y1, y2);
            Direct.verticalSolvingPass(level + 1, widget, measurer);
        }
    }

    private static boolean canMeasure(int level, ConstraintWidget layout2) {
        boolean isVerticalFixed;
        ConstraintWidget.DimensionBehaviour horizontalBehaviour = layout2.getHorizontalDimensionBehaviour();
        ConstraintWidget.DimensionBehaviour verticalBehaviour = layout2.getVerticalDimensionBehaviour();
        ConstraintWidgetContainer parent = layout2.getParent() != null ? (ConstraintWidgetContainer)layout2.getParent() : null;
        boolean isParentHorizontalFixed = parent != null && parent.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED;
        boolean isParentVerticalFixed = parent != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED;
        boolean isHorizontalFixed = horizontalBehaviour == ConstraintWidget.DimensionBehaviour.FIXED || layout2.isResolvedHorizontally() || horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horizontalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout2.mMatchConstraintDefaultWidth == 0 && layout2.mDimensionRatio == 0.0f && layout2.hasDanglingDimension(0) || horizontalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout2.mMatchConstraintDefaultWidth == 1 && layout2.hasResolvedTargets(0, layout2.getWidth());
        boolean bl = isVerticalFixed = verticalBehaviour == ConstraintWidget.DimensionBehaviour.FIXED || layout2.isResolvedVertically() || verticalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || verticalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout2.mMatchConstraintDefaultHeight == 0 && layout2.mDimensionRatio == 0.0f && layout2.hasDanglingDimension(1) || verticalBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && layout2.mMatchConstraintDefaultHeight == 1 && layout2.hasResolvedTargets(1, layout2.getHeight());
        if (layout2.mDimensionRatio > 0.0f && (isHorizontalFixed || isVerticalFixed)) {
            return true;
        }
        return isHorizontalFixed && isVerticalFixed;
    }

    public static boolean solveChain(ConstraintWidgetContainer container, LinearSystem system, int orientation, int offset, ChainHead chainHead, boolean isChainSpread, boolean isChainSpreadInside, boolean isChainPacked) {
        ConstraintWidget next;
        if (isChainPacked) {
            return false;
        }
        if (orientation == 0 ? !container.isResolvedHorizontally() : !container.isResolvedVertically()) {
            return false;
        }
        int level = 0;
        boolean isRtl = container.isRtl();
        ConstraintWidget first2 = chainHead.getFirst();
        ConstraintWidget last2 = chainHead.getLast();
        ConstraintWidget firstVisibleWidget = chainHead.getFirstVisibleWidget();
        ConstraintWidget lastVisibleWidget = chainHead.getLastVisibleWidget();
        ConstraintWidget head = chainHead.getHead();
        ConstraintWidget widget = first2;
        boolean done = false;
        ConstraintAnchor begin = first2.mListAnchors[offset];
        ConstraintAnchor end = last2.mListAnchors[offset + 1];
        if (begin.mTarget == null || end.mTarget == null) {
            return false;
        }
        if (!begin.mTarget.hasFinalValue() || !end.mTarget.hasFinalValue()) {
            return false;
        }
        if (firstVisibleWidget == null || lastVisibleWidget == null) {
            return false;
        }
        int startPoint = begin.mTarget.getFinalValue() + firstVisibleWidget.mListAnchors[offset].getMargin();
        int endPoint = end.mTarget.getFinalValue() - lastVisibleWidget.mListAnchors[offset + 1].getMargin();
        int distance = endPoint - startPoint;
        if (distance <= 0) {
            return false;
        }
        int totalSize = 0;
        BasicMeasure.Measure measure = new BasicMeasure.Measure();
        int numWidgets = 0;
        int numVisibleWidgets = 0;
        while (!done) {
            ConstraintAnchor nextAnchor;
            boolean canMeasure = Direct.canMeasure(level + 1, widget);
            if (!canMeasure) {
                return false;
            }
            if (widget.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                return false;
            }
            if (widget.isMeasureRequested()) {
                ConstraintWidgetContainer.measure(level + 1, widget, container.getMeasurer(), measure, BasicMeasure.Measure.SELF_DIMENSIONS);
            }
            totalSize += widget.mListAnchors[offset].getMargin();
            totalSize = orientation == 0 ? (totalSize += widget.getWidth()) : (totalSize += widget.getHeight());
            totalSize += widget.mListAnchors[offset + 1].getMargin();
            ++numWidgets;
            if (widget.getVisibility() != 8) {
                ++numVisibleWidgets;
            }
            if ((nextAnchor = widget.mListAnchors[offset + 1].mTarget) != null) {
                next = nextAnchor.mOwner;
                if (next.mListAnchors[offset].mTarget == null || next.mListAnchors[offset].mTarget.mOwner != widget) {
                    next = null;
                }
            } else {
                next = null;
            }
            if (next != null) {
                widget = next;
                continue;
            }
            done = true;
        }
        if (numVisibleWidgets == 0) {
            return false;
        }
        if (numVisibleWidgets != numWidgets) {
            return false;
        }
        if (distance < totalSize) {
            return false;
        }
        int gap = distance - totalSize;
        if (isChainSpread) {
            gap /= numVisibleWidgets + 1;
        } else if (isChainSpreadInside && numVisibleWidgets > 2) {
            gap = gap / numVisibleWidgets - 1;
        }
        if (numVisibleWidgets == 1) {
            float bias = orientation == 0 ? head.getHorizontalBiasPercent() : head.getVerticalBiasPercent();
            int p1 = (int)(0.5f + (float)startPoint + (float)gap * bias);
            if (orientation == 0) {
                firstVisibleWidget.setFinalHorizontal(p1, p1 + firstVisibleWidget.getWidth());
            } else {
                firstVisibleWidget.setFinalVertical(p1, p1 + firstVisibleWidget.getHeight());
            }
            Direct.horizontalSolvingPass(level + 1, firstVisibleWidget, container.getMeasurer(), isRtl);
            return true;
        }
        if (isChainSpread) {
            done = false;
            int current = startPoint + gap;
            widget = first2;
            while (!done) {
                if (widget.getVisibility() == 8) {
                    if (orientation == 0) {
                        widget.setFinalHorizontal(current, current);
                        Direct.horizontalSolvingPass(level + 1, widget, container.getMeasurer(), isRtl);
                    } else {
                        widget.setFinalVertical(current, current);
                        Direct.verticalSolvingPass(level + 1, widget, container.getMeasurer());
                    }
                } else {
                    current += widget.mListAnchors[offset].getMargin();
                    if (orientation == 0) {
                        widget.setFinalHorizontal(current, current + widget.getWidth());
                        Direct.horizontalSolvingPass(level + 1, widget, container.getMeasurer(), isRtl);
                        current += widget.getWidth();
                    } else {
                        widget.setFinalVertical(current, current + widget.getHeight());
                        Direct.verticalSolvingPass(level + 1, widget, container.getMeasurer());
                        current += widget.getHeight();
                    }
                    current += widget.mListAnchors[offset + 1].getMargin();
                    current += gap;
                }
                widget.addToSolver(system, false);
                ConstraintAnchor nextAnchor = widget.mListAnchors[offset + 1].mTarget;
                if (nextAnchor != null) {
                    next = nextAnchor.mOwner;
                    if (next.mListAnchors[offset].mTarget == null || next.mListAnchors[offset].mTarget.mOwner != widget) {
                        next = null;
                    }
                } else {
                    next = null;
                }
                if (next != null) {
                    widget = next;
                    continue;
                }
                done = true;
            }
        } else if (isChainSpreadInside) {
            if (numVisibleWidgets == 2) {
                if (orientation == 0) {
                    firstVisibleWidget.setFinalHorizontal(startPoint, startPoint + firstVisibleWidget.getWidth());
                    lastVisibleWidget.setFinalHorizontal(endPoint - lastVisibleWidget.getWidth(), endPoint);
                    Direct.horizontalSolvingPass(level + 1, firstVisibleWidget, container.getMeasurer(), isRtl);
                    Direct.horizontalSolvingPass(level + 1, lastVisibleWidget, container.getMeasurer(), isRtl);
                } else {
                    firstVisibleWidget.setFinalVertical(startPoint, startPoint + firstVisibleWidget.getHeight());
                    lastVisibleWidget.setFinalVertical(endPoint - lastVisibleWidget.getHeight(), endPoint);
                    Direct.verticalSolvingPass(level + 1, firstVisibleWidget, container.getMeasurer());
                    Direct.verticalSolvingPass(level + 1, lastVisibleWidget, container.getMeasurer());
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

