/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;

class RunGroup {
    public static final int START = 0;
    public static final int END = 1;
    public static final int BASELINE = 2;
    public static int index;
    public int position = 0;
    public boolean dual = false;
    WidgetRun firstRun = null;
    WidgetRun lastRun = null;
    ArrayList<WidgetRun> runs = new ArrayList();
    int groupIndex = index++;
    int direction;

    public RunGroup(WidgetRun run, int dir) {
        this.firstRun = run;
        this.lastRun = run;
        this.direction = dir;
    }

    public void add(WidgetRun run) {
        this.runs.add(run);
        this.lastRun = run;
    }

    private long traverseStart(DependencyNode node, long startPosition) {
        WidgetRun run = node.run;
        if (run instanceof HelperReferences) {
            return startPosition;
        }
        long position = startPosition;
        int count2 = node.dependencies.size();
        for (int i = 0; i < count2; ++i) {
            Dependency dependency = node.dependencies.get(i);
            if (!(dependency instanceof DependencyNode)) continue;
            DependencyNode nextNode = (DependencyNode)dependency;
            if (nextNode.run == run) continue;
            position = Math.max(position, this.traverseStart(nextNode, startPosition + (long)nextNode.margin));
        }
        if (node == run.start) {
            long dimension = run.getWrapDimension();
            position = Math.max(position, this.traverseStart(run.end, startPosition + dimension));
            position = Math.max(position, startPosition + dimension - (long)run.end.margin);
        }
        return position;
    }

    private long traverseEnd(DependencyNode node, long startPosition) {
        WidgetRun run = node.run;
        if (run instanceof HelperReferences) {
            return startPosition;
        }
        long position = startPosition;
        int count2 = node.dependencies.size();
        for (int i = 0; i < count2; ++i) {
            Dependency dependency = node.dependencies.get(i);
            if (!(dependency instanceof DependencyNode)) continue;
            DependencyNode nextNode = (DependencyNode)dependency;
            if (nextNode.run == run) continue;
            position = Math.min(position, this.traverseEnd(nextNode, startPosition + (long)nextNode.margin));
        }
        if (node == run.end) {
            long dimension = run.getWrapDimension();
            position = Math.min(position, this.traverseEnd(run.start, startPosition - dimension));
            position = Math.min(position, startPosition - dimension - (long)run.start.margin);
        }
        return position;
    }

    public long computeWrapSize(ConstraintWidgetContainer container, int orientation) {
        if (this.firstRun instanceof ChainRun) {
            ChainRun chainRun = (ChainRun)this.firstRun;
            if (chainRun.orientation != orientation) {
                return 0L;
            }
        } else if (orientation == 0 ? !(this.firstRun instanceof HorizontalWidgetRun) : !(this.firstRun instanceof VerticalWidgetRun)) {
            return 0L;
        }
        DependencyNode containerStart = orientation == 0 ? container.horizontalRun.start : container.verticalRun.start;
        DependencyNode containerEnd = orientation == 0 ? container.horizontalRun.end : container.verticalRun.end;
        boolean runWithStartTarget = this.firstRun.start.targets.contains(containerStart);
        boolean runWithEndTarget = this.firstRun.end.targets.contains(containerEnd);
        long dimension = this.firstRun.getWrapDimension();
        if (runWithStartTarget && runWithEndTarget) {
            long startGap;
            long maxPosition = this.traverseStart(this.firstRun.start, 0L);
            long minPosition = this.traverseEnd(this.firstRun.end, 0L);
            long endGap = maxPosition - dimension;
            if (endGap >= (long)(-this.firstRun.end.margin)) {
                endGap += (long)this.firstRun.end.margin;
            }
            if ((startGap = -minPosition - dimension - (long)this.firstRun.start.margin) >= (long)this.firstRun.start.margin) {
                startGap -= (long)this.firstRun.start.margin;
            }
            float bias = this.firstRun.widget.getBiasPercent(orientation);
            long gap = 0L;
            if (bias > 0.0f) {
                gap = (long)((float)startGap / bias + (float)endGap / (1.0f - bias));
            }
            startGap = (long)(0.5f + (float)gap * bias);
            endGap = (long)(0.5f + (float)gap * (1.0f - bias));
            long runDimension = startGap + dimension + endGap;
            dimension = (long)this.firstRun.start.margin + runDimension - (long)this.firstRun.end.margin;
        } else if (runWithStartTarget) {
            long maxPosition = this.traverseStart(this.firstRun.start, this.firstRun.start.margin);
            long runDimension = (long)this.firstRun.start.margin + dimension;
            dimension = Math.max(maxPosition, runDimension);
        } else if (runWithEndTarget) {
            long minPosition = this.traverseEnd(this.firstRun.end, this.firstRun.end.margin);
            long runDimension = (long)(-this.firstRun.end.margin) + dimension;
            dimension = Math.max(-minPosition, runDimension);
        } else {
            dimension = (long)this.firstRun.start.margin + this.firstRun.getWrapDimension() - (long)this.firstRun.end.margin;
        }
        return dimension;
    }

    private boolean defineTerminalWidget(WidgetRun run, int orientation) {
        ChainRun chainRun;
        DependencyNode node;
        if (!run.widget.isTerminalWidget[orientation]) {
            return false;
        }
        for (Dependency dependency : run.start.dependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            node = (DependencyNode)dependency;
            if (node.run == run || node != node.run.start) continue;
            if (run instanceof ChainRun) {
                chainRun = (ChainRun)run;
                for (WidgetRun widgetChainRun : chainRun.widgets) {
                    this.defineTerminalWidget(widgetChainRun, orientation);
                }
            } else if (!(run instanceof HelperReferences)) {
                run.widget.isTerminalWidget[orientation] = false;
            }
            this.defineTerminalWidget(node.run, orientation);
        }
        for (Dependency dependency : run.end.dependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            node = (DependencyNode)dependency;
            if (node.run == run || node != node.run.start) continue;
            if (run instanceof ChainRun) {
                chainRun = (ChainRun)run;
                for (WidgetRun widgetChainRun : chainRun.widgets) {
                    this.defineTerminalWidget(widgetChainRun, orientation);
                }
            } else if (!(run instanceof HelperReferences)) {
                run.widget.isTerminalWidget[orientation] = false;
            }
            this.defineTerminalWidget(node.run, orientation);
        }
        return false;
    }

    public void defineTerminalWidgets(boolean horizontalCheck, boolean verticalCheck) {
        if (horizontalCheck && this.firstRun instanceof HorizontalWidgetRun) {
            this.defineTerminalWidget(this.firstRun, 0);
        }
        if (verticalCheck && this.firstRun instanceof VerticalWidgetRun) {
            this.defineTerminalWidget(this.firstRun, 1);
        }
    }
}

