/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.constraintlayout.motion.widget.MotionHelper;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import java.util.ArrayList;

public class Carousel
extends MotionHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "Carousel";
    private Adapter mAdapter = null;
    private final ArrayList<View> mList = new ArrayList();
    private int mPreviousIndex = 0;
    private int mIndex = 0;
    private MotionLayout mMotionLayout;
    private int firstViewReference = -1;
    private boolean infiniteCarousel = false;
    private int backwardTransition = -1;
    private int forwardTransition = -1;
    private int previousState = -1;
    private int nextState = -1;
    private float dampening = 0.9f;
    private int startIndex = 0;
    private int emptyViewBehavior = 4;
    public static final int TOUCH_UP_IMMEDIATE_STOP = 1;
    public static final int TOUCH_UP_CARRY_ON = 2;
    private int touchUpMode = 1;
    private float velocityThreshold = 2.0f;
    private int mTargetIndex = -1;
    private int mAnimateTargetDelay = 200;
    int mLastStartId = -1;
    Runnable mUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            Carousel.this.mMotionLayout.setProgress(0.0f);
            Carousel.this.updateItems();
            Carousel.this.mAdapter.onNewItem(Carousel.this.mIndex);
            float velocity = Carousel.this.mMotionLayout.getVelocity();
            if (Carousel.this.touchUpMode == 2 && velocity > Carousel.this.velocityThreshold && Carousel.this.mIndex < Carousel.this.mAdapter.count() - 1) {
                final float v = velocity * Carousel.this.dampening;
                if (Carousel.this.mIndex == 0 && Carousel.this.mPreviousIndex > Carousel.this.mIndex) {
                    return;
                }
                if (Carousel.this.mIndex == Carousel.this.mAdapter.count() - 1 && Carousel.this.mPreviousIndex < Carousel.this.mIndex) {
                    return;
                }
                Carousel.this.mMotionLayout.post(new Runnable(){

                    @Override
                    public void run() {
                        Carousel.this.mMotionLayout.touchAnimateTo(5, 1.0f, v);
                    }
                });
            }
        }
    };

    public Carousel(Context context) {
        super(context);
    }

    public Carousel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public Carousel(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Carousel);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.Carousel_carousel_firstView) {
                    this.firstViewReference = a.getResourceId(attr2, this.firstViewReference);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_backwardTransition) {
                    this.backwardTransition = a.getResourceId(attr2, this.backwardTransition);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_forwardTransition) {
                    this.forwardTransition = a.getResourceId(attr2, this.forwardTransition);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_emptyViewsBehavior) {
                    this.emptyViewBehavior = a.getInt(attr2, this.emptyViewBehavior);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_previousState) {
                    this.previousState = a.getResourceId(attr2, this.previousState);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_nextState) {
                    this.nextState = a.getResourceId(attr2, this.nextState);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_touchUp_dampeningFactor) {
                    this.dampening = a.getFloat(attr2, this.dampening);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_touchUpMode) {
                    this.touchUpMode = a.getInt(attr2, this.touchUpMode);
                    continue;
                }
                if (attr2 == R.styleable.Carousel_carousel_touchUp_velocityThreshold) {
                    this.velocityThreshold = a.getFloat(attr2, this.velocityThreshold);
                    continue;
                }
                if (attr2 != R.styleable.Carousel_carousel_infinite) continue;
                this.infiniteCarousel = a.getBoolean(attr2, this.infiniteCarousel);
            }
            a.recycle();
        }
    }

    public void setAdapter(Adapter adapter) {
        this.mAdapter = adapter;
    }

    public int getCount() {
        if (this.mAdapter != null) {
            return this.mAdapter.count();
        }
        return 0;
    }

    public int getCurrentIndex() {
        return this.mIndex;
    }

    public void transitionToIndex(int index, int delay) {
        this.mTargetIndex = Math.max(0, Math.min(this.getCount() - 1, index));
        this.mAnimateTargetDelay = Math.max(0, delay);
        this.mMotionLayout.setTransitionDuration(this.mAnimateTargetDelay);
        if (index < this.mIndex) {
            this.mMotionLayout.transitionToState(this.previousState, this.mAnimateTargetDelay);
        } else {
            this.mMotionLayout.transitionToState(this.nextState, this.mAnimateTargetDelay);
        }
    }

    public void jumpToIndex(int index) {
        this.mIndex = Math.max(0, Math.min(this.getCount() - 1, index));
        this.refresh();
    }

    public void refresh() {
        int count2 = this.mList.size();
        for (int i = 0; i < count2; ++i) {
            View view = this.mList.get(i);
            if (this.mAdapter.count() == 0) {
                this.updateViewVisibility(view, this.emptyViewBehavior);
                continue;
            }
            this.updateViewVisibility(view, 0);
        }
        this.mMotionLayout.rebuildScene();
        this.updateItems();
    }

    @Override
    public void onTransitionChange(MotionLayout motionLayout, int startId, int endId, float progress) {
        this.mLastStartId = startId;
    }

    @Override
    public void onTransitionCompleted(MotionLayout motionLayout, int currentId) {
        this.mPreviousIndex = this.mIndex++;
        if (currentId != this.nextState && currentId == this.previousState) {
            --this.mIndex;
        }
        if (this.infiniteCarousel) {
            if (this.mIndex >= this.mAdapter.count()) {
                this.mIndex = 0;
            }
            if (this.mIndex < 0) {
                this.mIndex = this.mAdapter.count() - 1;
            }
        } else {
            if (this.mIndex >= this.mAdapter.count()) {
                this.mIndex = this.mAdapter.count() - 1;
            }
            if (this.mIndex < 0) {
                this.mIndex = 0;
            }
        }
        if (this.mPreviousIndex != this.mIndex) {
            this.mMotionLayout.post(this.mUpdateRunnable);
        }
    }

    private void enableAllTransitions(boolean enable) {
        ArrayList<MotionScene.Transition> transitions = this.mMotionLayout.getDefinedTransitions();
        for (MotionScene.Transition transition : transitions) {
            transition.setEnabled(enable);
        }
    }

    private boolean enableTransition(int transitionID, boolean enable) {
        if (transitionID == -1) {
            return false;
        }
        if (this.mMotionLayout == null) {
            return false;
        }
        MotionScene.Transition transition = this.mMotionLayout.getTransition(transitionID);
        if (transition == null) {
            return false;
        }
        if (enable == transition.isEnabled()) {
            return false;
        }
        transition.setEnabled(enable);
        return true;
    }

    @Override
    @RequiresApi(api=17)
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MotionLayout container = null;
        if (!(this.getParent() instanceof MotionLayout)) {
            return;
        }
        container = (MotionLayout)this.getParent();
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            View view = container.getViewById(id2);
            if (this.firstViewReference == id2) {
                this.startIndex = i;
            }
            this.mList.add(view);
        }
        this.mMotionLayout = container;
        if (this.touchUpMode == 2) {
            MotionScene.Transition backward;
            MotionScene.Transition forward = this.mMotionLayout.getTransition(this.forwardTransition);
            if (forward != null) {
                forward.setOnTouchUp(5);
            }
            if ((backward = this.mMotionLayout.getTransition(this.backwardTransition)) != null) {
                backward.setOnTouchUp(5);
            }
        }
        this.updateItems();
    }

    private boolean updateViewVisibility(View view, int visibility) {
        if (this.mMotionLayout == null) {
            return false;
        }
        boolean needsMotionSceneRebuild = false;
        int[] constraintSets = this.mMotionLayout.getConstraintSetIds();
        for (int i = 0; i < constraintSets.length; ++i) {
            needsMotionSceneRebuild |= this.updateViewVisibility(constraintSets[i], view, visibility);
        }
        return needsMotionSceneRebuild;
    }

    private boolean updateViewVisibility(int constraintSetId, View view, int visibility) {
        ConstraintSet constraintSet = this.mMotionLayout.getConstraintSet(constraintSetId);
        if (constraintSet == null) {
            return false;
        }
        ConstraintSet.Constraint constraint = constraintSet.getConstraint(view.getId());
        if (constraint == null) {
            return false;
        }
        constraint.propertySet.mVisibilityMode = 1;
        view.setVisibility(visibility);
        return true;
    }

    private void updateItems() {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mMotionLayout == null) {
            return;
        }
        if (this.mAdapter.count() == 0) {
            return;
        }
        int viewCount = this.mList.size();
        for (int i = 0; i < viewCount; ++i) {
            View view = this.mList.get(i);
            int index = this.mIndex + i - this.startIndex;
            if (this.infiniteCarousel) {
                if (index < 0) {
                    if (this.emptyViewBehavior != 4) {
                        this.updateViewVisibility(view, this.emptyViewBehavior);
                    } else {
                        this.updateViewVisibility(view, 0);
                    }
                    if (index % this.mAdapter.count() == 0) {
                        this.mAdapter.populate(view, 0);
                        continue;
                    }
                    this.mAdapter.populate(view, this.mAdapter.count() + index % this.mAdapter.count());
                    continue;
                }
                if (index >= this.mAdapter.count()) {
                    if (index == this.mAdapter.count()) {
                        index = 0;
                    } else if (index > this.mAdapter.count()) {
                        index %= this.mAdapter.count();
                    }
                    if (this.emptyViewBehavior != 4) {
                        this.updateViewVisibility(view, this.emptyViewBehavior);
                    } else {
                        this.updateViewVisibility(view, 0);
                    }
                    this.mAdapter.populate(view, index);
                    continue;
                }
                this.updateViewVisibility(view, 0);
                this.mAdapter.populate(view, index);
                continue;
            }
            if (index < 0) {
                this.updateViewVisibility(view, this.emptyViewBehavior);
                continue;
            }
            if (index >= this.mAdapter.count()) {
                this.updateViewVisibility(view, this.emptyViewBehavior);
                continue;
            }
            this.updateViewVisibility(view, 0);
            this.mAdapter.populate(view, index);
        }
        if (this.mTargetIndex != -1 && this.mTargetIndex != this.mIndex) {
            this.mMotionLayout.post(() -> {
                this.mMotionLayout.setTransitionDuration(this.mAnimateTargetDelay);
                if (this.mTargetIndex < this.mIndex) {
                    this.mMotionLayout.transitionToState(this.previousState, this.mAnimateTargetDelay);
                } else {
                    this.mMotionLayout.transitionToState(this.nextState, this.mAnimateTargetDelay);
                }
            });
        } else if (this.mTargetIndex == this.mIndex) {
            this.mTargetIndex = -1;
        }
        if (this.backwardTransition == -1 || this.forwardTransition == -1) {
            Log.w((String)TAG, (String)"No backward or forward transitions defined for Carousel!");
            return;
        }
        if (this.infiniteCarousel) {
            return;
        }
        int count2 = this.mAdapter.count();
        if (this.mIndex == 0) {
            this.enableTransition(this.backwardTransition, false);
        } else {
            this.enableTransition(this.backwardTransition, true);
            this.mMotionLayout.setTransition(this.backwardTransition);
        }
        if (this.mIndex == count2 - 1) {
            this.enableTransition(this.forwardTransition, false);
        } else {
            this.enableTransition(this.forwardTransition, true);
            this.mMotionLayout.setTransition(this.forwardTransition);
        }
    }

    public static interface Adapter {
        public int count();

        public void populate(View var1, int var2);

        public void onNewItem(int var1);
    }
}

