/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.utils;

import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ViewOscillator
extends KeyCycleOscillator {
    private static final String TAG = "ViewOscillator";

    public abstract void setProperty(View var1, float var2);

    public static ViewOscillator makeSpline(String str) {
        if (str.startsWith("CUSTOM")) {
            return new CustomSet();
        }
        switch (str) {
            case "alpha": {
                return new AlphaSet();
            }
            case "elevation": {
                return new ElevationSet();
            }
            case "rotation": {
                return new RotationSet();
            }
            case "rotationX": {
                return new RotationXset();
            }
            case "rotationY": {
                return new RotationYset();
            }
            case "transitionPathRotate": {
                return new PathRotateSet();
            }
            case "scaleX": {
                return new ScaleXset();
            }
            case "scaleY": {
                return new ScaleYset();
            }
            case "waveOffset": {
                return new AlphaSet();
            }
            case "waveVariesBy": {
                return new AlphaSet();
            }
            case "translationX": {
                return new TranslationXset();
            }
            case "translationY": {
                return new TranslationYset();
            }
            case "translationZ": {
                return new TranslationZset();
            }
            case "progress": {
                return new ProgressSet();
            }
        }
        return null;
    }

    static class ProgressSet
    extends ViewOscillator {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(t));
            } else {
                if (this.mNoMethod) {
                    return;
                }
                Method method = null;
                try {
                    method = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException e) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(t)));
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ViewOscillator.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Log.e((String)ViewOscillator.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                }
            }
        }
    }

    static class CustomSet
    extends ViewOscillator {
        float[] value = new float[1];
        protected ConstraintAttribute mCustom;

        CustomSet() {
        }

        @Override
        protected void setCustom(Object custom) {
            this.mCustom = (ConstraintAttribute)custom;
        }

        @Override
        public void setProperty(View view, float t) {
            this.value[0] = this.get(t);
            CustomSupport.setInterpolatedValue(this.mCustom, view, this.value);
        }
    }

    static class TranslationZset
    extends ViewOscillator {
        TranslationZset() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(t));
            }
        }
    }

    static class TranslationYset
    extends ViewOscillator {
        TranslationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationY(this.get(t));
        }
    }

    static class TranslationXset
    extends ViewOscillator {
        TranslationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationX(this.get(t));
        }
    }

    static class ScaleYset
    extends ViewOscillator {
        ScaleYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleY(this.get(t));
        }
    }

    static class ScaleXset
    extends ViewOscillator {
        ScaleXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleX(this.get(t));
        }
    }

    public static class PathRotateSet
    extends ViewOscillator {
        @Override
        public void setProperty(View view, float t) {
        }

        public void setPathRotate(View view, float t, double dx, double dy) {
            view.setRotation(this.get(t) + (float)Math.toDegrees(Math.atan2(dy, dx)));
        }
    }

    static class RotationYset
    extends ViewOscillator {
        RotationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationY(this.get(t));
        }
    }

    static class RotationXset
    extends ViewOscillator {
        RotationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationX(this.get(t));
        }
    }

    static class RotationSet
    extends ViewOscillator {
        RotationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotation(this.get(t));
        }
    }

    static class AlphaSet
    extends ViewOscillator {
        AlphaSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setAlpha(this.get(t));
        }
    }

    static class ElevationSet
    extends ViewOscillator {
        ElevationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(t));
            }
        }
    }
}

