/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.utils;

import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.TimeCycleSplineSet;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ViewTimeCycle
extends TimeCycleSplineSet {
    private static final String TAG = "ViewTimeCycle";

    public abstract boolean setProperty(View var1, float var2, long var3, KeyCache var5);

    public float get(float pos, long time, View view, KeyCache cache2) {
        this.mCurveFit.getPos((double)pos, this.mCache);
        float period = this.mCache[1];
        if (period == 0.0f) {
            this.mContinue = false;
            return this.mCache[2];
        }
        if (Float.isNaN(this.last_cycle)) {
            this.last_cycle = cache2.getFloatValue(view, this.mType, 0);
            if (Float.isNaN(this.last_cycle)) {
                this.last_cycle = 0.0f;
            }
        }
        long delta_time = time - this.last_time;
        this.last_cycle = (float)(((double)this.last_cycle + (double)delta_time * 1.0E-9 * (double)period) % 1.0);
        cache2.setFloatValue(view, this.mType, 0, this.last_cycle);
        this.last_time = time;
        float v = this.mCache[0];
        float wave = this.calcWave(this.last_cycle);
        float offset = this.mCache[2];
        float value = v * wave + offset;
        this.mContinue = v != 0.0f || period != 0.0f;
        return value;
    }

    public static ViewTimeCycle makeCustomSpline(String str, SparseArray<ConstraintAttribute> attrList) {
        return new CustomSet(str, attrList);
    }

    public static ViewTimeCycle makeSpline(String str, long currentTime) {
        ViewTimeCycle timeCycle;
        switch (str) {
            case "alpha": {
                timeCycle = new AlphaSet();
                break;
            }
            case "elevation": {
                timeCycle = new ElevationSet();
                break;
            }
            case "rotation": {
                timeCycle = new RotationSet();
                break;
            }
            case "rotationX": {
                timeCycle = new RotationXset();
                break;
            }
            case "rotationY": {
                timeCycle = new RotationYset();
                break;
            }
            case "transitionPathRotate": {
                timeCycle = new PathRotate();
                break;
            }
            case "scaleX": {
                timeCycle = new ScaleXset();
                break;
            }
            case "scaleY": {
                timeCycle = new ScaleYset();
                break;
            }
            case "translationX": {
                timeCycle = new TranslationXset();
                break;
            }
            case "translationY": {
                timeCycle = new TranslationYset();
                break;
            }
            case "translationZ": {
                timeCycle = new TranslationZset();
                break;
            }
            case "progress": {
                timeCycle = new ProgressSet();
                break;
            }
            default: {
                return null;
            }
        }
        timeCycle.setStartTime(currentTime);
        return timeCycle;
    }

    static class ProgressSet
    extends ViewTimeCycle {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(t, time, view, cache2));
            } else {
                if (this.mNoMethod) {
                    return false;
                }
                Method method = null;
                try {
                    method = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException e) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(t, time, view, cache2)));
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ViewTimeCycle.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Log.e((String)ViewTimeCycle.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                }
            }
            return this.mContinue;
        }
    }

    public static class CustomSet
    extends ViewTimeCycle {
        String mAttributeName;
        SparseArray<ConstraintAttribute> mConstraintAttributeList;
        SparseArray<float[]> mWaveProperties = new SparseArray();
        float[] mTempValues;
        float[] mCache;

        public CustomSet(String attribute, SparseArray<ConstraintAttribute> attrList) {
            this.mAttributeName = attribute.split(",")[1];
            this.mConstraintAttributeList = attrList;
        }

        @Override
        public void setup(int curveType) {
            int size = this.mConstraintAttributeList.size();
            int dimensionality = ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).numberOfInterpolatedValues();
            double[] time = new double[size];
            this.mTempValues = new float[dimensionality + 2];
            this.mCache = new float[dimensionality];
            double[][] values2 = new double[size][dimensionality + 2];
            for (int i = 0; i < size; ++i) {
                int key = this.mConstraintAttributeList.keyAt(i);
                ConstraintAttribute ca = (ConstraintAttribute)this.mConstraintAttributeList.valueAt(i);
                float[] waveProp = (float[])this.mWaveProperties.valueAt(i);
                time[i] = (double)key * 0.01;
                ca.getValuesToInterpolate(this.mTempValues);
                for (int k = 0; k < this.mTempValues.length; ++k) {
                    values2[i][k] = this.mTempValues[k];
                }
                values2[i][dimensionality] = waveProp[0];
                values2[i][dimensionality + 1] = waveProp[1];
            }
            this.mCurveFit = CurveFit.get(curveType, time, values2);
        }

        @Override
        public void setPoint(int position, float value, float period, int shape, float offset) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute,...)");
        }

        public void setPoint(int position, ConstraintAttribute value, float period, int shape, float offset) {
            this.mConstraintAttributeList.append(position, (Object)value);
            this.mWaveProperties.append(position, (Object)new float[]{period, offset});
            this.mWaveShape = Math.max(this.mWaveShape, shape);
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            this.mCurveFit.getPos((double)t, this.mTempValues);
            float period = this.mTempValues[this.mTempValues.length - 2];
            float offset = this.mTempValues[this.mTempValues.length - 1];
            long delta_time = time - this.last_time;
            if (Float.isNaN(this.last_cycle)) {
                this.last_cycle = cache2.getFloatValue(view, this.mAttributeName, 0);
                if (Float.isNaN(this.last_cycle)) {
                    this.last_cycle = 0.0f;
                }
            }
            this.last_cycle = (float)(((double)this.last_cycle + (double)delta_time * 1.0E-9 * (double)period) % 1.0);
            this.last_time = time;
            float wave = this.calcWave(this.last_cycle);
            this.mContinue = false;
            for (int i = 0; i < this.mCache.length; ++i) {
                this.mContinue |= (double)this.mTempValues[i] != 0.0;
                this.mCache[i] = this.mTempValues[i] * wave + offset;
            }
            CustomSupport.setInterpolatedValue((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0), view, this.mCache);
            if (period != 0.0f) {
                this.mContinue = true;
            }
            return this.mContinue;
        }
    }

    static class TranslationZset
    extends ViewTimeCycle {
        TranslationZset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(t, time, view, cache2));
            }
            return this.mContinue;
        }
    }

    static class TranslationYset
    extends ViewTimeCycle {
        TranslationYset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setTranslationY(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    static class TranslationXset
    extends ViewTimeCycle {
        TranslationXset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setTranslationX(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    static class ScaleYset
    extends ViewTimeCycle {
        ScaleYset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setScaleY(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    static class ScaleXset
    extends ViewTimeCycle {
        ScaleXset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setScaleX(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    public static class PathRotate
    extends ViewTimeCycle {
        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            return this.mContinue;
        }

        public boolean setPathRotate(View view, KeyCache cache2, float t, long time, double dx, double dy) {
            view.setRotation(this.get(t, time, view, cache2) + (float)Math.toDegrees(Math.atan2(dy, dx)));
            return this.mContinue;
        }
    }

    static class RotationYset
    extends ViewTimeCycle {
        RotationYset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setRotationY(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    static class RotationXset
    extends ViewTimeCycle {
        RotationXset() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setRotationX(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    static class RotationSet
    extends ViewTimeCycle {
        RotationSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setRotation(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    static class AlphaSet
    extends ViewTimeCycle {
        AlphaSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            view.setAlpha(this.get(t, time, view, cache2));
            return this.mContinue;
        }
    }

    static class ElevationSet
    extends ViewTimeCycle {
        ElevationSet() {
        }

        @Override
        public boolean setProperty(View view, float t, long time, KeyCache cache2) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(t, time, view, cache2));
            }
            return this.mContinue;
        }
    }
}

