/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;
import java.util.HashSet;

public class KeyAttributes
extends Key {
    static final String NAME = "KeyAttribute";
    private static final String TAG = "KeyAttributes";
    private static final boolean DEBUG = false;
    private String mTransitionEasing;
    private int mCurveFit = -1;
    private boolean mVisibility = false;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mPivotX = Float.NaN;
    private float mPivotY = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    private float mProgress = Float.NaN;
    public static final int KEY_TYPE = 1;

    public KeyAttributes() {
        this.mType = 1;
        this.mCustomConstraints = new HashMap();
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyAttribute);
        Loader.read(this, a);
    }

    int getCurveFit() {
        return this.mCurveFit;
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotation");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mPivotX)) {
            attributes.add("transformPivotX");
        }
        if (!Float.isNaN(this.mPivotY)) {
            attributes.add("transformPivotY");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mProgress)) {
            attributes.add("progress");
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    @Override
    public void setInterpolation(HashMap<String, Integer> interpolation) {
        if (this.mCurveFit == -1) {
            return;
        }
        if (!Float.isNaN(this.mAlpha)) {
            interpolation.put("alpha", this.mCurveFit);
        }
        if (!Float.isNaN(this.mElevation)) {
            interpolation.put("elevation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotation)) {
            interpolation.put("rotation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationX)) {
            interpolation.put("rotationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationY)) {
            interpolation.put("rotationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mPivotX)) {
            interpolation.put("transformPivotX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mPivotY)) {
            interpolation.put("transformPivotY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationX)) {
            interpolation.put("translationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationY)) {
            interpolation.put("translationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            interpolation.put("translationZ", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            interpolation.put("transitionPathRotate", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleX)) {
            interpolation.put("scaleX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleY)) {
            interpolation.put("scaleY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mProgress)) {
            interpolation.put("progress", this.mCurveFit);
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                interpolation.put("CUSTOM," + s, this.mCurveFit);
            }
        }
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> splines) {
        for (String s : splines.keySet()) {
            SplineSet splineSet = splines.get(s);
            if (splineSet == null) continue;
            if (s.startsWith("CUSTOM")) {
                String cKey = s.substring("CUSTOM".length() + 1);
                ConstraintAttribute cValue = (ConstraintAttribute)this.mCustomConstraints.get(cKey);
                if (cValue == null) continue;
                ((ViewSpline.CustomSet)splineSet).setPoint(this.mFramePosition, cValue);
                continue;
            }
            switch (s) {
                case "alpha": {
                    if (Float.isNaN(this.mAlpha)) break;
                    splineSet.setPoint(this.mFramePosition, this.mAlpha);
                    break;
                }
                case "elevation": {
                    if (Float.isNaN(this.mElevation)) break;
                    splineSet.setPoint(this.mFramePosition, this.mElevation);
                    break;
                }
                case "rotation": {
                    if (Float.isNaN(this.mRotation)) break;
                    splineSet.setPoint(this.mFramePosition, this.mRotation);
                    break;
                }
                case "rotationX": {
                    if (Float.isNaN(this.mRotationX)) break;
                    splineSet.setPoint(this.mFramePosition, this.mRotationX);
                    break;
                }
                case "rotationY": {
                    if (Float.isNaN(this.mRotationY)) break;
                    splineSet.setPoint(this.mFramePosition, this.mRotationY);
                    break;
                }
                case "transformPivotX": {
                    if (Float.isNaN(this.mRotationX)) break;
                    splineSet.setPoint(this.mFramePosition, this.mPivotX);
                    break;
                }
                case "transformPivotY": {
                    if (Float.isNaN(this.mRotationY)) break;
                    splineSet.setPoint(this.mFramePosition, this.mPivotY);
                    break;
                }
                case "transitionPathRotate": {
                    if (Float.isNaN(this.mTransitionPathRotate)) break;
                    splineSet.setPoint(this.mFramePosition, this.mTransitionPathRotate);
                    break;
                }
                case "scaleX": {
                    if (Float.isNaN(this.mScaleX)) break;
                    splineSet.setPoint(this.mFramePosition, this.mScaleX);
                    break;
                }
                case "scaleY": {
                    if (Float.isNaN(this.mScaleY)) break;
                    splineSet.setPoint(this.mFramePosition, this.mScaleY);
                    break;
                }
                case "translationX": {
                    if (Float.isNaN(this.mTranslationX)) break;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationX);
                    break;
                }
                case "translationY": {
                    if (Float.isNaN(this.mTranslationY)) break;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationY);
                    break;
                }
                case "translationZ": {
                    if (Float.isNaN(this.mTranslationZ)) break;
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ);
                    break;
                }
                case "progress": {
                    if (Float.isNaN(this.mProgress)) break;
                    splineSet.setPoint(this.mFramePosition, this.mProgress);
                    break;
                }
            }
        }
    }

    @Override
    public void setValue(String tag, Object value) {
        switch (tag) {
            case "alpha": {
                this.mAlpha = this.toFloat(value);
                break;
            }
            case "curveFit": {
                this.mCurveFit = this.toInt(value);
                break;
            }
            case "elevation": {
                this.mElevation = this.toFloat(value);
                break;
            }
            case "motionProgress": {
                this.mProgress = this.toFloat(value);
                break;
            }
            case "rotation": {
                this.mRotation = this.toFloat(value);
                break;
            }
            case "rotationX": {
                this.mRotationX = this.toFloat(value);
                break;
            }
            case "rotationY": {
                this.mRotationY = this.toFloat(value);
                break;
            }
            case "transformPivotX": {
                this.mPivotX = this.toFloat(value);
                break;
            }
            case "transformPivotY": {
                this.mPivotY = this.toFloat(value);
                break;
            }
            case "scaleX": {
                this.mScaleX = this.toFloat(value);
                break;
            }
            case "scaleY": {
                this.mScaleY = this.toFloat(value);
                break;
            }
            case "transitionEasing": {
                this.mTransitionEasing = value.toString();
                break;
            }
            case "visibility": {
                this.mVisibility = this.toBoolean(value);
                break;
            }
            case "transitionPathRotate": {
                this.mTransitionPathRotate = this.toFloat(value);
                break;
            }
            case "translationX": {
                this.mTranslationX = this.toFloat(value);
                break;
            }
            case "translationY": {
                this.mTranslationY = this.toFloat(value);
                break;
            }
            case "translationZ": {
                this.mTranslationZ = this.toFloat(value);
            }
        }
    }

    @Override
    public Key copy(Key src) {
        super.copy(src);
        KeyAttributes k = (KeyAttributes)src;
        this.mCurveFit = k.mCurveFit;
        this.mVisibility = k.mVisibility;
        this.mAlpha = k.mAlpha;
        this.mElevation = k.mElevation;
        this.mRotation = k.mRotation;
        this.mRotationX = k.mRotationX;
        this.mRotationY = k.mRotationY;
        this.mPivotX = k.mPivotX;
        this.mPivotY = k.mPivotY;
        this.mTransitionPathRotate = k.mTransitionPathRotate;
        this.mScaleX = k.mScaleX;
        this.mScaleY = k.mScaleY;
        this.mTranslationX = k.mTranslationX;
        this.mTranslationY = k.mTranslationY;
        this.mTranslationZ = k.mTranslationZ;
        this.mProgress = k.mProgress;
        return this;
    }

    @Override
    public Key clone() {
        return new KeyAttributes().copy(this);
    }

    private static class Loader {
        private static final int ANDROID_ALPHA = 1;
        private static final int ANDROID_ELEVATION = 2;
        private static final int ANDROID_ROTATION = 4;
        private static final int ANDROID_ROTATION_X = 5;
        private static final int ANDROID_ROTATION_Y = 6;
        private static final int TRANSITION_PATH_ROTATE = 8;
        private static final int ANDROID_SCALE_X = 7;
        private static final int TRANSITION_EASING = 9;
        private static final int TARGET_ID = 10;
        private static final int FRAME_POSITION = 12;
        private static final int CURVE_FIT = 13;
        private static final int ANDROID_SCALE_Y = 14;
        private static final int ANDROID_TRANSLATION_X = 15;
        private static final int ANDROID_TRANSLATION_Y = 16;
        private static final int ANDROID_TRANSLATION_Z = 17;
        private static final int PROGRESS = 18;
        private static final int ANDROID_PIVOT_X = 19;
        private static final int ANDROID_PIVOT_Y = 20;
        private static SparseIntArray mAttrMap = new SparseIntArray();

        private Loader() {
        }

        public static void read(KeyAttributes c, TypedArray a) {
            int N = a.getIndexCount();
            block20: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (mAttrMap.get(attr2)) {
                    case 10: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            c.mTargetId = a.getResourceId(attr2, c.mTargetId);
                            if (c.mTargetId != -1) continue block20;
                            c.mTargetString = a.getString(attr2);
                            continue block20;
                        }
                        if (a.peekValue((int)attr2).type == 3) {
                            c.mTargetString = a.getString(attr2);
                            continue block20;
                        }
                        c.mTargetId = a.getResourceId(attr2, c.mTargetId);
                        continue block20;
                    }
                    case 12: {
                        c.mFramePosition = a.getInt(attr2, c.mFramePosition);
                        continue block20;
                    }
                    case 1: {
                        c.mAlpha = a.getFloat(attr2, c.mAlpha);
                        continue block20;
                    }
                    case 2: {
                        c.mElevation = a.getDimension(attr2, c.mElevation);
                        continue block20;
                    }
                    case 4: {
                        c.mRotation = a.getFloat(attr2, c.mRotation);
                        continue block20;
                    }
                    case 13: {
                        c.mCurveFit = a.getInteger(attr2, c.mCurveFit);
                        continue block20;
                    }
                    case 7: {
                        c.mScaleX = a.getFloat(attr2, c.mScaleX);
                        continue block20;
                    }
                    case 5: {
                        c.mRotationX = a.getFloat(attr2, c.mRotationX);
                        continue block20;
                    }
                    case 6: {
                        c.mRotationY = a.getFloat(attr2, c.mRotationY);
                        continue block20;
                    }
                    case 19: {
                        c.mPivotX = a.getDimension(attr2, c.mPivotX);
                        continue block20;
                    }
                    case 20: {
                        c.mPivotY = a.getDimension(attr2, c.mPivotY);
                        continue block20;
                    }
                    case 9: {
                        c.mTransitionEasing = a.getString(attr2);
                        continue block20;
                    }
                    case 14: {
                        c.mScaleY = a.getFloat(attr2, c.mScaleY);
                        continue block20;
                    }
                    case 8: {
                        c.mTransitionPathRotate = a.getFloat(attr2, c.mTransitionPathRotate);
                        continue block20;
                    }
                    case 15: {
                        c.mTranslationX = a.getDimension(attr2, c.mTranslationX);
                        continue block20;
                    }
                    case 16: {
                        c.mTranslationY = a.getDimension(attr2, c.mTranslationY);
                        continue block20;
                    }
                    case 17: {
                        if (Build.VERSION.SDK_INT < 21) continue block20;
                        c.mTranslationZ = a.getDimension(attr2, c.mTranslationZ);
                        continue block20;
                    }
                    case 18: {
                        c.mProgress = a.getFloat(attr2, c.mProgress);
                        continue block20;
                    }
                    default: {
                        Log.e((String)KeyAttributes.NAME, (String)("unused attribute 0x" + Integer.toHexString(attr2) + "   " + mAttrMap.get(attr2)));
                    }
                }
            }
        }

        static {
            mAttrMap.append(R.styleable.KeyAttribute_android_alpha, 1);
            mAttrMap.append(R.styleable.KeyAttribute_android_elevation, 2);
            mAttrMap.append(R.styleable.KeyAttribute_android_rotation, 4);
            mAttrMap.append(R.styleable.KeyAttribute_android_rotationX, 5);
            mAttrMap.append(R.styleable.KeyAttribute_android_rotationY, 6);
            mAttrMap.append(R.styleable.KeyAttribute_android_transformPivotX, 19);
            mAttrMap.append(R.styleable.KeyAttribute_android_transformPivotY, 20);
            mAttrMap.append(R.styleable.KeyAttribute_android_scaleX, 7);
            mAttrMap.append(R.styleable.KeyAttribute_transitionPathRotate, 8);
            mAttrMap.append(R.styleable.KeyAttribute_transitionEasing, 9);
            mAttrMap.append(R.styleable.KeyAttribute_motionTarget, 10);
            mAttrMap.append(R.styleable.KeyAttribute_framePosition, 12);
            mAttrMap.append(R.styleable.KeyAttribute_curveFit, 13);
            mAttrMap.append(R.styleable.KeyAttribute_android_scaleY, 14);
            mAttrMap.append(R.styleable.KeyAttribute_android_translationX, 15);
            mAttrMap.append(R.styleable.KeyAttribute_android_translationY, 16);
            mAttrMap.append(R.styleable.KeyAttribute_android_translationZ, 17);
            mAttrMap.append(R.styleable.KeyAttribute_motionProgress, 18);
        }
    }
}

