/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.TypedValue;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.motion.utils.ViewOscillator;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;
import java.util.HashSet;

public class KeyCycle
extends Key {
    private static final String TAG = "KeyCycle";
    static final String NAME = "KeyCycle";
    public static final String WAVE_PERIOD = "wavePeriod";
    public static final String WAVE_OFFSET = "waveOffset";
    public static final String WAVE_PHASE = "wavePhase";
    public static final String WAVE_SHAPE = "waveShape";
    public static final int SHAPE_SIN_WAVE = 0;
    public static final int SHAPE_SQUARE_WAVE = 1;
    public static final int SHAPE_TRIANGLE_WAVE = 2;
    public static final int SHAPE_SAW_WAVE = 3;
    public static final int SHAPE_REVERSE_SAW_WAVE = 4;
    public static final int SHAPE_COS_WAVE = 5;
    public static final int SHAPE_BOUNCE = 6;
    private String mTransitionEasing = null;
    private int mCurveFit = 0;
    private int mWaveShape = -1;
    private String mCustomWaveShape = null;
    private float mWavePeriod = Float.NaN;
    private float mWaveOffset = 0.0f;
    private float mWavePhase = 0.0f;
    private float mProgress = Float.NaN;
    private int mWaveVariesBy = -1;
    private float mAlpha = Float.NaN;
    private float mElevation = Float.NaN;
    private float mRotation = Float.NaN;
    private float mTransitionPathRotate = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mScaleX = Float.NaN;
    private float mScaleY = Float.NaN;
    private float mTranslationX = Float.NaN;
    private float mTranslationY = Float.NaN;
    private float mTranslationZ = Float.NaN;
    public static final int KEY_TYPE = 4;

    public KeyCycle() {
        this.mType = 4;
        this.mCustomConstraints = new HashMap();
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyCycle);
        Loader.read(this, a);
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
        if (!Float.isNaN(this.mAlpha)) {
            attributes.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            attributes.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            attributes.add("rotation");
        }
        if (!Float.isNaN(this.mRotationX)) {
            attributes.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            attributes.add("rotationY");
        }
        if (!Float.isNaN(this.mScaleX)) {
            attributes.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            attributes.add("scaleY");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            attributes.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            attributes.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            attributes.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            attributes.add("translationZ");
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String s : this.mCustomConstraints.keySet()) {
                attributes.add("CUSTOM," + s);
            }
        }
    }

    public void addCycleValues(HashMap<String, ViewOscillator> oscSet) {
        for (String key : oscSet.keySet()) {
            ViewOscillator osc;
            if (key.startsWith("CUSTOM")) {
                ViewOscillator osc2;
                String customKey = key.substring("CUSTOM".length() + 1);
                ConstraintAttribute cValue = (ConstraintAttribute)this.mCustomConstraints.get(customKey);
                if (cValue == null || cValue.getType() != ConstraintAttribute.AttributeType.FLOAT_TYPE || (osc2 = oscSet.get(key)) == null) continue;
                osc2.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, this.mWaveVariesBy, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, cValue.getValueToInterpolate(), cValue);
                continue;
            }
            float value = this.getValue(key);
            if (Float.isNaN(value) || (osc = oscSet.get(key)) == null) continue;
            osc.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, this.mWaveVariesBy, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, value);
        }
    }

    public float getValue(String key) {
        switch (key) {
            case "alpha": {
                return this.mAlpha;
            }
            case "elevation": {
                return this.mElevation;
            }
            case "rotation": {
                return this.mRotation;
            }
            case "rotationX": {
                return this.mRotationX;
            }
            case "rotationY": {
                return this.mRotationY;
            }
            case "transitionPathRotate": {
                return this.mTransitionPathRotate;
            }
            case "scaleX": {
                return this.mScaleX;
            }
            case "scaleY": {
                return this.mScaleY;
            }
            case "translationX": {
                return this.mTranslationX;
            }
            case "translationY": {
                return this.mTranslationY;
            }
            case "translationZ": {
                return this.mTranslationZ;
            }
            case "waveOffset": {
                return this.mWaveOffset;
            }
            case "wavePhase": {
                return this.mWavePhase;
            }
            case "progress": {
                return this.mProgress;
            }
        }
        if (!key.startsWith("CUSTOM")) {
            Log.v((String)"WARNING! KeyCycle", (String)("  UNKNOWN  " + key));
        }
        return Float.NaN;
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> splines) {
        Debug.logStack("KeyCycle", "add " + splines.size() + " values", 2);
        block32: for (String s : splines.keySet()) {
            SplineSet splineSet = splines.get(s);
            if (splineSet == null) continue;
            switch (s) {
                case "alpha": {
                    splineSet.setPoint(this.mFramePosition, this.mAlpha);
                    continue block32;
                }
                case "elevation": {
                    splineSet.setPoint(this.mFramePosition, this.mElevation);
                    continue block32;
                }
                case "rotation": {
                    splineSet.setPoint(this.mFramePosition, this.mRotation);
                    continue block32;
                }
                case "rotationX": {
                    splineSet.setPoint(this.mFramePosition, this.mRotationX);
                    continue block32;
                }
                case "rotationY": {
                    splineSet.setPoint(this.mFramePosition, this.mRotationY);
                    continue block32;
                }
                case "transitionPathRotate": {
                    splineSet.setPoint(this.mFramePosition, this.mTransitionPathRotate);
                    continue block32;
                }
                case "scaleX": {
                    splineSet.setPoint(this.mFramePosition, this.mScaleX);
                    continue block32;
                }
                case "scaleY": {
                    splineSet.setPoint(this.mFramePosition, this.mScaleY);
                    continue block32;
                }
                case "translationX": {
                    splineSet.setPoint(this.mFramePosition, this.mTranslationX);
                    continue block32;
                }
                case "translationY": {
                    splineSet.setPoint(this.mFramePosition, this.mTranslationY);
                    continue block32;
                }
                case "translationZ": {
                    splineSet.setPoint(this.mFramePosition, this.mTranslationZ);
                    continue block32;
                }
                case "waveOffset": {
                    splineSet.setPoint(this.mFramePosition, this.mWaveOffset);
                    continue block32;
                }
                case "wavePhase": {
                    splineSet.setPoint(this.mFramePosition, this.mWavePhase);
                    continue block32;
                }
                case "progress": {
                    splineSet.setPoint(this.mFramePosition, this.mProgress);
                    continue block32;
                }
            }
            if (s.startsWith("CUSTOM")) continue;
            Log.v((String)"WARNING KeyCycle", (String)("  UNKNOWN  " + s));
        }
    }

    @Override
    public void setValue(String tag, Object value) {
        switch (tag) {
            case "alpha": {
                this.mAlpha = this.toFloat(value);
                break;
            }
            case "curveFit": {
                this.mCurveFit = this.toInt(value);
                break;
            }
            case "elevation": {
                this.mElevation = this.toFloat(value);
                break;
            }
            case "motionProgress": {
                this.mProgress = this.toFloat(value);
                break;
            }
            case "rotation": {
                this.mRotation = this.toFloat(value);
                break;
            }
            case "rotationX": {
                this.mRotationX = this.toFloat(value);
                break;
            }
            case "rotationY": {
                this.mRotationY = this.toFloat(value);
                break;
            }
            case "scaleX": {
                this.mScaleX = this.toFloat(value);
                break;
            }
            case "scaleY": {
                this.mScaleY = this.toFloat(value);
                break;
            }
            case "transitionEasing": {
                this.mTransitionEasing = value.toString();
                break;
            }
            case "transitionPathRotate": {
                this.mTransitionPathRotate = this.toFloat(value);
                break;
            }
            case "translationX": {
                this.mTranslationX = this.toFloat(value);
                break;
            }
            case "translationY": {
                this.mTranslationY = this.toFloat(value);
                break;
            }
            case "translationZ": {
                this.mTranslationZ = this.toFloat(value);
                break;
            }
            case "wavePeriod": {
                this.mWavePeriod = this.toFloat(value);
                break;
            }
            case "waveOffset": {
                this.mWaveOffset = this.toFloat(value);
                break;
            }
            case "wavePhase": {
                this.mWavePhase = this.toFloat(value);
                break;
            }
            case "waveShape": {
                if (value instanceof Integer) {
                    this.mWaveShape = this.toInt(value);
                    break;
                }
                this.mWaveShape = 7;
                this.mCustomWaveShape = value.toString();
            }
        }
    }

    @Override
    public Key copy(Key src) {
        super.copy(src);
        KeyCycle k = (KeyCycle)src;
        this.mTransitionEasing = k.mTransitionEasing;
        this.mCurveFit = k.mCurveFit;
        this.mWaveShape = k.mWaveShape;
        this.mCustomWaveShape = k.mCustomWaveShape;
        this.mWavePeriod = k.mWavePeriod;
        this.mWaveOffset = k.mWaveOffset;
        this.mWavePhase = k.mWavePhase;
        this.mProgress = k.mProgress;
        this.mWaveVariesBy = k.mWaveVariesBy;
        this.mAlpha = k.mAlpha;
        this.mElevation = k.mElevation;
        this.mRotation = k.mRotation;
        this.mTransitionPathRotate = k.mTransitionPathRotate;
        this.mRotationX = k.mRotationX;
        this.mRotationY = k.mRotationY;
        this.mScaleX = k.mScaleX;
        this.mScaleY = k.mScaleY;
        this.mTranslationX = k.mTranslationX;
        this.mTranslationY = k.mTranslationY;
        this.mTranslationZ = k.mTranslationZ;
        return this;
    }

    @Override
    public Key clone() {
        return new KeyCycle().copy(this);
    }

    private static class Loader {
        private static final int TARGET_ID = 1;
        private static final int FRAME_POSITION = 2;
        private static final int TRANSITION_EASING = 3;
        private static final int CURVE_FIT = 4;
        private static final int WAVE_SHAPE = 5;
        private static final int WAVE_PERIOD = 6;
        private static final int WAVE_OFFSET = 7;
        private static final int WAVE_VARIES_BY = 8;
        private static final int ANDROID_ALPHA = 9;
        private static final int ANDROID_ELEVATION = 10;
        private static final int ANDROID_ROTATION = 11;
        private static final int ANDROID_ROTATION_X = 12;
        private static final int ANDROID_ROTATION_Y = 13;
        private static final int TRANSITION_PATH_ROTATE = 14;
        private static final int ANDROID_SCALE_X = 15;
        private static final int ANDROID_SCALE_Y = 16;
        private static final int ANDROID_TRANSLATION_X = 17;
        private static final int ANDROID_TRANSLATION_Y = 18;
        private static final int ANDROID_TRANSLATION_Z = 19;
        private static final int PROGRESS = 20;
        private static final int WAVE_PHASE = 21;
        private static SparseIntArray mAttrMap = new SparseIntArray();

        private Loader() {
        }

        private static void read(KeyCycle c, TypedArray a) {
            int N = a.getIndexCount();
            block23: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (mAttrMap.get(attr2)) {
                    case 1: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            c.mTargetId = a.getResourceId(attr2, c.mTargetId);
                            if (c.mTargetId != -1) continue block23;
                            c.mTargetString = a.getString(attr2);
                            continue block23;
                        }
                        if (a.peekValue((int)attr2).type == 3) {
                            c.mTargetString = a.getString(attr2);
                            continue block23;
                        }
                        c.mTargetId = a.getResourceId(attr2, c.mTargetId);
                        continue block23;
                    }
                    case 2: {
                        c.mFramePosition = a.getInt(attr2, c.mFramePosition);
                        continue block23;
                    }
                    case 3: {
                        c.mTransitionEasing = a.getString(attr2);
                        continue block23;
                    }
                    case 4: {
                        c.mCurveFit = a.getInteger(attr2, c.mCurveFit);
                        continue block23;
                    }
                    case 5: {
                        if (a.peekValue((int)attr2).type == 3) {
                            c.mCustomWaveShape = a.getString(attr2);
                            c.mWaveShape = 7;
                            continue block23;
                        }
                        c.mWaveShape = a.getInt(attr2, c.mWaveShape);
                        continue block23;
                    }
                    case 6: {
                        c.mWavePeriod = a.getFloat(attr2, c.mWavePeriod);
                        continue block23;
                    }
                    case 7: {
                        TypedValue type = a.peekValue(attr2);
                        if (type.type == 5) {
                            c.mWaveOffset = a.getDimension(attr2, c.mWaveOffset);
                            continue block23;
                        }
                        c.mWaveOffset = a.getFloat(attr2, c.mWaveOffset);
                        continue block23;
                    }
                    case 8: {
                        c.mWaveVariesBy = a.getInt(attr2, c.mWaveVariesBy);
                        continue block23;
                    }
                    case 9: {
                        c.mAlpha = a.getFloat(attr2, c.mAlpha);
                        continue block23;
                    }
                    case 10: {
                        c.mElevation = a.getDimension(attr2, c.mElevation);
                        continue block23;
                    }
                    case 11: {
                        c.mRotation = a.getFloat(attr2, c.mRotation);
                        continue block23;
                    }
                    case 12: {
                        c.mRotationX = a.getFloat(attr2, c.mRotationX);
                        continue block23;
                    }
                    case 13: {
                        c.mRotationY = a.getFloat(attr2, c.mRotationY);
                        continue block23;
                    }
                    case 14: {
                        c.mTransitionPathRotate = a.getFloat(attr2, c.mTransitionPathRotate);
                        continue block23;
                    }
                    case 15: {
                        c.mScaleX = a.getFloat(attr2, c.mScaleX);
                        continue block23;
                    }
                    case 16: {
                        c.mScaleY = a.getFloat(attr2, c.mScaleY);
                        continue block23;
                    }
                    case 17: {
                        c.mTranslationX = a.getDimension(attr2, c.mTranslationX);
                        continue block23;
                    }
                    case 18: {
                        c.mTranslationY = a.getDimension(attr2, c.mTranslationY);
                        continue block23;
                    }
                    case 19: {
                        if (Build.VERSION.SDK_INT < 21) continue block23;
                        c.mTranslationZ = a.getDimension(attr2, c.mTranslationZ);
                        continue block23;
                    }
                    case 20: {
                        c.mProgress = a.getFloat(attr2, c.mProgress);
                        continue block23;
                    }
                    case 21: {
                        c.mWavePhase = a.getFloat(attr2, c.mWavePhase) / 360.0f;
                        continue block23;
                    }
                    default: {
                        Log.e((String)"KeyCycle", (String)("unused attribute 0x" + Integer.toHexString(attr2) + "   " + mAttrMap.get(attr2)));
                    }
                }
            }
        }

        static {
            mAttrMap.append(R.styleable.KeyCycle_motionTarget, 1);
            mAttrMap.append(R.styleable.KeyCycle_framePosition, 2);
            mAttrMap.append(R.styleable.KeyCycle_transitionEasing, 3);
            mAttrMap.append(R.styleable.KeyCycle_curveFit, 4);
            mAttrMap.append(R.styleable.KeyCycle_waveShape, 5);
            mAttrMap.append(R.styleable.KeyCycle_wavePeriod, 6);
            mAttrMap.append(R.styleable.KeyCycle_waveOffset, 7);
            mAttrMap.append(R.styleable.KeyCycle_waveVariesBy, 8);
            mAttrMap.append(R.styleable.KeyCycle_android_alpha, 9);
            mAttrMap.append(R.styleable.KeyCycle_android_elevation, 10);
            mAttrMap.append(R.styleable.KeyCycle_android_rotation, 11);
            mAttrMap.append(R.styleable.KeyCycle_android_rotationX, 12);
            mAttrMap.append(R.styleable.KeyCycle_android_rotationY, 13);
            mAttrMap.append(R.styleable.KeyCycle_transitionPathRotate, 14);
            mAttrMap.append(R.styleable.KeyCycle_android_scaleX, 15);
            mAttrMap.append(R.styleable.KeyCycle_android_scaleY, 16);
            mAttrMap.append(R.styleable.KeyCycle_android_translationX, 17);
            mAttrMap.append(R.styleable.KeyCycle_android_translationY, 18);
            mAttrMap.append(R.styleable.KeyCycle_android_translationZ, 19);
            mAttrMap.append(R.styleable.KeyCycle_motionProgress, 20);
            mAttrMap.append(R.styleable.KeyCycle_wavePhase, 21);
        }
    }
}

