/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.R;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class KeyTrigger
extends Key {
    static final String NAME = "KeyTrigger";
    private static final String TAG = "KeyTrigger";
    public static final String VIEW_TRANSITION_ON_CROSS = "viewTransitionOnCross";
    public static final String VIEW_TRANSITION_ON_POSITIVE_CROSS = "viewTransitionOnPositiveCross";
    public static final String VIEW_TRANSITION_ON_NEGATIVE_CROSS = "viewTransitionOnNegativeCross";
    public static final String POST_LAYOUT = "postLayout";
    public static final String TRIGGER_SLACK = "triggerSlack";
    public static final String TRIGGER_COLLISION_VIEW = "triggerCollisionView";
    public static final String TRIGGER_COLLISION_ID = "triggerCollisionId";
    public static final String TRIGGER_ID = "triggerID";
    public static final String POSITIVE_CROSS = "positiveCross";
    public static final String NEGATIVE_CROSS = "negativeCross";
    public static final String TRIGGER_RECEIVER = "triggerReceiver";
    public static final String CROSS = "CROSS";
    private int mCurveFit = -1;
    private String mCross = null;
    private int mTriggerReceiver = UNSET;
    private String mNegativeCross = null;
    private String mPositiveCross = null;
    private int mTriggerID = UNSET;
    private int mTriggerCollisionId = UNSET;
    private View mTriggerCollisionView = null;
    float mTriggerSlack = 0.1f;
    private boolean mFireCrossReset = true;
    private boolean mFireNegativeReset = true;
    private boolean mFirePositiveReset = true;
    private float mFireThreshold = Float.NaN;
    private float mFireLastPos;
    private boolean mPostLayout = false;
    int mViewTransitionOnNegativeCross = UNSET;
    int mViewTransitionOnPositiveCross = UNSET;
    int mViewTransitionOnCross = UNSET;
    RectF mCollisionRect = new RectF();
    RectF mTargetRect = new RectF();
    HashMap<String, Method> mMethodHashMap = new HashMap();
    public static final int KEY_TYPE = 5;

    public KeyTrigger() {
        this.mType = 5;
        this.mCustomConstraints = new HashMap();
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyTrigger);
        Loader.read(this, a, context);
    }

    int getCurveFit() {
        return this.mCurveFit;
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> splines) {
    }

    @Override
    public void setValue(String tag, Object value) {
        switch (tag) {
            case "CROSS": {
                this.mCross = value.toString();
                break;
            }
            case "triggerReceiver": {
                this.mTriggerReceiver = this.toInt(value);
                break;
            }
            case "negativeCross": {
                this.mNegativeCross = value.toString();
                break;
            }
            case "positiveCross": {
                this.mPositiveCross = value.toString();
                break;
            }
            case "triggerID": {
                this.mTriggerID = this.toInt(value);
                break;
            }
            case "triggerCollisionId": {
                this.mTriggerCollisionId = this.toInt(value);
                break;
            }
            case "triggerCollisionView": {
                this.mTriggerCollisionView = (View)value;
                break;
            }
            case "triggerSlack": {
                this.mTriggerSlack = this.toFloat(value);
                break;
            }
            case "postLayout": {
                this.mPostLayout = this.toBoolean(value);
                break;
            }
            case "viewTransitionOnNegativeCross": {
                this.mViewTransitionOnNegativeCross = this.toInt(value);
                break;
            }
            case "viewTransitionOnPositiveCross": {
                this.mViewTransitionOnPositiveCross = this.toInt(value);
                break;
            }
            case "viewTransitionOnCross": {
                this.mViewTransitionOnCross = this.toInt(value);
            }
        }
    }

    private void setUpRect(RectF rect, View child, boolean postLayout) {
        rect.top = child.getTop();
        rect.bottom = child.getBottom();
        rect.left = child.getLeft();
        rect.right = child.getRight();
        if (postLayout) {
            child.getMatrix().mapRect(rect);
        }
    }

    public void conditionallyFire(float pos, View child) {
        View call;
        boolean fireCross = false;
        boolean fireNegative = false;
        boolean firePositive = false;
        if (this.mTriggerCollisionId != UNSET) {
            if (this.mTriggerCollisionView == null) {
                this.mTriggerCollisionView = ((ViewGroup)child.getParent()).findViewById(this.mTriggerCollisionId);
            }
            this.setUpRect(this.mCollisionRect, this.mTriggerCollisionView, this.mPostLayout);
            this.setUpRect(this.mTargetRect, child, this.mPostLayout);
            boolean in = this.mCollisionRect.intersect(this.mTargetRect);
            if (in) {
                if (this.mFireCrossReset) {
                    fireCross = true;
                    this.mFireCrossReset = false;
                }
                if (this.mFirePositiveReset) {
                    firePositive = true;
                    this.mFirePositiveReset = false;
                }
                this.mFireNegativeReset = true;
            } else {
                if (!this.mFireCrossReset) {
                    fireCross = true;
                    this.mFireCrossReset = true;
                }
                if (this.mFireNegativeReset) {
                    fireNegative = true;
                    this.mFireNegativeReset = false;
                }
                this.mFirePositiveReset = true;
            }
        } else {
            float lastOffset;
            float offset;
            if (this.mFireCrossReset) {
                offset = pos - this.mFireThreshold;
                lastOffset = this.mFireLastPos - this.mFireThreshold;
                if (offset * lastOffset < 0.0f) {
                    fireCross = true;
                    this.mFireCrossReset = false;
                }
            } else if (Math.abs(pos - this.mFireThreshold) > this.mTriggerSlack) {
                this.mFireCrossReset = true;
            }
            if (this.mFireNegativeReset) {
                offset = pos - this.mFireThreshold;
                lastOffset = this.mFireLastPos - this.mFireThreshold;
                if (offset * lastOffset < 0.0f && offset < 0.0f) {
                    fireNegative = true;
                    this.mFireNegativeReset = false;
                }
            } else if (Math.abs(pos - this.mFireThreshold) > this.mTriggerSlack) {
                this.mFireNegativeReset = true;
            }
            if (this.mFirePositiveReset) {
                offset = pos - this.mFireThreshold;
                lastOffset = this.mFireLastPos - this.mFireThreshold;
                if (offset * lastOffset < 0.0f && offset > 0.0f) {
                    firePositive = true;
                    this.mFirePositiveReset = false;
                }
            } else if (Math.abs(pos - this.mFireThreshold) > this.mTriggerSlack) {
                this.mFirePositiveReset = true;
            }
        }
        this.mFireLastPos = pos;
        if (fireNegative || fireCross || firePositive) {
            ((MotionLayout)child.getParent()).fireTrigger(this.mTriggerID, firePositive, pos);
        }
        View view = call = this.mTriggerReceiver == UNSET ? child : ((MotionLayout)child.getParent()).findViewById(this.mTriggerReceiver);
        if (fireNegative) {
            if (this.mNegativeCross != null) {
                this.fire(this.mNegativeCross, call);
            }
            if (this.mViewTransitionOnNegativeCross != UNSET) {
                ((MotionLayout)child.getParent()).viewTransition(this.mViewTransitionOnNegativeCross, call);
            }
        }
        if (firePositive) {
            if (this.mPositiveCross != null) {
                this.fire(this.mPositiveCross, call);
            }
            if (this.mViewTransitionOnPositiveCross != UNSET) {
                ((MotionLayout)child.getParent()).viewTransition(this.mViewTransitionOnPositiveCross, call);
            }
        }
        if (fireCross) {
            if (this.mCross != null) {
                this.fire(this.mCross, call);
            }
            if (this.mViewTransitionOnCross != UNSET) {
                ((MotionLayout)child.getParent()).viewTransition(this.mViewTransitionOnCross, call);
            }
        }
    }

    private void fire(String str, View call) {
        if (str == null) {
            return;
        }
        if (str.startsWith(".")) {
            this.fireCustom(str, call);
            return;
        }
        Method method = null;
        if (this.mMethodHashMap.containsKey(str) && (method = this.mMethodHashMap.get(str)) == null) {
            return;
        }
        if (method == null) {
            try {
                method = call.getClass().getMethod(str, new Class[0]);
                this.mMethodHashMap.put(str, method);
            }
            catch (NoSuchMethodException e) {
                this.mMethodHashMap.put(str, null);
                Log.e((String)"KeyTrigger", (String)("Could not find method \"" + str + "\"on class " + call.getClass().getSimpleName() + " " + Debug.getName(call)));
                return;
            }
        }
        try {
            method.invoke((Object)call, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)"KeyTrigger", (String)("Exception in call \"" + this.mCross + "\"on class " + call.getClass().getSimpleName() + " " + Debug.getName(call)));
        }
    }

    private void fireCustom(String str, View view) {
        boolean callAll;
        boolean bl = callAll = str.length() == 1;
        if (!callAll) {
            str = str.substring(1).toLowerCase(Locale.ROOT);
        }
        for (String name : this.mCustomConstraints.keySet()) {
            ConstraintAttribute custom;
            String lowerCase = name.toLowerCase(Locale.ROOT);
            if (!callAll && !lowerCase.matches(str) || (custom = (ConstraintAttribute)this.mCustomConstraints.get(name)) == null) continue;
            custom.applyCustom(view);
        }
    }

    @Override
    public Key copy(Key src) {
        super.copy(src);
        KeyTrigger k = (KeyTrigger)src;
        this.mCurveFit = k.mCurveFit;
        this.mCross = k.mCross;
        this.mTriggerReceiver = k.mTriggerReceiver;
        this.mNegativeCross = k.mNegativeCross;
        this.mPositiveCross = k.mPositiveCross;
        this.mTriggerID = k.mTriggerID;
        this.mTriggerCollisionId = k.mTriggerCollisionId;
        this.mTriggerCollisionView = k.mTriggerCollisionView;
        this.mTriggerSlack = k.mTriggerSlack;
        this.mFireCrossReset = k.mFireCrossReset;
        this.mFireNegativeReset = k.mFireNegativeReset;
        this.mFirePositiveReset = k.mFirePositiveReset;
        this.mFireThreshold = k.mFireThreshold;
        this.mFireLastPos = k.mFireLastPos;
        this.mPostLayout = k.mPostLayout;
        this.mCollisionRect = k.mCollisionRect;
        this.mTargetRect = k.mTargetRect;
        this.mMethodHashMap = k.mMethodHashMap;
        return this;
    }

    @Override
    public Key clone() {
        return new KeyTrigger().copy(this);
    }

    private static class Loader {
        private static final int NEGATIVE_CROSS = 1;
        private static final int POSITIVE_CROSS = 2;
        private static final int CROSS = 4;
        private static final int TRIGGER_SLACK = 5;
        private static final int TRIGGER_ID = 6;
        private static final int TARGET_ID = 7;
        private static final int FRAME_POS = 8;
        private static final int COLLISION = 9;
        private static final int POST_LAYOUT = 10;
        private static final int TRIGGER_RECEIVER = 11;
        private static final int VT_CROSS = 12;
        private static final int VT_NEGATIVE_CROSS = 13;
        private static final int VT_POSITIVE_CROSS = 14;
        private static SparseIntArray mAttrMap = new SparseIntArray();

        private Loader() {
        }

        public static void read(KeyTrigger c, TypedArray a, Context context) {
            int N = a.getIndexCount();
            block15: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (mAttrMap.get(attr2)) {
                    case 8: {
                        c.mFramePosition = a.getInteger(attr2, c.mFramePosition);
                        c.mFireThreshold = ((float)c.mFramePosition + 0.5f) / 100.0f;
                        continue block15;
                    }
                    case 7: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            c.mTargetId = a.getResourceId(attr2, c.mTargetId);
                            if (c.mTargetId != -1) continue block15;
                            c.mTargetString = a.getString(attr2);
                            continue block15;
                        }
                        if (a.peekValue((int)attr2).type == 3) {
                            c.mTargetString = a.getString(attr2);
                            continue block15;
                        }
                        c.mTargetId = a.getResourceId(attr2, c.mTargetId);
                        continue block15;
                    }
                    case 1: {
                        c.mNegativeCross = a.getString(attr2);
                        continue block15;
                    }
                    case 2: {
                        c.mPositiveCross = a.getString(attr2);
                        continue block15;
                    }
                    case 4: {
                        c.mCross = a.getString(attr2);
                        continue block15;
                    }
                    case 5: {
                        c.mTriggerSlack = a.getFloat(attr2, c.mTriggerSlack);
                        continue block15;
                    }
                    case 6: {
                        c.mTriggerID = a.getResourceId(attr2, c.mTriggerID);
                        continue block15;
                    }
                    case 9: {
                        c.mTriggerCollisionId = a.getResourceId(attr2, c.mTriggerCollisionId);
                        continue block15;
                    }
                    case 10: {
                        c.mPostLayout = a.getBoolean(attr2, c.mPostLayout);
                        continue block15;
                    }
                    case 11: {
                        c.mTriggerReceiver = a.getResourceId(attr2, c.mTriggerReceiver);
                        continue block15;
                    }
                    case 13: {
                        c.mViewTransitionOnNegativeCross = a.getResourceId(attr2, c.mViewTransitionOnNegativeCross);
                        continue block15;
                    }
                    case 14: {
                        c.mViewTransitionOnPositiveCross = a.getResourceId(attr2, c.mViewTransitionOnPositiveCross);
                        continue block15;
                    }
                    case 12: {
                        c.mViewTransitionOnCross = a.getResourceId(attr2, c.mViewTransitionOnCross);
                        continue block15;
                    }
                    default: {
                        Log.e((String)"KeyTrigger", (String)("unused attribute 0x" + Integer.toHexString(attr2) + "   " + mAttrMap.get(attr2)));
                    }
                }
            }
        }

        static {
            mAttrMap.append(R.styleable.KeyTrigger_framePosition, 8);
            mAttrMap.append(R.styleable.KeyTrigger_onCross, 4);
            mAttrMap.append(R.styleable.KeyTrigger_onNegativeCross, 1);
            mAttrMap.append(R.styleable.KeyTrigger_onPositiveCross, 2);
            mAttrMap.append(R.styleable.KeyTrigger_motionTarget, 7);
            mAttrMap.append(R.styleable.KeyTrigger_triggerId, 6);
            mAttrMap.append(R.styleable.KeyTrigger_triggerSlack, 5);
            mAttrMap.append(R.styleable.KeyTrigger_motion_triggerOnCollision, 9);
            mAttrMap.append(R.styleable.KeyTrigger_motion_postLayoutCollision, 10);
            mAttrMap.append(R.styleable.KeyTrigger_triggerReceiver, 11);
            mAttrMap.append(R.styleable.KeyTrigger_viewTransitionOnCross, 12);
            mAttrMap.append(R.styleable.KeyTrigger_viewTransitionOnNegativeCross, 13);
            mAttrMap.append(R.styleable.KeyTrigger_viewTransitionOnPositiveCross, 14);
        }
    }
}

