/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

class MotionConstrainedPoint
implements Comparable<MotionConstrainedPoint> {
    public static final String TAG = "MotionPaths";
    public static final boolean DEBUG = false;
    private float alpha = 1.0f;
    int mVisibilityMode = 0;
    int visibility;
    private boolean applyElevation = false;
    private float elevation = 0.0f;
    private float rotation = 0.0f;
    private float rotationX = 0.0f;
    public float rotationY = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float mPivotX = Float.NaN;
    private float mPivotY = Float.NaN;
    private float translationX = 0.0f;
    private float translationY = 0.0f;
    private float translationZ = 0.0f;
    private Easing mKeyFrameEasing;
    private int mDrawPath = 0;
    private float position;
    private float x;
    private float y;
    private float width;
    private float height;
    private float mPathRotate = Float.NaN;
    private float mProgress = Float.NaN;
    private int mAnimateRelativeTo = -1;
    static final int PERPENDICULAR = 1;
    static final int CARTESIAN = 2;
    static String[] names = new String[]{"position", "x", "y", "width", "height", "pathRotate"};
    LinkedHashMap<String, ConstraintAttribute> attributes = new LinkedHashMap();
    int mMode = 0;
    double[] mTempValue = new double[18];
    double[] mTempDelta = new double[18];

    private boolean diff(float a, float b) {
        if (Float.isNaN(a) || Float.isNaN(b)) {
            return Float.isNaN(a) != Float.isNaN(b);
        }
        return Math.abs(a - b) > 1.0E-6f;
    }

    void different(MotionConstrainedPoint points, HashSet<String> keySet) {
        if (this.diff(this.alpha, points.alpha)) {
            keySet.add("alpha");
        }
        if (this.diff(this.elevation, points.elevation)) {
            keySet.add("elevation");
        }
        if (this.visibility != points.visibility && this.mVisibilityMode == 0 && (this.visibility == 0 || points.visibility == 0)) {
            keySet.add("alpha");
        }
        if (this.diff(this.rotation, points.rotation)) {
            keySet.add("rotation");
        }
        if (!Float.isNaN(this.mPathRotate) || !Float.isNaN(points.mPathRotate)) {
            keySet.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mProgress) || !Float.isNaN(points.mProgress)) {
            keySet.add("progress");
        }
        if (this.diff(this.rotationX, points.rotationX)) {
            keySet.add("rotationX");
        }
        if (this.diff(this.rotationY, points.rotationY)) {
            keySet.add("rotationY");
        }
        if (this.diff(this.mPivotX, points.mPivotX)) {
            keySet.add("transformPivotX");
        }
        if (this.diff(this.mPivotY, points.mPivotY)) {
            keySet.add("transformPivotY");
        }
        if (this.diff(this.scaleX, points.scaleX)) {
            keySet.add("scaleX");
        }
        if (this.diff(this.scaleY, points.scaleY)) {
            keySet.add("scaleY");
        }
        if (this.diff(this.translationX, points.translationX)) {
            keySet.add("translationX");
        }
        if (this.diff(this.translationY, points.translationY)) {
            keySet.add("translationY");
        }
        if (this.diff(this.translationZ, points.translationZ)) {
            keySet.add("translationZ");
        }
    }

    void different(MotionConstrainedPoint points, boolean[] mask, String[] custom) {
        int c = 0;
        int n = c++;
        mask[n] = mask[n] | this.diff(this.position, points.position);
        int n2 = c++;
        mask[n2] = mask[n2] | this.diff(this.x, points.x);
        int n3 = c++;
        mask[n3] = mask[n3] | this.diff(this.y, points.y);
        int n4 = c++;
        mask[n4] = mask[n4] | this.diff(this.width, points.width);
        int n5 = c++;
        mask[n5] = mask[n5] | this.diff(this.height, points.height);
    }

    void fillStandard(double[] data, int[] toUse) {
        float[] set = new float[]{this.position, this.x, this.y, this.width, this.height, this.alpha, this.elevation, this.rotation, this.rotationX, this.rotationY, this.scaleX, this.scaleY, this.mPivotX, this.mPivotY, this.translationX, this.translationY, this.translationZ, this.mPathRotate};
        int c = 0;
        for (int i = 0; i < toUse.length; ++i) {
            if (toUse[i] >= set.length) continue;
            data[c++] = set[toUse[i]];
        }
    }

    boolean hasCustomData(String name) {
        return this.attributes.containsKey(name);
    }

    int getCustomDataCount(String name) {
        return this.attributes.get(name).numberOfInterpolatedValues();
    }

    int getCustomData(String name, double[] value, int offset) {
        ConstraintAttribute a = this.attributes.get(name);
        if (a.numberOfInterpolatedValues() == 1) {
            value[offset] = a.getValueToInterpolate();
            return 1;
        }
        int N = a.numberOfInterpolatedValues();
        float[] f = new float[N];
        a.getValuesToInterpolate(f);
        for (int i = 0; i < N; ++i) {
            value[offset++] = f[i];
        }
        return N;
    }

    void setBounds(float x, float y, float w, float h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public int compareTo(MotionConstrainedPoint o) {
        return Float.compare(this.position, o.position);
    }

    public void applyParameters(View view) {
        this.visibility = view.getVisibility();
        this.alpha = view.getVisibility() != 0 ? 0.0f : view.getAlpha();
        this.applyElevation = false;
        if (Build.VERSION.SDK_INT >= 21) {
            this.elevation = view.getElevation();
        }
        this.rotation = view.getRotation();
        this.rotationX = view.getRotationX();
        this.rotationY = view.getRotationY();
        this.scaleX = view.getScaleX();
        this.scaleY = view.getScaleY();
        this.mPivotX = view.getPivotX();
        this.mPivotY = view.getPivotY();
        this.translationX = view.getTranslationX();
        this.translationY = view.getTranslationY();
        if (Build.VERSION.SDK_INT >= 21) {
            this.translationZ = view.getTranslationZ();
        }
    }

    public void applyParameters(ConstraintSet.Constraint c) {
        this.mVisibilityMode = c.propertySet.mVisibilityMode;
        this.visibility = c.propertySet.visibility;
        this.alpha = c.propertySet.visibility != 0 && this.mVisibilityMode == 0 ? 0.0f : c.propertySet.alpha;
        this.applyElevation = c.transform.applyElevation;
        this.elevation = c.transform.elevation;
        this.rotation = c.transform.rotation;
        this.rotationX = c.transform.rotationX;
        this.rotationY = c.transform.rotationY;
        this.scaleX = c.transform.scaleX;
        this.scaleY = c.transform.scaleY;
        this.mPivotX = c.transform.transformPivotX;
        this.mPivotY = c.transform.transformPivotY;
        this.translationX = c.transform.translationX;
        this.translationY = c.transform.translationY;
        this.translationZ = c.transform.translationZ;
        this.mKeyFrameEasing = Easing.getInterpolator(c.motion.mTransitionEasing);
        this.mPathRotate = c.motion.mPathRotate;
        this.mDrawPath = c.motion.mDrawPath;
        this.mAnimateRelativeTo = c.motion.mAnimateRelativeTo;
        this.mProgress = c.propertySet.mProgress;
        Set<String> at = c.mCustomConstraints.keySet();
        for (String s : at) {
            ConstraintAttribute attr2 = c.mCustomConstraints.get(s);
            if (!attr2.isContinuous()) continue;
            this.attributes.put(s, attr2);
        }
    }

    public void addValues(HashMap<String, ViewSpline> splines, int mFramePosition) {
        block32: for (String s : splines.keySet()) {
            ViewSpline ViewSpline2 = splines.get(s);
            switch (s) {
                case "alpha": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.alpha) ? 1.0f : this.alpha);
                    continue block32;
                }
                case "elevation": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.elevation) ? 0.0f : this.elevation);
                    continue block32;
                }
                case "rotation": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.rotation) ? 0.0f : this.rotation);
                    continue block32;
                }
                case "rotationX": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.rotationX) ? 0.0f : this.rotationX);
                    continue block32;
                }
                case "rotationY": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.rotationY) ? 0.0f : this.rotationY);
                    continue block32;
                }
                case "transformPivotX": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.mPivotX) ? 0.0f : this.mPivotX);
                    continue block32;
                }
                case "transformPivotY": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.mPivotY) ? 0.0f : this.mPivotY);
                    continue block32;
                }
                case "transitionPathRotate": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.mPathRotate) ? 0.0f : this.mPathRotate);
                    continue block32;
                }
                case "progress": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.mProgress) ? 0.0f : this.mProgress);
                    continue block32;
                }
                case "scaleX": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.scaleX) ? 1.0f : this.scaleX);
                    continue block32;
                }
                case "scaleY": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.scaleY) ? 1.0f : this.scaleY);
                    continue block32;
                }
                case "translationX": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.translationX) ? 0.0f : this.translationX);
                    continue block32;
                }
                case "translationY": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.translationY) ? 0.0f : this.translationY);
                    continue block32;
                }
                case "translationZ": {
                    ViewSpline2.setPoint(mFramePosition, Float.isNaN(this.translationZ) ? 0.0f : this.translationZ);
                    continue block32;
                }
            }
            if (s.startsWith("CUSTOM")) {
                String customName = s.split(",")[1];
                if (!this.attributes.containsKey(customName)) continue;
                ConstraintAttribute custom = this.attributes.get(customName);
                if (ViewSpline2 instanceof ViewSpline.CustomSet) {
                    ((ViewSpline.CustomSet)ViewSpline2).setPoint(mFramePosition, custom);
                    continue;
                }
                Log.e((String)TAG, (String)(s + " ViewSpline not a CustomSet frame = " + mFramePosition + ", value" + custom.getValueToInterpolate() + ViewSpline2));
                continue;
            }
            Log.e((String)TAG, (String)("UNKNOWN spline " + s));
        }
    }

    public void setState(View view) {
        this.setBounds(view.getX(), view.getY(), view.getWidth(), view.getHeight());
        this.applyParameters(view);
    }

    public void setState(Rect rect, View view, int rotation, float prevous) {
        this.setBounds(rect.left, rect.top, rect.width(), rect.height());
        this.applyParameters(view);
        this.mPivotX = Float.NaN;
        this.mPivotY = Float.NaN;
        switch (rotation) {
            case 2: {
                this.rotation = prevous + 90.0f;
                break;
            }
            case 1: {
                this.rotation = prevous - 90.0f;
            }
        }
    }

    public void setState(Rect cw, ConstraintSet constraintSet, int rotation, int viewId) {
        this.setBounds(cw.left, cw.top, cw.width(), cw.height());
        this.applyParameters(constraintSet.getParameters(viewId));
        switch (rotation) {
            case 1: 
            case 3: {
                this.rotation -= 90.0f;
                break;
            }
            case 2: 
            case 4: {
                this.rotation += 90.0f;
                if (!(this.rotation > 180.0f)) break;
                this.rotation -= 360.0f;
            }
        }
    }
}

