/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.VelocityMatrix;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.utils.ViewOscillator;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.utils.ViewState;
import androidx.constraintlayout.motion.utils.ViewTimeCycle;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyAttributes;
import androidx.constraintlayout.motion.widget.KeyCycle;
import androidx.constraintlayout.motion.widget.KeyPosition;
import androidx.constraintlayout.motion.widget.KeyPositionBase;
import androidx.constraintlayout.motion.widget.KeyTimeCycle;
import androidx.constraintlayout.motion.widget.KeyTrigger;
import androidx.constraintlayout.motion.widget.MotionConstrainedPoint;
import androidx.constraintlayout.motion.widget.MotionPaths;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class MotionController {
    public static final int PATH_PERCENT = 0;
    public static final int PATH_PERPENDICULAR = 1;
    public static final int HORIZONTAL_PATH_X = 2;
    public static final int HORIZONTAL_PATH_Y = 3;
    public static final int VERTICAL_PATH_X = 4;
    public static final int VERTICAL_PATH_Y = 5;
    public static final int DRAW_PATH_NONE = 0;
    public static final int DRAW_PATH_BASIC = 1;
    public static final int DRAW_PATH_RELATIVE = 2;
    public static final int DRAW_PATH_CARTESIAN = 3;
    public static final int DRAW_PATH_AS_CONFIGURED = 4;
    public static final int DRAW_PATH_RECTANGLE = 5;
    public static final int DRAW_PATH_SCREEN = 6;
    public static final int ROTATION_RIGHT = 1;
    public static final int ROTATION_LEFT = 2;
    Rect mTempRect = new Rect();
    private static final String TAG = "MotionController";
    private static final boolean DEBUG = false;
    private static final boolean FAVOR_FIXED_SIZE_VIEWS = false;
    View mView;
    int mId;
    boolean mForceMeasure = false;
    String mConstraintTag;
    private int mCurveFitType = -1;
    private MotionPaths mStartMotionPath = new MotionPaths();
    private MotionPaths mEndMotionPath = new MotionPaths();
    private MotionConstrainedPoint mStartPoint = new MotionConstrainedPoint();
    private MotionConstrainedPoint mEndPoint = new MotionConstrainedPoint();
    private CurveFit[] mSpline;
    private CurveFit mArcSpline;
    float mMotionStagger = Float.NaN;
    float mStaggerOffset = 0.0f;
    float mStaggerScale = 1.0f;
    float mCurrentCenterX;
    float mCurrentCenterY;
    private int[] mInterpolateVariables;
    private double[] mInterpolateData;
    private double[] mInterpolateVelocity;
    private String[] mAttributeNames;
    private int[] mAttributeInterpolatorCount;
    private int MAX_DIMENSION = 4;
    private float[] mValuesBuff = new float[this.MAX_DIMENSION];
    private ArrayList<MotionPaths> mMotionPaths = new ArrayList();
    private float[] mVelocity = new float[1];
    private ArrayList<Key> mKeyList = new ArrayList();
    private HashMap<String, ViewTimeCycle> mTimeCycleAttributesMap;
    private HashMap<String, ViewSpline> mAttributesMap;
    private HashMap<String, ViewOscillator> mCycleMap;
    private KeyTrigger[] mKeyTriggers;
    private int mPathMotionArc = Key.UNSET;
    private int mTransformPivotTarget = Key.UNSET;
    private View mTransformPivotView = null;
    private int mQuantizeMotionSteps = Key.UNSET;
    private float mQuantizeMotionPhase = Float.NaN;
    private Interpolator mQuantizeMotionInterpolator = null;
    private boolean mNoMovement = false;
    String[] attributeTable;
    static final int EASE_IN_OUT = 0;
    static final int EASE_IN = 1;
    static final int EASE_OUT = 2;
    static final int LINEAR = 3;
    static final int BOUNCE = 4;
    static final int OVERSHOOT = 5;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    private static final int INTERPOLATOR_UNDEFINED = -3;

    public int getTransformPivotTarget() {
        return this.mTransformPivotTarget;
    }

    public void setTransformPivotTarget(int transformPivotTarget) {
        this.mTransformPivotTarget = transformPivotTarget;
        this.mTransformPivotView = null;
    }

    MotionPaths getKeyFrame(int i) {
        return this.mMotionPaths.get(i);
    }

    MotionController(View view) {
        this.setView(view);
    }

    public float getStartX() {
        return this.mStartMotionPath.x;
    }

    public float getStartY() {
        return this.mStartMotionPath.y;
    }

    public float getFinalX() {
        return this.mEndMotionPath.x;
    }

    public float getFinalY() {
        return this.mEndMotionPath.y;
    }

    public float getStartWidth() {
        return this.mStartMotionPath.width;
    }

    public float getStartHeight() {
        return this.mStartMotionPath.height;
    }

    public float getFinalWidth() {
        return this.mEndMotionPath.width;
    }

    public float getFinalHeight() {
        return this.mEndMotionPath.height;
    }

    public int getAnimateRelativeTo() {
        return this.mStartMotionPath.mAnimateRelativeTo;
    }

    public void setupRelative(MotionController motionController) {
        this.mStartMotionPath.setupRelative(motionController, motionController.mStartMotionPath);
        this.mEndMotionPath.setupRelative(motionController, motionController.mEndMotionPath);
    }

    public float getCenterX() {
        return this.mCurrentCenterX;
    }

    public float getCenterY() {
        return this.mCurrentCenterY;
    }

    public void getCenter(double p, float[] pos, float[] vel) {
        double[] position = new double[4];
        double[] velocity = new double[4];
        int[] temp = new int[4];
        this.mSpline[0].getPos(p, position);
        this.mSpline[0].getSlope(p, velocity);
        Arrays.fill(vel, 0.0f);
        this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, position, pos, velocity, vel);
    }

    public void remeasure() {
        this.mForceMeasure = true;
    }

    void buildPath(float[] points, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        SplineSet trans_x = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("translationX");
        SplineSet trans_y = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("translationY");
        ViewOscillator osc_x = this.mCycleMap == null ? null : this.mCycleMap.get("translationX");
        ViewOscillator osc_y = this.mCycleMap == null ? null : this.mCycleMap.get("translationY");
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            if (this.mStaggerScale != 1.0f) {
                if (position < this.mStaggerOffset) {
                    position = 0.0f;
                }
                if (position > this.mStaggerOffset && (double)position < 1.0) {
                    position -= this.mStaggerOffset;
                    position *= this.mStaggerScale;
                    position = Math.min(position, 1.0f);
                }
            }
            double p = position;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.mKeyFrameEasing == null) continue;
                if (frame.time < position) {
                    easing = frame.mKeyFrameEasing;
                    start = frame.time;
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.time;
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            this.mSpline[0].getPos(p, this.mInterpolateData);
            if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos(p, this.mInterpolateData);
            }
            this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, this.mInterpolateData, points, i * 2);
            if (osc_x != null) {
                int n = i * 2;
                points[n] = points[n] + osc_x.get(position);
            } else if (trans_x != null) {
                int n = i * 2;
                points[n] = points[n] + trans_x.get(position);
            }
            if (osc_y != null) {
                int n = i * 2 + 1;
                points[n] = points[n] + osc_y.get(position);
                continue;
            }
            if (trans_y == null) continue;
            int n = i * 2 + 1;
            points[n] = points[n] + trans_y.get(position);
        }
    }

    double[] getPos(double position) {
        this.mSpline[0].getPos(position, this.mInterpolateData);
        if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
            this.mArcSpline.getPos(position, this.mInterpolateData);
        }
        return this.mInterpolateData;
    }

    void buildBounds(float[] bounds, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        SplineSet trans_x = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("translationX");
        SplineSet trans_y = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("translationY");
        ViewOscillator osc_x = this.mCycleMap == null ? null : this.mCycleMap.get("translationX");
        ViewOscillator osc_y = this.mCycleMap == null ? null : this.mCycleMap.get("translationY");
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            if (this.mStaggerScale != 1.0f) {
                if (position < this.mStaggerOffset) {
                    position = 0.0f;
                }
                if (position > this.mStaggerOffset && (double)position < 1.0) {
                    position -= this.mStaggerOffset;
                    position *= this.mStaggerScale;
                    position = Math.min(position, 1.0f);
                }
            }
            double p = position;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.mKeyFrameEasing == null) continue;
                if (frame.time < position) {
                    easing = frame.mKeyFrameEasing;
                    start = frame.time;
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.time;
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            this.mSpline[0].getPos(p, this.mInterpolateData);
            if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos(p, this.mInterpolateData);
            }
            this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, bounds, i * 2);
        }
    }

    private float getPreCycleDistance() {
        int pointCount = 100;
        float[] points = new float[2];
        float sum = 0.0f;
        float mils = 1.0f / (float)(pointCount - 1);
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            double p = position;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            float start = 0.0f;
            float end = Float.NaN;
            for (MotionPaths frame : this.mMotionPaths) {
                if (frame.mKeyFrameEasing == null) continue;
                if (frame.time < position) {
                    easing = frame.mKeyFrameEasing;
                    start = frame.time;
                    continue;
                }
                if (!Float.isNaN(end)) continue;
                end = frame.time;
            }
            if (easing != null) {
                if (Float.isNaN(end)) {
                    end = 1.0f;
                }
                float offset = (position - start) / (end - start);
                offset = (float)easing.get(offset);
                p = offset * (end - start) + start;
            }
            this.mSpline[0].getPos(p, this.mInterpolateData);
            this.mStartMotionPath.getCenter(p, this.mInterpolateVariables, this.mInterpolateData, points, 0);
            if (i > 0) {
                sum = (float)((double)sum + Math.hypot(y - (double)points[1], x - (double)points[0]));
            }
            x = points[0];
            y = points[1];
        }
        return sum;
    }

    KeyPositionBase getPositionKeyframe(int layoutWidth, int layoutHeight, float x, float y) {
        RectF start = new RectF();
        start.left = this.mStartMotionPath.x;
        start.top = this.mStartMotionPath.y;
        start.right = start.left + this.mStartMotionPath.width;
        start.bottom = start.top + this.mStartMotionPath.height;
        RectF end = new RectF();
        end.left = this.mEndMotionPath.x;
        end.top = this.mEndMotionPath.y;
        end.right = end.left + this.mEndMotionPath.width;
        end.bottom = end.top + this.mEndMotionPath.height;
        for (Key key : this.mKeyList) {
            if (!(key instanceof KeyPositionBase) || !((KeyPositionBase)key).intersects(layoutWidth, layoutHeight, start, end, x, y)) continue;
            return (KeyPositionBase)key;
        }
        return null;
    }

    int buildKeyFrames(float[] keyFrames, int[] mode) {
        if (keyFrames != null) {
            int count2 = 0;
            double[] time = this.mSpline[0].getTimePoints();
            if (mode != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    mode[count2++] = keyFrame.mMode;
                }
                count2 = 0;
            }
            for (int i = 0; i < time.length; ++i) {
                this.mSpline[0].getPos(time[i], this.mInterpolateData);
                this.mStartMotionPath.getCenter(time[i], this.mInterpolateVariables, this.mInterpolateData, keyFrames, count2);
                count2 += 2;
            }
            return count2 / 2;
        }
        return 0;
    }

    int buildKeyBounds(float[] keyBounds, int[] mode) {
        if (keyBounds != null) {
            int count2 = 0;
            double[] time = this.mSpline[0].getTimePoints();
            if (mode != null) {
                for (MotionPaths keyFrame : this.mMotionPaths) {
                    mode[count2++] = keyFrame.mMode;
                }
                count2 = 0;
            }
            for (int i = 0; i < time.length; ++i) {
                this.mSpline[0].getPos(time[i], this.mInterpolateData);
                this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, keyBounds, count2);
                count2 += 2;
            }
            return count2 / 2;
        }
        return 0;
    }

    int getAttributeValues(String attributeType, float[] points, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        SplineSet spline = this.mAttributesMap.get(attributeType);
        if (spline == null) {
            return -1;
        }
        for (int j = 0; j < points.length; ++j) {
            points[j] = spline.get(j / (points.length - 1));
        }
        return points.length;
    }

    void buildRect(float p, float[] path2, int offset) {
        p = this.getAdjustedPosition(p, null);
        this.mSpline[0].getPos((double)p, this.mInterpolateData);
        this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, path2, offset);
    }

    void buildRectangles(float[] path2, int pointCount) {
        float mils = 1.0f / (float)(pointCount - 1);
        for (int i = 0; i < pointCount; ++i) {
            float position = (float)i * mils;
            position = this.getAdjustedPosition(position, null);
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, path2, i * 8);
        }
    }

    float getKeyFrameParameter(int type, float x, float y) {
        float dx = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float dy = this.mEndMotionPath.y - this.mStartMotionPath.y;
        float startCenterX = this.mStartMotionPath.x + this.mStartMotionPath.width / 2.0f;
        float startCenterY = this.mStartMotionPath.y + this.mStartMotionPath.height / 2.0f;
        float hypotenuse = (float)Math.hypot(dx, dy);
        if ((double)hypotenuse < 1.0E-7) {
            return Float.NaN;
        }
        float vx = x - startCenterX;
        float vy = y - startCenterY;
        float distFromStart = (float)Math.hypot(vx, vy);
        if (distFromStart == 0.0f) {
            return 0.0f;
        }
        float pathDistance = vx * dx + vy * dy;
        switch (type) {
            case 0: {
                return pathDistance / hypotenuse;
            }
            case 1: {
                return (float)Math.sqrt(hypotenuse * hypotenuse - pathDistance * pathDistance);
            }
            case 2: {
                return vx / dx;
            }
            case 3: {
                return vy / dx;
            }
            case 4: {
                return vx / dy;
            }
            case 5: {
                return vy / dy;
            }
        }
        return 0.0f;
    }

    private void insertKey(MotionPaths point) {
        int pos = Collections.binarySearch(this.mMotionPaths, point);
        if (pos == 0) {
            Log.e((String)TAG, (String)(" KeyPath position \"" + point.position + "\" outside of range"));
        }
        this.mMotionPaths.add(-pos - 1, point);
    }

    void addKeys(ArrayList<Key> list) {
        this.mKeyList.addAll(list);
    }

    public void addKey(Key key) {
        this.mKeyList.add(key);
    }

    public void setPathMotionArc(int arc) {
        this.mPathMotionArc = arc;
    }

    public void setup(int parentWidth, int parentHeight, float transitionDuration, long currentTime) {
        int i;
        int i2;
        ConstraintAttribute customAttribute;
        Object customAttributeName;
        SparseArray attrList;
        HashSet springAttributes = new HashSet();
        HashSet<String> timeCycleAttributes = new HashSet<String>();
        HashSet<String> splineAttributes = new HashSet<String>();
        HashSet<String> cycleAttributes = new HashSet<String>();
        HashMap<String, Integer> interpolation = new HashMap<String, Integer>();
        ArrayList<KeyTrigger> triggerList = null;
        if (this.mPathMotionArc != Key.UNSET) {
            this.mStartMotionPath.mPathMotionArc = this.mPathMotionArc;
        }
        this.mStartPoint.different(this.mEndPoint, splineAttributes);
        if (this.mKeyList != null) {
            for (Key key : this.mKeyList) {
                if (key instanceof KeyPosition) {
                    KeyPosition keyPath = (KeyPosition)key;
                    this.insertKey(new MotionPaths(parentWidth, parentHeight, keyPath, this.mStartMotionPath, this.mEndMotionPath));
                    if (keyPath.mCurveFit == Key.UNSET) continue;
                    this.mCurveFitType = keyPath.mCurveFit;
                    continue;
                }
                if (key instanceof KeyCycle) {
                    key.getAttributeNames(cycleAttributes);
                    continue;
                }
                if (key instanceof KeyTimeCycle) {
                    key.getAttributeNames(timeCycleAttributes);
                    continue;
                }
                if (key instanceof KeyTrigger) {
                    if (triggerList == null) {
                        triggerList = new ArrayList<KeyTrigger>();
                    }
                    triggerList.add((KeyTrigger)key);
                    continue;
                }
                key.setInterpolation(interpolation);
                key.getAttributeNames(splineAttributes);
            }
        }
        if (triggerList != null) {
            this.mKeyTriggers = triggerList.toArray(new KeyTrigger[0]);
        }
        if (!splineAttributes.isEmpty()) {
            this.mAttributesMap = new HashMap();
            for (String attribute : splineAttributes) {
                ViewSpline splineSets;
                if (attribute.startsWith("CUSTOM,")) {
                    attrList = new SparseArray();
                    customAttributeName = attribute.split(",")[1];
                    for (Key key : this.mKeyList) {
                        if (key.mCustomConstraints == null || (customAttribute = key.mCustomConstraints.get(customAttributeName)) == null) continue;
                        attrList.append(key.mFramePosition, (Object)customAttribute);
                    }
                    splineSets = ViewSpline.makeCustomSpline(attribute, (SparseArray<ConstraintAttribute>)attrList);
                } else {
                    splineSets = ViewSpline.makeSpline(attribute);
                }
                if (splineSets == null) continue;
                splineSets.setType(attribute);
                this.mAttributesMap.put(attribute, splineSets);
            }
            if (this.mKeyList != null) {
                for (Key key : this.mKeyList) {
                    if (!(key instanceof KeyAttributes)) continue;
                    key.addValues(this.mAttributesMap);
                }
            }
            this.mStartPoint.addValues(this.mAttributesMap, 0);
            this.mEndPoint.addValues(this.mAttributesMap, 100);
            for (String spline : this.mAttributesMap.keySet()) {
                SplineSet splineSet;
                Integer boxedCurve;
                int curve = 0;
                if (interpolation.containsKey(spline) && (boxedCurve = interpolation.get(spline)) != null) {
                    curve = boxedCurve;
                }
                if ((splineSet = (SplineSet)this.mAttributesMap.get(spline)) == null) continue;
                splineSet.setup(curve);
            }
        }
        if (!timeCycleAttributes.isEmpty()) {
            if (this.mTimeCycleAttributesMap == null) {
                this.mTimeCycleAttributesMap = new HashMap();
            }
            for (String attribute : timeCycleAttributes) {
                if (this.mTimeCycleAttributesMap.containsKey(attribute)) continue;
                ViewTimeCycle splineSets = null;
                if (attribute.startsWith("CUSTOM,")) {
                    attrList = new SparseArray();
                    customAttributeName = attribute.split(",")[1];
                    for (Key key : this.mKeyList) {
                        if (key.mCustomConstraints == null || (customAttribute = key.mCustomConstraints.get(customAttributeName)) == null) continue;
                        attrList.append(key.mFramePosition, (Object)customAttribute);
                    }
                    splineSets = ViewTimeCycle.makeCustomSpline(attribute, (SparseArray<ConstraintAttribute>)attrList);
                } else {
                    splineSets = ViewTimeCycle.makeSpline(attribute, currentTime);
                }
                if (splineSets == null) continue;
                splineSets.setType(attribute);
                this.mTimeCycleAttributesMap.put(attribute, splineSets);
            }
            if (this.mKeyList != null) {
                for (Key key : this.mKeyList) {
                    if (!(key instanceof KeyTimeCycle)) continue;
                    ((KeyTimeCycle)key).addTimeValues(this.mTimeCycleAttributesMap);
                }
            }
            for (String spline : this.mTimeCycleAttributesMap.keySet()) {
                int curve = 0;
                if (interpolation.containsKey(spline)) {
                    curve = interpolation.get(spline);
                }
                this.mTimeCycleAttributesMap.get(spline).setup(curve);
            }
        }
        MotionPaths[] points = new MotionPaths[2 + this.mMotionPaths.size()];
        int count2 = 1;
        points[0] = this.mStartMotionPath;
        points[points.length - 1] = this.mEndMotionPath;
        if (this.mMotionPaths.size() > 0 && this.mCurveFitType == -1) {
            this.mCurveFitType = 0;
        }
        for (MotionPaths point : this.mMotionPaths) {
            points[count2++] = point;
        }
        int variables = 18;
        HashSet<String> attributeNameSet = new HashSet<String>();
        for (String s : this.mEndMotionPath.attributes.keySet()) {
            if (!this.mStartMotionPath.attributes.containsKey(s) || splineAttributes.contains("CUSTOM," + s)) continue;
            attributeNameSet.add(s);
        }
        this.mAttributeNames = attributeNameSet.toArray(new String[0]);
        this.mAttributeInterpolatorCount = new int[this.mAttributeNames.length];
        block11: for (int i3 = 0; i3 < this.mAttributeNames.length; ++i3) {
            String attributeName = this.mAttributeNames[i3];
            this.mAttributeInterpolatorCount[i3] = 0;
            for (int j = 0; j < points.length; ++j) {
                ConstraintAttribute attribute;
                if (!points[j].attributes.containsKey(attributeName) || (attribute = points[j].attributes.get(attributeName)) == null) continue;
                int n = i3;
                this.mAttributeInterpolatorCount[n] = this.mAttributeInterpolatorCount[n] + attribute.numberOfInterpolatedValues();
                continue block11;
            }
        }
        boolean arcMode = points[0].mPathMotionArc != Key.UNSET;
        boolean[] mask = new boolean[variables + this.mAttributeNames.length];
        for (i2 = 1; i2 < points.length; ++i2) {
            points[i2].different(points[i2 - 1], mask, this.mAttributeNames, arcMode);
        }
        count2 = 0;
        for (i2 = 1; i2 < mask.length; ++i2) {
            if (!mask[i2]) continue;
            ++count2;
        }
        this.mInterpolateVariables = new int[count2];
        int varLen = Math.max(2, count2);
        this.mInterpolateData = new double[varLen];
        this.mInterpolateVelocity = new double[varLen];
        count2 = 0;
        for (int i4 = 1; i4 < mask.length; ++i4) {
            if (!mask[i4]) continue;
            this.mInterpolateVariables[count2++] = i4;
        }
        double[][] splineData = new double[points.length][this.mInterpolateVariables.length];
        double[] timePoint = new double[points.length];
        for (i = 0; i < points.length; ++i) {
            points[i].fillStandard(splineData[i], this.mInterpolateVariables);
            timePoint[i] = points[i].time;
        }
        for (int j = 0; j < this.mInterpolateVariables.length; ++j) {
            int interpolateVariable = this.mInterpolateVariables[j];
            if (interpolateVariable >= MotionPaths.names.length) continue;
            String s = MotionPaths.names[this.mInterpolateVariables[j]] + " [";
            for (int i5 = 0; i5 < points.length; ++i5) {
                s = s + splineData[i5][j];
            }
        }
        this.mSpline = new CurveFit[1 + this.mAttributeNames.length];
        for (i = 0; i < this.mAttributeNames.length; ++i) {
            int pointCount = 0;
            double[][] splinePoints = null;
            double[] timePoints = null;
            String name = this.mAttributeNames[i];
            for (int j = 0; j < points.length; ++j) {
                if (!points[j].hasCustomData(name)) continue;
                if (splinePoints == null) {
                    timePoints = new double[points.length];
                    splinePoints = new double[points.length][points[j].getCustomDataCount(name)];
                }
                timePoints[pointCount] = points[j].time;
                points[j].getCustomData(name, splinePoints[pointCount], 0);
                ++pointCount;
            }
            timePoints = Arrays.copyOf(timePoints, pointCount);
            splinePoints = (double[][])Arrays.copyOf(splinePoints, pointCount);
            this.mSpline[i + 1] = CurveFit.get(this.mCurveFitType, timePoints, splinePoints);
        }
        this.mSpline[0] = CurveFit.get(this.mCurveFitType, timePoint, splineData);
        if (points[0].mPathMotionArc != Key.UNSET) {
            int size = points.length;
            int[] mode = new int[size];
            double[] time = new double[size];
            double[][] values2 = new double[size][2];
            for (int i6 = 0; i6 < size; ++i6) {
                mode[i6] = points[i6].mPathMotionArc;
                time[i6] = points[i6].time;
                values2[i6][0] = points[i6].x;
                values2[i6][1] = points[i6].y;
            }
            this.mArcSpline = CurveFit.getArc(mode, time, values2);
        }
        float distance = Float.NaN;
        this.mCycleMap = new HashMap();
        if (this.mKeyList != null) {
            for (String attribute : cycleAttributes) {
                ViewOscillator cycle = ViewOscillator.makeSpline(attribute);
                if (cycle == null) continue;
                if (cycle.variesByPath() && Float.isNaN(distance)) {
                    distance = this.getPreCycleDistance();
                }
                cycle.setType(attribute);
                this.mCycleMap.put(attribute, cycle);
            }
            for (Key key : this.mKeyList) {
                if (!(key instanceof KeyCycle)) continue;
                ((KeyCycle)key).addCycleValues(this.mCycleMap);
            }
            for (ViewOscillator cycle : this.mCycleMap.values()) {
                cycle.setup(distance);
            }
        }
    }

    public String toString() {
        return " start: x: " + this.mStartMotionPath.x + " y: " + this.mStartMotionPath.y + " end: x: " + this.mEndMotionPath.x + " y: " + this.mEndMotionPath.y;
    }

    private void readView(MotionPaths motionPaths) {
        motionPaths.setBounds((int)this.mView.getX(), (int)this.mView.getY(), this.mView.getWidth(), this.mView.getHeight());
    }

    public void setView(View view) {
        this.mView = view;
        this.mId = view.getId();
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp instanceof ConstraintLayout.LayoutParams) {
            this.mConstraintTag = ((ConstraintLayout.LayoutParams)lp).getConstraintTag();
        }
    }

    public View getView() {
        return this.mView;
    }

    void setStartCurrentState(View v) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.mStartMotionPath.setBounds(v.getX(), v.getY(), v.getWidth(), v.getHeight());
        this.mStartPoint.setState(v);
    }

    public void setStartState(ViewState rect, View v, int rotation, int preWidth, int preHeight) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        Rect r = new Rect();
        switch (rotation) {
            case 2: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                r.left = preHeight - (cy + rect.width()) / 2;
                r.top = (cx - rect.height()) / 2;
                r.right = r.left + rect.width();
                r.bottom = r.top + rect.height();
                break;
            }
            case 1: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                r.left = (cy - rect.width()) / 2;
                r.top = preWidth - (cx + rect.height()) / 2;
                r.right = r.left + rect.width();
                r.bottom = r.top + rect.height();
            }
        }
        this.mStartMotionPath.setBounds(r.left, r.top, r.width(), r.height());
        this.mStartPoint.setState(r, v, rotation, rect.rotation);
    }

    void rotate(Rect rect, Rect out, int rotation, int preHeight, int preWidth) {
        switch (rotation) {
            case 2: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                out.left = preHeight - (cy + rect.width()) / 2;
                out.top = (cx - rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
                break;
            }
            case 1: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                out.left = (cy - rect.width()) / 2;
                out.top = preWidth - (cx + rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
                break;
            }
            case 4: {
                int cx = rect.left + rect.right;
                int cy = rect.bottom + rect.top;
                out.left = preHeight - (cy + rect.width()) / 2;
                out.top = (cx - rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
                break;
            }
            case 3: {
                int cx = rect.left + rect.right;
                int cy = rect.top + rect.bottom;
                out.left = rect.height() / 2 + rect.top - cx / 2;
                out.top = preWidth - (cx + rect.height()) / 2;
                out.right = out.left + rect.width();
                out.bottom = out.top + rect.height();
            }
        }
    }

    void setStartState(Rect cw, ConstraintSet constraintSet, int parentWidth, int parentHeight) {
        int rotate = constraintSet.mRotate;
        if (rotate != 0) {
            this.rotate(cw, this.mTempRect, rotate, parentWidth, parentHeight);
        }
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.readView(this.mStartMotionPath);
        this.mStartMotionPath.setBounds(cw.left, cw.top, cw.width(), cw.height());
        ConstraintSet.Constraint constraint = constraintSet.getParameters(this.mId);
        this.mStartMotionPath.applyParameters(constraint);
        this.mMotionStagger = constraint.motion.mMotionStagger;
        this.mStartPoint.setState(cw, constraintSet, rotate, this.mId);
        this.mTransformPivotTarget = constraint.transform.transformPivotTarget;
        this.mQuantizeMotionSteps = constraint.motion.mQuantizeMotionSteps;
        this.mQuantizeMotionPhase = constraint.motion.mQuantizeMotionPhase;
        this.mQuantizeMotionInterpolator = MotionController.getInterpolator(this.mView.getContext(), constraint.motion.mQuantizeInterpolatorType, constraint.motion.mQuantizeInterpolatorString, constraint.motion.mQuantizeInterpolatorID);
    }

    private static Interpolator getInterpolator(Context context, int type, String interpolatorString, int id2) {
        switch (type) {
            case -1: {
                final Easing easing = Easing.getInterpolator(interpolatorString);
                return new Interpolator(){

                    public float getInterpolation(float v) {
                        return (float)easing.get(v);
                    }
                };
            }
            case -2: {
                return AnimationUtils.loadInterpolator((Context)context, (int)id2);
            }
            case 0: {
                return new AccelerateDecelerateInterpolator();
            }
            case 1: {
                return new AccelerateInterpolator();
            }
            case 2: {
                return new DecelerateInterpolator();
            }
            case 3: {
                return null;
            }
            case 4: {
                return new BounceInterpolator();
            }
            case 5: {
                return new OvershootInterpolator();
            }
        }
        return null;
    }

    void setEndState(Rect cw, ConstraintSet constraintSet, int parentWidth, int parentHeight) {
        int rotate = constraintSet.mRotate;
        if (rotate != 0) {
            this.rotate(cw, this.mTempRect, rotate, parentWidth, parentHeight);
            cw = this.mTempRect;
        }
        this.mEndMotionPath.time = 1.0f;
        this.mEndMotionPath.position = 1.0f;
        this.readView(this.mEndMotionPath);
        this.mEndMotionPath.setBounds(cw.left, cw.top, cw.width(), cw.height());
        this.mEndMotionPath.applyParameters(constraintSet.getParameters(this.mId));
        this.mEndPoint.setState(cw, constraintSet, rotate, this.mId);
    }

    void setBothStates(View v) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.mNoMovement = true;
        this.mStartMotionPath.setBounds(v.getX(), v.getY(), v.getWidth(), v.getHeight());
        this.mEndMotionPath.setBounds(v.getX(), v.getY(), v.getWidth(), v.getHeight());
        this.mStartPoint.setState(v);
        this.mEndPoint.setState(v);
    }

    private float getAdjustedPosition(float position, float[] velocity) {
        if (velocity != null) {
            velocity[0] = 1.0f;
        } else if ((double)this.mStaggerScale != 1.0) {
            if (position < this.mStaggerOffset) {
                position = 0.0f;
            }
            if (position > this.mStaggerOffset && (double)position < 1.0) {
                position -= this.mStaggerOffset;
                position *= this.mStaggerScale;
                position = Math.min(position, 1.0f);
            }
        }
        float adjusted = position;
        Easing easing = this.mStartMotionPath.mKeyFrameEasing;
        float start = 0.0f;
        float end = Float.NaN;
        for (MotionPaths frame : this.mMotionPaths) {
            if (frame.mKeyFrameEasing == null) continue;
            if (frame.time < position) {
                easing = frame.mKeyFrameEasing;
                start = frame.time;
                continue;
            }
            if (!Float.isNaN(end)) continue;
            end = frame.time;
        }
        if (easing != null) {
            if (Float.isNaN(end)) {
                end = 1.0f;
            }
            float offset = (position - start) / (end - start);
            float new_offset = (float)easing.get(offset);
            adjusted = new_offset * (end - start) + start;
            if (velocity != null) {
                velocity[0] = (float)easing.getDiff(offset);
            }
        }
        return adjusted;
    }

    void endTrigger(boolean start) {
        if ("button".equals(Debug.getName(this.mView)) && this.mKeyTriggers != null) {
            for (int i = 0; i < this.mKeyTriggers.length; ++i) {
                this.mKeyTriggers[i].conditionallyFire(start ? -100.0f : 100.0f, this.mView);
            }
        }
    }

    boolean interpolate(View child, float global_position, long time, KeyCache keyCache) {
        float f;
        boolean timeAnimation = false;
        float position = this.getAdjustedPosition(global_position, null);
        if (this.mQuantizeMotionSteps != Key.UNSET) {
            float pin = position;
            float steps = 1.0f / (float)this.mQuantizeMotionSteps;
            f = (float)Math.floor(position / steps) * steps;
            float section = position % steps / steps;
            if (!Float.isNaN(this.mQuantizeMotionPhase)) {
                section = (section + this.mQuantizeMotionPhase) % 1.0f;
            }
            section = this.mQuantizeMotionInterpolator != null ? this.mQuantizeMotionInterpolator.getInterpolation(section) : ((double)section > 0.5 ? 1.0f : 0.0f);
            position = section * steps + f;
        }
        ViewTimeCycle.PathRotate timePathRotate = null;
        if (this.mAttributesMap != null) {
            for (ViewSpline viewSpline : this.mAttributesMap.values()) {
                viewSpline.setProperty(child, position);
            }
        }
        if (this.mTimeCycleAttributesMap != null) {
            for (ViewTimeCycle viewTimeCycle : this.mTimeCycleAttributesMap.values()) {
                if (viewTimeCycle instanceof ViewTimeCycle.PathRotate) {
                    timePathRotate = (ViewTimeCycle.PathRotate)viewTimeCycle;
                    continue;
                }
                timeAnimation |= viewTimeCycle.setProperty(child, position, time, keyCache);
            }
        }
        if (this.mSpline != null) {
            int i;
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            this.mSpline[0].getSlope((double)position, this.mInterpolateVelocity);
            if (this.mArcSpline != null && this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos((double)position, this.mInterpolateData);
                this.mArcSpline.getSlope((double)position, this.mInterpolateVelocity);
            }
            if (!this.mNoMovement) {
                this.mStartMotionPath.setView(position, child, this.mInterpolateVariables, this.mInterpolateData, this.mInterpolateVelocity, null, this.mForceMeasure);
                this.mForceMeasure = false;
            }
            if (this.mTransformPivotTarget != Key.UNSET) {
                if (this.mTransformPivotView == null) {
                    View layout2 = (View)child.getParent();
                    this.mTransformPivotView = layout2.findViewById(this.mTransformPivotTarget);
                }
                if (this.mTransformPivotView != null) {
                    float cy = (float)(this.mTransformPivotView.getTop() + this.mTransformPivotView.getBottom()) / 2.0f;
                    f = (float)(this.mTransformPivotView.getLeft() + this.mTransformPivotView.getRight()) / 2.0f;
                    if (child.getRight() - child.getLeft() > 0 && child.getBottom() - child.getTop() > 0) {
                        float px = f - (float)child.getLeft();
                        float py = cy - (float)child.getTop();
                        child.setPivotX(px);
                        child.setPivotY(py);
                    }
                }
            }
            if (this.mAttributesMap != null) {
                for (SplineSet splineSet : this.mAttributesMap.values()) {
                    if (!(splineSet instanceof ViewSpline.PathRotate) || this.mInterpolateVelocity.length <= 1) continue;
                    ((ViewSpline.PathRotate)splineSet).setPathRotate(child, position, this.mInterpolateVelocity[0], this.mInterpolateVelocity[1]);
                }
            }
            if (timePathRotate != null) {
                timeAnimation |= timePathRotate.setPathRotate(child, keyCache, position, time, this.mInterpolateVelocity[0], this.mInterpolateVelocity[1]);
            }
            for (i = 1; i < this.mSpline.length; ++i) {
                CurveFit curveFit = this.mSpline[i];
                curveFit.getPos((double)position, this.mValuesBuff);
                CustomSupport.setInterpolatedValue(this.mStartMotionPath.attributes.get(this.mAttributeNames[i - 1]), child, this.mValuesBuff);
            }
            if (this.mStartPoint.mVisibilityMode == 0) {
                if (position <= 0.0f) {
                    child.setVisibility(this.mStartPoint.visibility);
                } else if (position >= 1.0f) {
                    child.setVisibility(this.mEndPoint.visibility);
                } else if (this.mEndPoint.visibility != this.mStartPoint.visibility) {
                    child.setVisibility(0);
                }
            }
            if (this.mKeyTriggers != null) {
                for (i = 0; i < this.mKeyTriggers.length; ++i) {
                    this.mKeyTriggers[i].conditionallyFire(position, child);
                }
            }
        } else {
            float float_l = this.mStartMotionPath.x + (this.mEndMotionPath.x - this.mStartMotionPath.x) * position;
            f = this.mStartMotionPath.y + (this.mEndMotionPath.y - this.mStartMotionPath.y) * position;
            float float_width = this.mStartMotionPath.width + (this.mEndMotionPath.width - this.mStartMotionPath.width) * position;
            float float_height = this.mStartMotionPath.height + (this.mEndMotionPath.height - this.mStartMotionPath.height) * position;
            int l = (int)(0.5f + float_l);
            int t = (int)(0.5f + f);
            int r = (int)(0.5f + float_l + float_width);
            int b = (int)(0.5f + f + float_height);
            int width = r - l;
            int height = b - t;
            if (this.mEndMotionPath.width != this.mStartMotionPath.width || this.mEndMotionPath.height != this.mStartMotionPath.height || this.mForceMeasure) {
                int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
                int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                child.measure(widthMeasureSpec, heightMeasureSpec);
                this.mForceMeasure = false;
            }
            child.layout(l, t, r, b);
        }
        if (this.mCycleMap != null) {
            for (ViewOscillator viewOscillator : this.mCycleMap.values()) {
                if (viewOscillator instanceof ViewOscillator.PathRotateSet) {
                    ((ViewOscillator.PathRotateSet)viewOscillator).setPathRotate(child, position, this.mInterpolateVelocity[0], this.mInterpolateVelocity[1]);
                    continue;
                }
                viewOscillator.setProperty(child, position);
            }
        }
        return timeAnimation;
    }

    void getDpDt(float position, float locationX, float locationY, float[] mAnchorDpDt) {
        position = this.getAdjustedPosition(position, this.mVelocity);
        if (this.mSpline != null) {
            this.mSpline[0].getSlope((double)position, this.mInterpolateVelocity);
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            float v = this.mVelocity[0];
            int i = 0;
            while (i < this.mInterpolateVelocity.length) {
                int n = i++;
                this.mInterpolateVelocity[n] = this.mInterpolateVelocity[n] * (double)v;
            }
            if (this.mArcSpline != null) {
                if (this.mInterpolateData.length > 0) {
                    this.mArcSpline.getPos((double)position, this.mInterpolateData);
                    this.mArcSpline.getSlope((double)position, this.mInterpolateVelocity);
                    this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
                }
                return;
            }
            this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            return;
        }
        float dleft = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float dTop = this.mEndMotionPath.y - this.mStartMotionPath.y;
        float dWidth = this.mEndMotionPath.width - this.mStartMotionPath.width;
        float dHeight = this.mEndMotionPath.height - this.mStartMotionPath.height;
        float dRight = dleft + dWidth;
        float dBottom = dTop + dHeight;
        mAnchorDpDt[0] = dleft * (1.0f - locationX) + dRight * locationX;
        mAnchorDpDt[1] = dTop * (1.0f - locationY) + dBottom * locationY;
    }

    void getPostLayoutDvDp(float position, int width, int height, float locationX, float locationY, float[] mAnchorDpDt) {
        position = this.getAdjustedPosition(position, this.mVelocity);
        SplineSet trans_x = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("translationX");
        SplineSet trans_y = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("translationY");
        SplineSet rotation = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("rotation");
        SplineSet scale_x = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("scaleX");
        SplineSet scale_y = this.mAttributesMap == null ? null : (SplineSet)this.mAttributesMap.get("scaleY");
        ViewOscillator osc_x = this.mCycleMap == null ? null : this.mCycleMap.get("translationX");
        ViewOscillator osc_y = this.mCycleMap == null ? null : this.mCycleMap.get("translationY");
        ViewOscillator osc_r = this.mCycleMap == null ? null : this.mCycleMap.get("rotation");
        ViewOscillator osc_sx = this.mCycleMap == null ? null : this.mCycleMap.get("scaleX");
        ViewOscillator osc_sy = this.mCycleMap == null ? null : this.mCycleMap.get("scaleY");
        VelocityMatrix vmat = new VelocityMatrix();
        vmat.clear();
        vmat.setRotationVelocity(rotation, position);
        vmat.setTranslationVelocity(trans_x, trans_y, position);
        vmat.setScaleVelocity(scale_x, scale_y, position);
        vmat.setRotationVelocity(osc_r, position);
        vmat.setTranslationVelocity(osc_x, osc_y, position);
        vmat.setScaleVelocity(osc_sx, osc_sy, position);
        if (this.mArcSpline != null) {
            if (this.mInterpolateData.length > 0) {
                this.mArcSpline.getPos((double)position, this.mInterpolateData);
                this.mArcSpline.getSlope((double)position, this.mInterpolateVelocity);
                this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            }
            vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
            return;
        }
        if (this.mSpline != null) {
            position = this.getAdjustedPosition(position, this.mVelocity);
            this.mSpline[0].getSlope((double)position, this.mInterpolateVelocity);
            this.mSpline[0].getPos((double)position, this.mInterpolateData);
            float v = this.mVelocity[0];
            int i = 0;
            while (i < this.mInterpolateVelocity.length) {
                int n = i++;
                this.mInterpolateVelocity[n] = this.mInterpolateVelocity[n] * (double)v;
            }
            this.mStartMotionPath.setDpDt(locationX, locationY, mAnchorDpDt, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
            return;
        }
        float dleft = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float dTop = this.mEndMotionPath.y - this.mStartMotionPath.y;
        float dWidth = this.mEndMotionPath.width - this.mStartMotionPath.width;
        float dHeight = this.mEndMotionPath.height - this.mStartMotionPath.height;
        float dRight = dleft + dWidth;
        float dBottom = dTop + dHeight;
        mAnchorDpDt[0] = dleft * (1.0f - locationX) + dRight * locationX;
        mAnchorDpDt[1] = dTop * (1.0f - locationY) + dBottom * locationY;
        vmat.clear();
        vmat.setRotationVelocity(rotation, position);
        vmat.setTranslationVelocity(trans_x, trans_y, position);
        vmat.setScaleVelocity(scale_x, scale_y, position);
        vmat.setRotationVelocity(osc_r, position);
        vmat.setTranslationVelocity(osc_x, osc_y, position);
        vmat.setScaleVelocity(osc_sx, osc_sy, position);
        vmat.applyTransform(locationX, locationY, width, height, mAnchorDpDt);
    }

    public int getDrawPath() {
        int mode = this.mStartMotionPath.mDrawPath;
        for (MotionPaths keyFrame : this.mMotionPaths) {
            mode = Math.max(mode, keyFrame.mDrawPath);
        }
        mode = Math.max(mode, this.mEndMotionPath.mDrawPath);
        return mode;
    }

    public void setDrawPath(int debugMode) {
        this.mStartMotionPath.mDrawPath = debugMode;
    }

    String name() {
        Context context = this.mView.getContext();
        return context.getResources().getResourceEntryName(this.mView.getId());
    }

    void positionKeyframe(View view, KeyPositionBase key, float x, float y, String[] attribute, float[] value) {
        RectF start = new RectF();
        start.left = this.mStartMotionPath.x;
        start.top = this.mStartMotionPath.y;
        start.right = start.left + this.mStartMotionPath.width;
        start.bottom = start.top + this.mStartMotionPath.height;
        RectF end = new RectF();
        end.left = this.mEndMotionPath.x;
        end.top = this.mEndMotionPath.y;
        end.right = end.left + this.mEndMotionPath.width;
        end.bottom = end.top + this.mEndMotionPath.height;
        key.positionAttributes(view, start, end, x, y, attribute, value);
    }

    public int getKeyFramePositions(int[] type, float[] pos) {
        int i = 0;
        int count2 = 0;
        for (Key key : this.mKeyList) {
            type[i++] = key.mFramePosition + 1000 * key.mType;
            float time = (float)key.mFramePosition / 100.0f;
            this.mSpline[0].getPos((double)time, this.mInterpolateData);
            this.mStartMotionPath.getCenter(time, this.mInterpolateVariables, this.mInterpolateData, pos, count2);
            count2 += 2;
        }
        return i;
    }

    public int getKeyFrameInfo(int type, int[] info) {
        int count2 = 0;
        int cursor = 0;
        float[] pos = new float[2];
        for (Key key : this.mKeyList) {
            if (key.mType != type && type == -1) continue;
            int len = cursor;
            info[cursor] = 0;
            info[++cursor] = key.mType;
            info[++cursor] = key.mFramePosition;
            float time = (float)key.mFramePosition / 100.0f;
            this.mSpline[0].getPos((double)time, this.mInterpolateData);
            this.mStartMotionPath.getCenter(time, this.mInterpolateVariables, this.mInterpolateData, pos, 0);
            info[++cursor] = Float.floatToIntBits(pos[0]);
            info[++cursor] = Float.floatToIntBits(pos[1]);
            if (key instanceof KeyPosition) {
                KeyPosition kp = (KeyPosition)key;
                info[++cursor] = kp.mPositionType;
                info[++cursor] = Float.floatToIntBits(kp.mPercentX);
                info[++cursor] = Float.floatToIntBits(kp.mPercentY);
            }
            info[len] = ++cursor - len;
            ++count2;
        }
        return count2;
    }
}

