/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionHelperInterface;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;

public class MotionHelper
extends ConstraintHelper
implements MotionHelperInterface {
    private boolean mUseOnShow = false;
    private boolean mUseOnHide = false;
    private float mProgress;
    protected View[] views;

    public MotionHelper(Context context) {
        super(context);
    }

    public MotionHelper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MotionHelper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MotionHelper);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.MotionHelper_onShow) {
                    this.mUseOnShow = a.getBoolean(attr2, this.mUseOnShow);
                    continue;
                }
                if (attr2 != R.styleable.MotionHelper_onHide) continue;
                this.mUseOnHide = a.getBoolean(attr2, this.mUseOnHide);
            }
            a.recycle();
        }
    }

    @Override
    public boolean isUsedOnShow() {
        return this.mUseOnShow;
    }

    @Override
    public boolean isUseOnHide() {
        return this.mUseOnHide;
    }

    @Override
    public float getProgress() {
        return this.mProgress;
    }

    @Override
    public void setProgress(float progress) {
        this.mProgress = progress;
        if (this.mCount > 0) {
            this.views = this.getViews((ConstraintLayout)this.getParent());
            for (int i = 0; i < this.mCount; ++i) {
                View view = this.views[i];
                this.setProgress(view, progress);
            }
        } else {
            ViewGroup group = (ViewGroup)this.getParent();
            int count2 = group.getChildCount();
            for (int i = 0; i < count2; ++i) {
                View view = group.getChildAt(i);
                if (view instanceof MotionHelper) continue;
                this.setProgress(view, progress);
            }
        }
    }

    public void setProgress(View view, float progress) {
    }

    @Override
    public void onTransitionStarted(MotionLayout motionLayout, int startId, int endId) {
    }

    @Override
    public void onTransitionChange(MotionLayout motionLayout, int startId, int endId, float progress) {
    }

    @Override
    public void onTransitionCompleted(MotionLayout motionLayout, int currentId) {
    }

    @Override
    public void onTransitionTrigger(MotionLayout motionLayout, int triggerId, boolean positive, float progress) {
    }

    @Override
    public boolean isDecorator() {
        return false;
    }

    @Override
    public void onPreDraw(Canvas canvas) {
    }

    @Override
    public void onFinishedMotionScene(MotionLayout motionLayout) {
    }

    @Override
    public void onPostDraw(Canvas canvas) {
    }

    @Override
    public void onPreSetup(MotionLayout motionLayout, HashMap<View, MotionController> controllerMap) {
    }
}

