/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.motion.widget.OnSwipe;
import androidx.constraintlayout.widget.R;
import androidx.core.widget.NestedScrollView;
import org.xmlpull.v1.XmlPullParser;

class TouchResponse {
    private static final String TAG = "TouchResponse";
    private static final boolean DEBUG = false;
    private int mTouchAnchorSide = 0;
    private int mTouchSide = 0;
    private int mOnTouchUp = 0;
    private int mTouchAnchorId = -1;
    private int mTouchRegionId = -1;
    private int mLimitBoundsTo = -1;
    private float mTouchAnchorY = 0.5f;
    private float mTouchAnchorX = 0.5f;
    float mRotateCenterX = 0.5f;
    float mRotateCenterY = 0.5f;
    private int mRotationCenterId = -1;
    boolean mIsRotateMode = false;
    private float mTouchDirectionX = 0.0f;
    private float mTouchDirectionY = 1.0f;
    private boolean mDragStarted = false;
    private float[] mAnchorDpDt = new float[2];
    private int[] mTempLoc = new int[2];
    private float mLastTouchX;
    private float mLastTouchY;
    private final MotionLayout mMotionLayout;
    private static final int SEC_TO_MILLISECONDS = 1000;
    private static final float EPSILON = 1.0E-7f;
    private static final float[][] TOUCH_SIDES = new float[][]{{0.5f, 0.0f}, {0.0f, 0.5f}, {1.0f, 0.5f}, {0.5f, 1.0f}, {0.5f, 0.5f}, {0.0f, 0.5f}, {1.0f, 0.5f}};
    private static final float[][] TOUCH_DIRECTION = new float[][]{{0.0f, -1.0f}, {0.0f, 1.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}};
    private static final int TOUCH_UP = 0;
    private static final int TOUCH_DOWN = 1;
    private static final int TOUCH_LEFT = 2;
    private static final int TOUCH_RIGHT = 3;
    private static final int TOUCH_START = 4;
    private static final int TOUCH_END = 5;
    private static final int SIDE_TOP = 0;
    private static final int SIDE_LEFT = 1;
    private static final int SIDE_RIGHT = 2;
    private static final int SIDE_BOTTOM = 3;
    private static final int SIDE_MIDDLE = 4;
    private static final int SIDE_START = 5;
    private static final int SIDE_END = 6;
    private float mMaxVelocity = 4.0f;
    private float mMaxAcceleration = 1.2f;
    private boolean mMoveWhenScrollAtTop = true;
    private float mDragScale = 1.0f;
    private int mFlags = 0;
    static final int FLAG_DISABLE_POST_SCROLL = 1;
    static final int FLAG_DISABLE_SCROLL = 2;
    static final int FLAG_SUPPORT_SCROLL_UP = 4;
    private float mDragThreshold = 10.0f;
    private float mSpringDamping = 10.0f;
    private float mSpringMass = 1.0f;
    private float mSpringStiffness = Float.NaN;
    private float mSpringStopThreshold = Float.NaN;
    private int mSpringBoundary = 0;
    private int mAutoCompleteMode = 0;
    public static final int COMPLETE_MODE_CONTINUOUS_VELOCITY = 0;
    public static final int COMPLETE_MODE_SPRING = 1;

    TouchResponse(Context context, MotionLayout layout2, XmlPullParser parser) {
        this.mMotionLayout = layout2;
        this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
    }

    public TouchResponse(MotionLayout layout2, OnSwipe onSwipe) {
        this.mMotionLayout = layout2;
        this.mTouchAnchorId = onSwipe.getTouchAnchorId();
        this.mTouchAnchorSide = onSwipe.getTouchAnchorSide();
        if (this.mTouchAnchorSide != -1) {
            this.mTouchAnchorX = TOUCH_SIDES[this.mTouchAnchorSide][0];
            this.mTouchAnchorY = TOUCH_SIDES[this.mTouchAnchorSide][1];
        }
        this.mTouchSide = onSwipe.getDragDirection();
        if (this.mTouchSide < TOUCH_DIRECTION.length) {
            this.mTouchDirectionX = TOUCH_DIRECTION[this.mTouchSide][0];
            this.mTouchDirectionY = TOUCH_DIRECTION[this.mTouchSide][1];
        } else {
            this.mTouchDirectionY = Float.NaN;
            this.mTouchDirectionX = Float.NaN;
            this.mIsRotateMode = true;
        }
        this.mMaxVelocity = onSwipe.getMaxVelocity();
        this.mMaxAcceleration = onSwipe.getMaxAcceleration();
        this.mMoveWhenScrollAtTop = onSwipe.getMoveWhenScrollAtTop();
        this.mDragScale = onSwipe.getDragScale();
        this.mDragThreshold = onSwipe.getDragThreshold();
        this.mTouchRegionId = onSwipe.getTouchRegionId();
        this.mOnTouchUp = onSwipe.getOnTouchUp();
        this.mFlags = onSwipe.getNestedScrollFlags();
        this.mLimitBoundsTo = onSwipe.getLimitBoundsTo();
        this.mRotationCenterId = onSwipe.getRotationCenterId();
        this.mSpringBoundary = onSwipe.getSpringBoundary();
        this.mSpringDamping = onSwipe.getSpringDamping();
        this.mSpringMass = onSwipe.getSpringMass();
        this.mSpringStiffness = onSwipe.getSpringStiffness();
        this.mSpringStopThreshold = onSwipe.getSpringStopThreshold();
        this.mAutoCompleteMode = onSwipe.getAutoCompleteMode();
    }

    public void setRTL(boolean rtl) {
        if (rtl) {
            TouchResponse.TOUCH_DIRECTION[4] = TOUCH_DIRECTION[3];
            TouchResponse.TOUCH_DIRECTION[5] = TOUCH_DIRECTION[2];
            TouchResponse.TOUCH_SIDES[5] = TOUCH_SIDES[2];
            TouchResponse.TOUCH_SIDES[6] = TOUCH_SIDES[1];
        } else {
            TouchResponse.TOUCH_DIRECTION[4] = TOUCH_DIRECTION[2];
            TouchResponse.TOUCH_DIRECTION[5] = TOUCH_DIRECTION[3];
            TouchResponse.TOUCH_SIDES[5] = TOUCH_SIDES[1];
            TouchResponse.TOUCH_SIDES[6] = TOUCH_SIDES[2];
        }
        this.mTouchAnchorX = TOUCH_SIDES[this.mTouchAnchorSide][0];
        this.mTouchAnchorY = TOUCH_SIDES[this.mTouchAnchorSide][1];
        if (this.mTouchSide >= TOUCH_DIRECTION.length) {
            return;
        }
        this.mTouchDirectionX = TOUCH_DIRECTION[this.mTouchSide][0];
        this.mTouchDirectionY = TOUCH_DIRECTION[this.mTouchSide][1];
    }

    private void fillFromAttributeList(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OnSwipe);
        this.fill(a);
        a.recycle();
    }

    private void fill(TypedArray a) {
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.OnSwipe_touchAnchorId) {
                this.mTouchAnchorId = a.getResourceId(attr2, this.mTouchAnchorId);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_touchAnchorSide) {
                this.mTouchAnchorSide = a.getInt(attr2, this.mTouchAnchorSide);
                this.mTouchAnchorX = TOUCH_SIDES[this.mTouchAnchorSide][0];
                this.mTouchAnchorY = TOUCH_SIDES[this.mTouchAnchorSide][1];
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_dragDirection) {
                this.mTouchSide = a.getInt(attr2, this.mTouchSide);
                if (this.mTouchSide < TOUCH_DIRECTION.length) {
                    this.mTouchDirectionX = TOUCH_DIRECTION[this.mTouchSide][0];
                    this.mTouchDirectionY = TOUCH_DIRECTION[this.mTouchSide][1];
                    continue;
                }
                this.mTouchDirectionY = Float.NaN;
                this.mTouchDirectionX = Float.NaN;
                this.mIsRotateMode = true;
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_maxVelocity) {
                this.mMaxVelocity = a.getFloat(attr2, this.mMaxVelocity);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_maxAcceleration) {
                this.mMaxAcceleration = a.getFloat(attr2, this.mMaxAcceleration);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_moveWhenScrollAtTop) {
                this.mMoveWhenScrollAtTop = a.getBoolean(attr2, this.mMoveWhenScrollAtTop);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_dragScale) {
                this.mDragScale = a.getFloat(attr2, this.mDragScale);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_dragThreshold) {
                this.mDragThreshold = a.getFloat(attr2, this.mDragThreshold);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_touchRegionId) {
                this.mTouchRegionId = a.getResourceId(attr2, this.mTouchRegionId);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_onTouchUp) {
                this.mOnTouchUp = a.getInt(attr2, this.mOnTouchUp);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_nestedScrollFlags) {
                this.mFlags = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_limitBoundsTo) {
                this.mLimitBoundsTo = a.getResourceId(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_rotationCenterId) {
                this.mRotationCenterId = a.getResourceId(attr2, this.mRotationCenterId);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_springDamping) {
                this.mSpringDamping = a.getFloat(attr2, this.mSpringDamping);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_springMass) {
                this.mSpringMass = a.getFloat(attr2, this.mSpringMass);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_springStiffness) {
                this.mSpringStiffness = a.getFloat(attr2, this.mSpringStiffness);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_springStopThreshold) {
                this.mSpringStopThreshold = a.getFloat(attr2, this.mSpringStopThreshold);
                continue;
            }
            if (attr2 == R.styleable.OnSwipe_springBoundary) {
                this.mSpringBoundary = a.getInt(attr2, this.mSpringBoundary);
                continue;
            }
            if (attr2 != R.styleable.OnSwipe_autoCompleteMode) continue;
            this.mAutoCompleteMode = a.getInt(attr2, this.mAutoCompleteMode);
        }
    }

    void setUpTouchEvent(float lastTouchX, float lastTouchY) {
        this.mLastTouchX = lastTouchX;
        this.mLastTouchY = lastTouchY;
        this.mDragStarted = false;
    }

    void processTouchRotateEvent(MotionEvent event, MotionLayout.MotionTracker velocityTracker, int currentState, MotionScene motionScene) {
        velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                this.mDragStarted = false;
                break;
            }
            case 2: {
                float dy = event.getRawY() - this.mLastTouchY;
                float dx = event.getRawX() - this.mLastTouchX;
                float rcx = (float)this.mMotionLayout.getWidth() / 2.0f;
                float rcy = (float)this.mMotionLayout.getHeight() / 2.0f;
                if (this.mRotationCenterId != -1) {
                    View v = this.mMotionLayout.findViewById(this.mRotationCenterId);
                    this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                    rcx = (float)this.mTempLoc[0] + (float)(v.getLeft() + v.getRight()) / 2.0f;
                    rcy = (float)this.mTempLoc[1] + (float)(v.getTop() + v.getBottom()) / 2.0f;
                } else if (this.mTouchAnchorId != -1) {
                    MotionController mc = this.mMotionLayout.getMotionController(this.mTouchAnchorId);
                    View v = this.mMotionLayout.findViewById(mc.getAnimateRelativeTo());
                    if (v == null) {
                        Log.e((String)TAG, (String)"could not find view to animate to");
                    } else {
                        this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                        rcx = (float)this.mTempLoc[0] + (float)(v.getLeft() + v.getRight()) / 2.0f;
                        rcy = (float)this.mTempLoc[1] + (float)(v.getTop() + v.getBottom()) / 2.0f;
                    }
                }
                float relativePosX = event.getRawX() - rcx;
                float relativePosY = event.getRawY() - rcy;
                double angle1 = Math.atan2(event.getRawY() - rcy, event.getRawX() - rcx);
                double angle2 = Math.atan2(this.mLastTouchY - rcy, this.mLastTouchX - rcx);
                float drag = (float)((angle1 - angle2) * 180.0 / Math.PI);
                if (drag > 330.0f) {
                    drag -= 360.0f;
                } else if (drag < -330.0f) {
                    drag += 360.0f;
                }
                if (!((double)Math.abs(drag) > 0.01) && !this.mDragStarted) break;
                float pos = this.mMotionLayout.getProgress();
                if (!this.mDragStarted) {
                    this.mDragStarted = true;
                    this.mMotionLayout.setProgress(pos);
                }
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                    this.mAnchorDpDt[1] = (float)Math.toDegrees(this.mAnchorDpDt[1]);
                } else {
                    this.mAnchorDpDt[1] = 360.0f;
                }
                float change = drag * this.mDragScale / this.mAnchorDpDt[1];
                pos = Math.max(Math.min(pos + change, 1.0f), 0.0f);
                float current = this.mMotionLayout.getProgress();
                if (pos != current) {
                    if (current == 0.0f || current == 1.0f) {
                        this.mMotionLayout.endTrigger(current == 0.0f);
                    }
                    this.mMotionLayout.setProgress(pos);
                    velocityTracker.computeCurrentVelocity(1000);
                    float tvx = velocityTracker.getXVelocity();
                    float tvy = velocityTracker.getYVelocity();
                    float angularVelocity = (float)(Math.hypot(tvy, tvx) * Math.sin(Math.atan2(tvy, tvx) - angle1) / Math.hypot(relativePosX, relativePosY));
                    this.mMotionLayout.mLastVelocity = (float)Math.toDegrees(angularVelocity);
                } else {
                    this.mMotionLayout.mLastVelocity = 0.0f;
                }
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                break;
            }
            case 1: {
                float currentPos;
                this.mDragStarted = false;
                velocityTracker.computeCurrentVelocity(16);
                float tvx = velocityTracker.getXVelocity();
                float tvy = velocityTracker.getYVelocity();
                float pos = currentPos = this.mMotionLayout.getProgress();
                float rcx = (float)this.mMotionLayout.getWidth() / 2.0f;
                float rcy = (float)this.mMotionLayout.getHeight() / 2.0f;
                if (this.mRotationCenterId != -1) {
                    View v = this.mMotionLayout.findViewById(this.mRotationCenterId);
                    this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                    rcx = (float)this.mTempLoc[0] + (float)(v.getLeft() + v.getRight()) / 2.0f;
                    rcy = (float)this.mTempLoc[1] + (float)(v.getTop() + v.getBottom()) / 2.0f;
                } else if (this.mTouchAnchorId != -1) {
                    MotionController mc = this.mMotionLayout.getMotionController(this.mTouchAnchorId);
                    View v = this.mMotionLayout.findViewById(mc.getAnimateRelativeTo());
                    this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                    rcx = (float)this.mTempLoc[0] + (float)(v.getLeft() + v.getRight()) / 2.0f;
                    rcy = (float)this.mTempLoc[1] + (float)(v.getTop() + v.getBottom()) / 2.0f;
                }
                float relativePosX = event.getRawX() - rcx;
                float relativePosY = event.getRawY() - rcy;
                double angle1 = Math.toDegrees(Math.atan2(relativePosY, relativePosX));
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                    this.mAnchorDpDt[1] = (float)Math.toDegrees(this.mAnchorDpDt[1]);
                } else {
                    this.mAnchorDpDt[1] = 360.0f;
                }
                double angle2 = Math.toDegrees(Math.atan2(tvy + relativePosY, tvx + relativePosX));
                float drag = (float)(angle2 - angle1);
                float velocity_tweek = 62.5f;
                float angularVelocity = drag * velocity_tweek;
                if (!Float.isNaN(angularVelocity)) {
                    pos += 3.0f * angularVelocity * this.mDragScale / this.mAnchorDpDt[1];
                }
                if (pos != 0.0f && pos != 1.0f && this.mOnTouchUp != 3) {
                    float target;
                    angularVelocity = angularVelocity * this.mDragScale / this.mAnchorDpDt[1];
                    float f = target = (double)pos < 0.5 ? 0.0f : 1.0f;
                    if (this.mOnTouchUp == 6) {
                        if (currentPos + angularVelocity < 0.0f) {
                            angularVelocity = Math.abs(angularVelocity);
                        }
                        target = 1.0f;
                    }
                    if (this.mOnTouchUp == 7) {
                        if (currentPos + angularVelocity > 1.0f) {
                            angularVelocity = -Math.abs(angularVelocity);
                        }
                        target = 0.0f;
                    }
                    this.mMotionLayout.touchAnimateTo(this.mOnTouchUp, target, 3.0f * angularVelocity);
                    if (!(0.0f >= currentPos) && !(1.0f <= currentPos)) break;
                    this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
                    break;
                }
                if (!(0.0f >= pos) && !(1.0f <= pos)) break;
                this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
            }
        }
    }

    void processTouchEvent(MotionEvent event, MotionLayout.MotionTracker velocityTracker, int currentState, MotionScene motionScene) {
        if (this.mIsRotateMode) {
            this.processTouchRotateEvent(event, velocityTracker, currentState, motionScene);
            return;
        }
        velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                this.mDragStarted = false;
                break;
            }
            case 2: {
                float current;
                float dy = event.getRawY() - this.mLastTouchY;
                float dx = event.getRawX() - this.mLastTouchX;
                float drag = dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
                if (!(Math.abs(drag) > this.mDragThreshold) && !this.mDragStarted) break;
                float pos = this.mMotionLayout.getProgress();
                if (!this.mDragStarted) {
                    this.mDragStarted = true;
                    this.mMotionLayout.setProgress(pos);
                }
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                } else {
                    float minSize = Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight());
                    this.mAnchorDpDt[1] = minSize * this.mTouchDirectionY;
                    this.mAnchorDpDt[0] = minSize * this.mTouchDirectionX;
                }
                float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
                movmentInDir *= this.mDragScale;
                if ((double)Math.abs(movmentInDir) < 0.01) {
                    this.mAnchorDpDt[0] = 0.01f;
                    this.mAnchorDpDt[1] = 0.01f;
                }
                float change = this.mTouchDirectionX != 0.0f ? dx / this.mAnchorDpDt[0] : dy / this.mAnchorDpDt[1];
                pos = Math.max(Math.min(pos + change, 1.0f), 0.0f);
                if (this.mOnTouchUp == 6) {
                    pos = Math.max(pos, 0.01f);
                }
                if (this.mOnTouchUp == 7) {
                    pos = Math.min(pos, 0.99f);
                }
                if (pos != (current = this.mMotionLayout.getProgress())) {
                    float velocity;
                    if (current == 0.0f || current == 1.0f) {
                        this.mMotionLayout.endTrigger(current == 0.0f);
                    }
                    this.mMotionLayout.setProgress(pos);
                    velocityTracker.computeCurrentVelocity(1000);
                    float tvx = velocityTracker.getXVelocity();
                    float tvy = velocityTracker.getYVelocity();
                    this.mMotionLayout.mLastVelocity = velocity = this.mTouchDirectionX != 0.0f ? tvx / this.mAnchorDpDt[0] : tvy / this.mAnchorDpDt[1];
                } else {
                    this.mMotionLayout.mLastVelocity = 0.0f;
                }
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                break;
            }
            case 1: {
                float currentPos;
                this.mDragStarted = false;
                velocityTracker.computeCurrentVelocity(1000);
                float tvx = velocityTracker.getXVelocity();
                float tvy = velocityTracker.getYVelocity();
                float pos = currentPos = this.mMotionLayout.getProgress();
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                } else {
                    float minSize = Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight());
                    this.mAnchorDpDt[1] = minSize * this.mTouchDirectionY;
                    this.mAnchorDpDt[0] = minSize * this.mTouchDirectionX;
                }
                float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
                float velocity = this.mTouchDirectionX != 0.0f ? tvx / this.mAnchorDpDt[0] : tvy / this.mAnchorDpDt[1];
                if (!Float.isNaN(velocity)) {
                    pos += velocity / 3.0f;
                }
                if (pos != 0.0f && pos != 1.0f && this.mOnTouchUp != 3) {
                    float target;
                    float f = target = (double)pos < 0.5 ? 0.0f : 1.0f;
                    if (this.mOnTouchUp == 6) {
                        if (currentPos + velocity < 0.0f) {
                            velocity = Math.abs(velocity);
                        }
                        target = 1.0f;
                    }
                    if (this.mOnTouchUp == 7) {
                        if (currentPos + velocity > 1.0f) {
                            velocity = -Math.abs(velocity);
                        }
                        target = 0.0f;
                    }
                    this.mMotionLayout.touchAnimateTo(this.mOnTouchUp, target, velocity);
                    if (!(0.0f >= currentPos) && !(1.0f <= currentPos)) break;
                    this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
                    break;
                }
                if (!(0.0f >= pos) && !(1.0f <= pos)) break;
                this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
            }
        }
    }

    void setDown(float lastTouchX, float lastTouchY) {
        this.mLastTouchX = lastTouchX;
        this.mLastTouchY = lastTouchY;
    }

    float getProgressDirection(float dx, float dy) {
        float velocity;
        float pos = this.mMotionLayout.getProgress();
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        if (this.mTouchDirectionX != 0.0f) {
            if (this.mAnchorDpDt[0] == 0.0f) {
                this.mAnchorDpDt[0] = 1.0E-7f;
            }
            velocity = dx * this.mTouchDirectionX / this.mAnchorDpDt[0];
        } else {
            if (this.mAnchorDpDt[1] == 0.0f) {
                this.mAnchorDpDt[1] = 1.0E-7f;
            }
            velocity = dy * this.mTouchDirectionY / this.mAnchorDpDt[1];
        }
        return velocity;
    }

    void scrollUp(float dx, float dy) {
        this.mDragStarted = false;
        float pos = this.mMotionLayout.getProgress();
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
        float velocity = this.mTouchDirectionX != 0.0f ? dx * this.mTouchDirectionX / this.mAnchorDpDt[0] : dy * this.mTouchDirectionY / this.mAnchorDpDt[1];
        if (!Float.isNaN(velocity)) {
            pos += velocity / 3.0f;
        }
        if (pos != 0.0f && pos != 1.0f & this.mOnTouchUp != 3) {
            this.mMotionLayout.touchAnimateTo(this.mOnTouchUp, (double)pos < 0.5 ? 0.0f : 1.0f, velocity);
        }
    }

    void scrollMove(float dx, float dy) {
        float change;
        float drag = dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
        float pos = this.mMotionLayout.getProgress();
        if (!this.mDragStarted) {
            this.mDragStarted = true;
            this.mMotionLayout.setProgress(pos);
        }
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
        if ((double)Math.abs(movmentInDir) < 0.01) {
            this.mAnchorDpDt[0] = 0.01f;
            this.mAnchorDpDt[1] = 0.01f;
        }
        if ((pos = Math.max(Math.min(pos + (change = this.mTouchDirectionX != 0.0f ? dx * this.mTouchDirectionX / this.mAnchorDpDt[0] : dy * this.mTouchDirectionY / this.mAnchorDpDt[1]), 1.0f), 0.0f)) != this.mMotionLayout.getProgress()) {
            this.mMotionLayout.setProgress(pos);
        }
    }

    void setupTouch() {
        View view = null;
        if (this.mTouchAnchorId != -1 && (view = this.mMotionLayout.findViewById(this.mTouchAnchorId)) == null) {
            Log.e((String)TAG, (String)("cannot find TouchAnchorId @id/" + Debug.getName(this.mMotionLayout.getContext(), this.mTouchAnchorId)));
        }
        if (view instanceof NestedScrollView) {
            NestedScrollView sv = (NestedScrollView)view;
            sv.setOnTouchListener(new View.OnTouchListener(this){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return false;
                }
            });
            sv.setOnScrollChangeListener(new NestedScrollView.OnScrollChangeListener(this){

                @Override
                public void onScrollChange(NestedScrollView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                }
            });
        }
    }

    public void setAnchorId(int id2) {
        this.mTouchAnchorId = id2;
    }

    public int getAnchorId() {
        return this.mTouchAnchorId;
    }

    public void setTouchAnchorLocation(float x, float y) {
        this.mTouchAnchorX = x;
        this.mTouchAnchorY = y;
    }

    public void setMaxVelocity(float velocity) {
        this.mMaxVelocity = velocity;
    }

    public void setMaxAcceleration(float acceleration) {
        this.mMaxAcceleration = acceleration;
    }

    float getMaxAcceleration() {
        return this.mMaxAcceleration;
    }

    public float getMaxVelocity() {
        return this.mMaxVelocity;
    }

    boolean getMoveWhenScrollAtTop() {
        return this.mMoveWhenScrollAtTop;
    }

    public int getAutoCompleteMode() {
        return this.mAutoCompleteMode;
    }

    void setAutoCompleteMode(int autoCompleteMode) {
        this.mAutoCompleteMode = autoCompleteMode;
    }

    RectF getTouchRegion(ViewGroup layout2, RectF rect) {
        if (this.mTouchRegionId == -1) {
            return null;
        }
        View view = layout2.findViewById(this.mTouchRegionId);
        if (view == null) {
            return null;
        }
        rect.set((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
        return rect;
    }

    int getTouchRegionId() {
        return this.mTouchRegionId;
    }

    RectF getLimitBoundsTo(ViewGroup layout2, RectF rect) {
        if (this.mLimitBoundsTo == -1) {
            return null;
        }
        View view = layout2.findViewById(this.mLimitBoundsTo);
        if (view == null) {
            return null;
        }
        rect.set((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
        return rect;
    }

    int getLimitBoundsToId() {
        return this.mLimitBoundsTo;
    }

    float dot(float dx, float dy) {
        return dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
    }

    public String toString() {
        return Float.isNaN(this.mTouchDirectionX) ? "rotation" : this.mTouchDirectionX + " , " + this.mTouchDirectionY;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setTouchUpMode(int touchUpMode) {
        this.mOnTouchUp = touchUpMode;
    }

    public float getSpringStiffness() {
        return this.mSpringStiffness;
    }

    public float getSpringMass() {
        return this.mSpringMass;
    }

    public float getSpringDamping() {
        return this.mSpringDamping;
    }

    public float getSpringStopThreshold() {
        return this.mSpringStopThreshold;
    }

    public int getSpringBoundary() {
        return this.mSpringBoundary;
    }

    boolean isDragStarted() {
        return this.mDragStarted;
    }
}

