/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyFrames;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.motion.widget.ViewTransitionController;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ViewTransition {
    private static String TAG = "ViewTransition";
    ConstraintSet set;
    public static final String VIEW_TRANSITION_TAG = "ViewTransition";
    public static final String KEY_FRAME_SET_TAG = "KeyFrameSet";
    public static final String CONSTRAINT_OVERRIDE = "ConstraintOverride";
    public static final String CUSTOM_ATTRIBUTE = "CustomAttribute";
    public static final String CUSTOM_METHOD = "CustomMethod";
    private static final int UNSET = -1;
    private int mId;
    public static final int ONSTATE_ACTION_DOWN = 1;
    public static final int ONSTATE_ACTION_UP = 2;
    public static final int ONSTATE_ACTION_DOWN_UP = 3;
    public static final int ONSTATE_SHARED_VALUE_SET = 4;
    public static final int ONSTATE_SHARED_VALUE_UNSET = 5;
    private int mOnStateTransition = -1;
    private boolean mDisabled = false;
    private int mPathMotionArc = 0;
    int mViewTransitionMode;
    static final int VIEWTRANSITIONMODE_CURRENTSTATE = 0;
    static final int VIEWTRANSITIONMODE_ALLSTATES = 1;
    static final int VIEWTRANSITIONMODE_NOSTATE = 2;
    KeyFrames mKeyFrames;
    ConstraintSet.Constraint mConstraintDelta;
    private int mDuration = -1;
    private int mUpDuration = -1;
    private int mTargetId;
    private String mTargetString;
    private static final int SPLINE_STRING = -1;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    private int mDefaultInterpolator = 0;
    private String mDefaultInterpolatorString = null;
    private int mDefaultInterpolatorID = -1;
    static final int EASE_IN_OUT = 0;
    static final int EASE_IN = 1;
    static final int EASE_OUT = 2;
    static final int LINEAR = 3;
    static final int BOUNCE = 4;
    static final int OVERSHOOT = 5;
    static final int ANTICIPATE = 6;
    Context mContext;
    private int mSetsTag = -1;
    private int mClearsTag = -1;
    private int mIfTagSet = -1;
    private int mIfTagNotSet = -1;
    private int mSharedValueTarget = -1;
    private int mSharedValueID = -1;
    private int mSharedValueCurrent = -1;

    public int getSharedValueCurrent() {
        return this.mSharedValueCurrent;
    }

    public void setSharedValueCurrent(int sharedValueCurrent) {
        this.mSharedValueCurrent = sharedValueCurrent;
    }

    public int getStateTransition() {
        return this.mOnStateTransition;
    }

    public void setStateTransition(int stateTransition) {
        this.mOnStateTransition = stateTransition;
    }

    public int getSharedValue() {
        return this.mSharedValueTarget;
    }

    public void setSharedValue(int sharedValue) {
        this.mSharedValueTarget = sharedValue;
    }

    public int getSharedValueID() {
        return this.mSharedValueID;
    }

    public void setSharedValueID(int sharedValueID) {
        this.mSharedValueID = sharedValueID;
    }

    public String toString() {
        return "ViewTransition(" + Debug.getName(this.mContext, this.mId) + ")";
    }

    Interpolator getInterpolator(Context context) {
        switch (this.mDefaultInterpolator) {
            case -1: {
                final Easing easing = Easing.getInterpolator(this.mDefaultInterpolatorString);
                return new Interpolator(this){

                    public float getInterpolation(float v) {
                        return (float)easing.get(v);
                    }
                };
            }
            case -2: {
                return AnimationUtils.loadInterpolator((Context)context, (int)this.mDefaultInterpolatorID);
            }
            case 0: {
                return new AccelerateDecelerateInterpolator();
            }
            case 1: {
                return new AccelerateInterpolator();
            }
            case 2: {
                return new DecelerateInterpolator();
            }
            case 3: {
                return null;
            }
            case 6: {
                return new AnticipateInterpolator();
            }
            case 5: {
                return new OvershootInterpolator();
            }
            case 4: {
                return new BounceInterpolator();
            }
        }
        return null;
    }

    ViewTransition(Context context, XmlPullParser parser) {
        this.mContext = context;
        String tagName = null;
        try {
            Object key = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                block1 : switch (eventType) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        switch (tagName = parser.getName()) {
                            case "ViewTransition": {
                                this.parseViewTransitionTags(context, parser);
                                break block1;
                            }
                            case "KeyFrameSet": {
                                this.mKeyFrames = new KeyFrames(context, parser);
                                break block1;
                            }
                            case "ConstraintOverride": {
                                this.mConstraintDelta = ConstraintSet.buildDelta(context, parser);
                                break block1;
                            }
                            case "CustomAttribute": 
                            case "CustomMethod": {
                                ConstraintAttribute.parse(context, parser, this.mConstraintDelta.mCustomConstraints);
                                break block1;
                            }
                        }
                        Log.e((String)TAG, (String)(Debug.getLoc() + " unknown tag " + tagName));
                        Log.e((String)TAG, (String)(".xml:" + parser.getLineNumber()));
                        break;
                    }
                    case 3: {
                        if (!VIEW_TRANSITION_TAG.equals(parser.getName())) break;
                        return;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseViewTransitionTags(Context context, XmlPullParser parser) {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewTransition);
        int count2 = a.getIndexCount();
        for (int i = 0; i < count2; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.ViewTransition_android_id) {
                this.mId = a.getResourceId(attr2, this.mId);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_motionTarget) {
                if (MotionLayout.IS_IN_EDIT_MODE) {
                    this.mTargetId = a.getResourceId(attr2, this.mTargetId);
                    if (this.mTargetId != -1) continue;
                    this.mTargetString = a.getString(attr2);
                    continue;
                }
                if (a.peekValue((int)attr2).type == 3) {
                    this.mTargetString = a.getString(attr2);
                    continue;
                }
                this.mTargetId = a.getResourceId(attr2, this.mTargetId);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_onStateTransition) {
                this.mOnStateTransition = a.getInt(attr2, this.mOnStateTransition);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_transitionDisable) {
                this.mDisabled = a.getBoolean(attr2, this.mDisabled);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_pathMotionArc) {
                this.mPathMotionArc = a.getInt(attr2, this.mPathMotionArc);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_duration) {
                this.mDuration = a.getInt(attr2, this.mDuration);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_upDuration) {
                this.mUpDuration = a.getInt(attr2, this.mUpDuration);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_viewTransitionMode) {
                this.mViewTransitionMode = a.getInt(attr2, this.mViewTransitionMode);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_motionInterpolator) {
                TypedValue type = a.peekValue(attr2);
                if (type.type == 1) {
                    this.mDefaultInterpolatorID = a.getResourceId(attr2, -1);
                    if (this.mDefaultInterpolatorID == -1) continue;
                    this.mDefaultInterpolator = -2;
                    continue;
                }
                if (type.type == 3) {
                    this.mDefaultInterpolatorString = a.getString(attr2);
                    if (this.mDefaultInterpolatorString != null && this.mDefaultInterpolatorString.indexOf("/") > 0) {
                        this.mDefaultInterpolatorID = a.getResourceId(attr2, -1);
                        this.mDefaultInterpolator = -2;
                        continue;
                    }
                    this.mDefaultInterpolator = -1;
                    continue;
                }
                this.mDefaultInterpolator = a.getInteger(attr2, this.mDefaultInterpolator);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_setsTag) {
                this.mSetsTag = a.getResourceId(attr2, this.mSetsTag);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_clearsTag) {
                this.mClearsTag = a.getResourceId(attr2, this.mClearsTag);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_ifTagSet) {
                this.mIfTagSet = a.getResourceId(attr2, this.mIfTagSet);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_ifTagNotSet) {
                this.mIfTagNotSet = a.getResourceId(attr2, this.mIfTagNotSet);
                continue;
            }
            if (attr2 == R.styleable.ViewTransition_SharedValueId) {
                this.mSharedValueID = a.getResourceId(attr2, this.mSharedValueID);
                continue;
            }
            if (attr2 != R.styleable.ViewTransition_SharedValue) continue;
            this.mSharedValueTarget = a.getInteger(attr2, this.mSharedValueTarget);
        }
        a.recycle();
    }

    void applyIndependentTransition(ViewTransitionController controller, MotionLayout motionLayout, View view) {
        MotionController motionController = new MotionController(view);
        motionController.setBothStates(view);
        this.mKeyFrames.addAllFrames(motionController);
        motionController.setup(motionLayout.getWidth(), motionLayout.getHeight(), this.mDuration, System.nanoTime());
        new Animate(controller, motionController, this.mDuration, this.mUpDuration, this.mOnStateTransition, this.getInterpolator(motionLayout.getContext()), this.mSetsTag, this.mClearsTag);
    }

    void applyTransition(ViewTransitionController controller, MotionLayout layout2, int fromId, ConstraintSet current, View ... views) {
        if (this.mDisabled) {
            return;
        }
        if (this.mViewTransitionMode == 2) {
            this.applyIndependentTransition(controller, layout2, views[0]);
            return;
        }
        if (this.mViewTransitionMode == 1) {
            int[] ids = layout2.getConstraintSetIds();
            for (int i = 0; i < ids.length; ++i) {
                int id2 = ids[i];
                if (id2 == fromId) continue;
                ConstraintSet cSet = layout2.getConstraintSet(id2);
                for (View view : views) {
                    ConstraintSet.Constraint constraint = cSet.getConstraint(view.getId());
                    if (this.mConstraintDelta == null) continue;
                    this.mConstraintDelta.applyDelta(constraint);
                    constraint.mCustomConstraints.putAll(this.mConstraintDelta.mCustomConstraints);
                }
            }
        }
        ConstraintSet transformedState = new ConstraintSet();
        transformedState.clone(current);
        for (View view : views) {
            ConstraintSet.Constraint constraint = transformedState.getConstraint(view.getId());
            if (this.mConstraintDelta == null) continue;
            this.mConstraintDelta.applyDelta(constraint);
            constraint.mCustomConstraints.putAll(this.mConstraintDelta.mCustomConstraints);
        }
        layout2.updateState(fromId, transformedState);
        layout2.updateState(R.id.view_transition, current);
        layout2.setState(R.id.view_transition, -1, -1);
        MotionScene.Transition tmpTransition = new MotionScene.Transition(-1, layout2.mScene, R.id.view_transition, fromId);
        for (View view : views) {
            this.updateTransition(tmpTransition, view);
        }
        layout2.setTransition(tmpTransition);
        layout2.transitionToEnd(() -> {
            if (this.mSetsTag != -1) {
                for (View view : views) {
                    view.setTag(this.mSetsTag, (Object)System.nanoTime());
                }
            }
            if (this.mClearsTag != -1) {
                for (View view : views) {
                    view.setTag(this.mClearsTag, null);
                }
            }
        });
    }

    private void updateTransition(MotionScene.Transition transition, View view) {
        if (this.mDuration != -1) {
            transition.setDuration(this.mDuration);
        }
        transition.setPathMotionArc(this.mPathMotionArc);
        transition.setInterpolatorInfo(this.mDefaultInterpolator, this.mDefaultInterpolatorString, this.mDefaultInterpolatorID);
        int id2 = view.getId();
        if (this.mKeyFrames != null) {
            ArrayList<Key> keys2 = this.mKeyFrames.getKeyFramesForView(-1);
            KeyFrames keyFrames = new KeyFrames();
            for (Key key : keys2) {
                keyFrames.addKey(key.clone().setViewId(id2));
            }
            transition.addKeyFrame(keyFrames);
        }
    }

    int getId() {
        return this.mId;
    }

    void setId(int id2) {
        this.mId = id2;
    }

    boolean matchesView(View view) {
        String tag;
        if (view == null) {
            return false;
        }
        if (this.mTargetId == -1 && this.mTargetString == null) {
            return false;
        }
        if (!this.checkTags(view)) {
            return false;
        }
        if (view.getId() == this.mTargetId) {
            return true;
        }
        if (this.mTargetString == null) {
            return false;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        return lp instanceof ConstraintLayout.LayoutParams && (tag = ((ConstraintLayout.LayoutParams)view.getLayoutParams()).constraintTag) != null && tag.matches(this.mTargetString);
    }

    boolean supports(int action) {
        if (this.mOnStateTransition == 1) {
            return action == 0;
        }
        if (this.mOnStateTransition == 2) {
            return action == 1;
        }
        if (this.mOnStateTransition == 3) {
            return action == 0;
        }
        return false;
    }

    boolean isEnabled() {
        return !this.mDisabled;
    }

    void setEnabled(boolean enable) {
        this.mDisabled = !enable;
    }

    boolean checkTags(View view) {
        boolean set;
        boolean bl = this.mIfTagSet == -1 ? true : (set = null != view.getTag(this.mIfTagSet));
        boolean notSet = this.mIfTagNotSet == -1 ? true : null == view.getTag(this.mIfTagNotSet);
        return set && notSet;
    }

    static class Animate {
        private final int mSetsTag;
        private final int mClearsTag;
        long mStart;
        MotionController mMC;
        int mDuration;
        int mUpDuration;
        KeyCache mCache = new KeyCache();
        ViewTransitionController mVtController;
        Interpolator mInterpolator;
        boolean reverse = false;
        float mPosition;
        float mDpositionDt;
        long mLastRender;
        Rect mTempRec = new Rect();
        boolean hold_at_100 = false;

        Animate(ViewTransitionController controller, MotionController motionController, int duration, int upDuration, int mode, Interpolator interpolator2, int setTag, int clearTag) {
            this.mVtController = controller;
            this.mMC = motionController;
            this.mDuration = duration;
            this.mUpDuration = upDuration;
            this.mLastRender = this.mStart = System.nanoTime();
            this.mVtController.addAnimation(this);
            this.mInterpolator = interpolator2;
            this.mSetsTag = setTag;
            this.mClearsTag = clearTag;
            if (mode == 3) {
                this.hold_at_100 = true;
            }
            this.mDpositionDt = duration == 0 ? Float.MAX_VALUE : 1.0f / (float)duration;
            this.mutate();
        }

        void reverse(boolean dir) {
            this.reverse = dir;
            if (this.reverse && this.mUpDuration != -1) {
                this.mDpositionDt = this.mUpDuration == 0 ? Float.MAX_VALUE : 1.0f / (float)this.mUpDuration;
            }
            this.mVtController.invalidate();
            this.mLastRender = System.nanoTime();
        }

        void mutate() {
            if (this.reverse) {
                this.mutateReverse();
            } else {
                this.mutateForward();
            }
        }

        void mutateReverse() {
            long current = System.nanoTime();
            long elapse = current - this.mLastRender;
            this.mLastRender = current;
            this.mPosition -= (float)((double)elapse * 1.0E-6) * this.mDpositionDt;
            if (this.mPosition < 0.0f) {
                this.mPosition = 0.0f;
            }
            float ipos = this.mInterpolator == null ? this.mPosition : this.mInterpolator.getInterpolation(this.mPosition);
            boolean repaint = this.mMC.interpolate(this.mMC.mView, ipos, current, this.mCache);
            if (this.mPosition <= 0.0f) {
                if (this.mSetsTag != -1) {
                    this.mMC.getView().setTag(this.mSetsTag, (Object)System.nanoTime());
                }
                if (this.mClearsTag != -1) {
                    this.mMC.getView().setTag(this.mClearsTag, null);
                }
                this.mVtController.removeAnimation(this);
            }
            if (this.mPosition > 0.0f || repaint) {
                this.mVtController.invalidate();
            }
        }

        void mutateForward() {
            long current = System.nanoTime();
            long elapse = current - this.mLastRender;
            this.mLastRender = current;
            this.mPosition += (float)((double)elapse * 1.0E-6) * this.mDpositionDt;
            if (this.mPosition >= 1.0f) {
                this.mPosition = 1.0f;
            }
            float ipos = this.mInterpolator == null ? this.mPosition : this.mInterpolator.getInterpolation(this.mPosition);
            boolean repaint = this.mMC.interpolate(this.mMC.mView, ipos, current, this.mCache);
            if (this.mPosition >= 1.0f) {
                if (this.mSetsTag != -1) {
                    this.mMC.getView().setTag(this.mSetsTag, (Object)System.nanoTime());
                }
                if (this.mClearsTag != -1) {
                    this.mMC.getView().setTag(this.mClearsTag, null);
                }
                if (!this.hold_at_100) {
                    this.mVtController.removeAnimation(this);
                }
            }
            if (this.mPosition < 1.0f || repaint) {
                this.mVtController.invalidate();
            }
        }

        public void reactTo(int action, float x, float y) {
            switch (action) {
                case 1: {
                    if (!this.reverse) {
                        this.reverse(true);
                    }
                    return;
                }
                case 2: {
                    View view = this.mMC.getView();
                    view.getHitRect(this.mTempRec);
                    if (this.mTempRec.contains((int)x, (int)y) || this.reverse) break;
                    this.reverse(true);
                }
            }
        }
    }
}

