/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.util.SparseIntArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SharedValues {
    public static final int UNSET = -1;
    private SparseIntArray mValues = new SparseIntArray();
    private HashMap<Integer, HashSet<WeakReference<SharedValuesListener>>> mValuesListeners = new HashMap();

    public void addListener(int key, SharedValuesListener listener2) {
        HashSet<WeakReference<SharedValuesListener>> listeners = this.mValuesListeners.get(key);
        if (listeners == null) {
            listeners = new HashSet();
            this.mValuesListeners.put(key, listeners);
        }
        listeners.add(new WeakReference<SharedValuesListener>(listener2));
    }

    public void removeListener(int key, SharedValuesListener listener2) {
        HashSet<WeakReference<SharedValuesListener>> listeners = this.mValuesListeners.get(key);
        if (listeners == null) {
            return;
        }
        ArrayList<WeakReference<SharedValuesListener>> toRemove = new ArrayList<WeakReference<SharedValuesListener>>();
        for (WeakReference<SharedValuesListener> listenerWeakReference : listeners) {
            SharedValuesListener l = (SharedValuesListener)listenerWeakReference.get();
            if (l != null && l != listener2) continue;
            toRemove.add(listenerWeakReference);
        }
        listeners.removeAll(toRemove);
    }

    public void removeListener(SharedValuesListener listener2) {
        for (Integer key : this.mValuesListeners.keySet()) {
            this.removeListener(key, listener2);
        }
    }

    public void clearListeners() {
        this.mValuesListeners.clear();
    }

    public int getValue(int key) {
        return this.mValues.get(key, -1);
    }

    public void fireNewValue(int key, int value) {
        boolean needsCleanup = false;
        int previousValue = this.mValues.get(key, -1);
        if (previousValue == value) {
            return;
        }
        this.mValues.put(key, value);
        HashSet<WeakReference<SharedValuesListener>> listeners = this.mValuesListeners.get(key);
        if (listeners == null) {
            return;
        }
        for (WeakReference<SharedValuesListener> listenerWeakReference : listeners) {
            SharedValuesListener l = (SharedValuesListener)listenerWeakReference.get();
            if (l != null) {
                l.onNewValue(key, value, previousValue);
                continue;
            }
            needsCleanup = true;
        }
        if (needsCleanup) {
            ArrayList<WeakReference<SharedValuesListener>> toRemove = new ArrayList<WeakReference<SharedValuesListener>>();
            for (WeakReference<SharedValuesListener> listenerWeakReference : listeners) {
                SharedValuesListener listener2 = (SharedValuesListener)listenerWeakReference.get();
                if (listener2 != null) continue;
                toRemove.add(listenerWeakReference);
            }
            listeners.removeAll(toRemove);
        }
    }

    public static interface SharedValuesListener {
        public void onNewValue(int var1, int var2, int var3);
    }
}

