/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Dialog;
import android.os.Build;
import android.view.View;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;

public class DialogCompat {
    private DialogCompat() {
    }

    @NonNull
    public static View requireViewById(@NonNull Dialog dialog, int id2) {
        if (Build.VERSION.SDK_INT >= 28) {
            return (View)Api28Impl.requireViewById(dialog, id2);
        }
        View view = dialog.findViewById(id2);
        if (view == null) {
            throw new IllegalArgumentException("ID does not reference a View inside this Dialog");
        }
        return view;
    }

    @RequiresApi(value=28)
    static class Api28Impl {
        private Api28Impl() {
        }

        @DoNotInline
        static <T> T requireViewById(Dialog dialog, int id2) {
            return (T)dialog.requireViewById(id2);
        }
    }
}

