/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Notification;
import android.app.Service;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ServiceCompat {
    public static final int START_STICKY = 1;
    public static final int STOP_FOREGROUND_REMOVE = 1;
    public static final int STOP_FOREGROUND_DETACH = 2;
    private static final int FOREGROUND_SERVICE_TYPE_ALLOWED_SINCE_Q = 255;
    private static final int FOREGROUND_SERVICE_TYPE_ALLOWED_SINCE_U = 0x40000FFF;

    private ServiceCompat() {
    }

    public static void startForeground(@NonNull Service service, int id2, @NonNull Notification notification, int foregroundServiceType) {
        if (Build.VERSION.SDK_INT >= 34) {
            Api34Impl.startForeground(service, id2, notification, foregroundServiceType);
        } else if (Build.VERSION.SDK_INT >= 29) {
            Api29Impl.startForeground(service, id2, notification, foregroundServiceType);
        } else {
            service.startForeground(id2, notification);
        }
    }

    public static void stopForeground(@NonNull Service service, int flags) {
        if (Build.VERSION.SDK_INT >= 24) {
            Api24Impl.stopForeground(service, flags);
        } else {
            service.stopForeground((flags & 1) != 0);
        }
    }

    @RequiresApi(value=34)
    static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        static void startForeground(Service service, int id2, Notification notification, int foregroundServiceType) {
            if (foregroundServiceType == 0 || foregroundServiceType == -1) {
                service.startForeground(id2, notification, foregroundServiceType);
            } else {
                service.startForeground(id2, notification, foregroundServiceType & 0x40000FFF);
            }
        }
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static void startForeground(Service service, int id2, Notification notification, int foregroundServiceType) {
            if (foregroundServiceType == 0 || foregroundServiceType == -1) {
                service.startForeground(id2, notification, foregroundServiceType);
            } else {
                service.startForeground(id2, notification, foregroundServiceType & 0xFF);
            }
        }
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static void stopForeground(Service service, int flags) {
            service.stopForeground(flags);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface StopForegroundFlags {
    }
}

