/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.core.content.UnusedAppRestrictionsBackportServiceConnection;
import androidx.core.os.UserManagerCompat;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executors;

public final class PackageManagerCompat {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String LOG_TAG = "PackageManagerCompat";
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_PERMISSION_REVOCATION_SETTINGS = "android.intent.action.AUTO_REVOKE_PERMISSIONS";

    private PackageManagerCompat() {
    }

    @NonNull
    public static ListenableFuture<Integer> getUnusedAppRestrictionsStatus(@NonNull Context context) {
        ResolvableFuture<Integer> resultFuture = ResolvableFuture.create();
        if (!UserManagerCompat.isUserUnlocked(context)) {
            resultFuture.set(0);
            Log.e((String)LOG_TAG, (String)"User is in locked direct boot mode");
            return resultFuture;
        }
        if (!PackageManagerCompat.areUnusedAppRestrictionsAvailable(context.getPackageManager())) {
            resultFuture.set(1);
            return resultFuture;
        }
        int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion < 30) {
            resultFuture.set(0);
            Log.e((String)LOG_TAG, (String)"Target SDK version below API 30");
            return resultFuture;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            if (Api30Impl.areUnusedAppRestrictionsEnabled(context)) {
                resultFuture.set(targetSdkVersion >= 31 ? 5 : 4);
            } else {
                resultFuture.set(2);
            }
            return resultFuture;
        }
        if (Build.VERSION.SDK_INT == 30) {
            resultFuture.set(Api30Impl.areUnusedAppRestrictionsEnabled(context) ? 4 : 2);
            return resultFuture;
        }
        UnusedAppRestrictionsBackportServiceConnection backportServiceConnection = new UnusedAppRestrictionsBackportServiceConnection(context);
        resultFuture.addListener(backportServiceConnection::disconnectFromService, Executors.newSingleThreadExecutor());
        backportServiceConnection.connectAndFetchResult(resultFuture);
        return resultFuture;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static boolean areUnusedAppRestrictionsAvailable(@NonNull PackageManager packageManager) {
        boolean restrictionsBuiltIntoOs = Build.VERSION.SDK_INT >= 30;
        boolean isOsMThroughQ = Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 30;
        boolean hasBackportFeature = PackageManagerCompat.getPermissionRevocationVerifierApp(packageManager) != null;
        return restrictionsBuiltIntoOs || isOsMThroughQ && hasBackportFeature;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static String getPermissionRevocationVerifierApp(@NonNull PackageManager packageManager) {
        Intent permissionRevocationSettingsIntent = new Intent(ACTION_PERMISSION_REVOCATION_SETTINGS).setData(Uri.fromParts((String)"package", (String)"com.example", null));
        List intentResolvers = packageManager.queryIntentActivities(permissionRevocationSettingsIntent, 0);
        String verifierPackageName = null;
        for (ResolveInfo intentResolver : intentResolvers) {
            String packageName = intentResolver.activityInfo.packageName;
            if (packageManager.checkPermission("android.permission.PACKAGE_VERIFICATION_AGENT", packageName) != 0) continue;
            if (verifierPackageName != null) {
                return verifierPackageName;
            }
            verifierPackageName = packageName;
        }
        return verifierPackageName;
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        static boolean areUnusedAppRestrictionsEnabled(@NonNull Context context) {
            return !context.getPackageManager().isAutoRevokeWhitelisted();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface UnusedAppRestrictionsStatus {
    }
}

