/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.pm;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ShortcutXmlParser {
    private static final String TAG = "ShortcutXmlParser";
    private static final String META_DATA_APP_SHORTCUTS = "android.app.shortcuts";
    private static final String TAG_SHORTCUT = "shortcut";
    private static final String ATTR_SHORTCUT_ID = "shortcutId";
    private static volatile ArrayList<String> sShortcutIds;
    private static final Object GET_INSTANCE_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NonNull
    public static List<String> getShortcutIds(@NonNull Context context) {
        if (sShortcutIds == null) {
            Object object = GET_INSTANCE_LOCK;
            synchronized (object) {
                if (sShortcutIds == null) {
                    sShortcutIds = new ArrayList();
                    sShortcutIds.addAll(ShortcutXmlParser.parseShortcutIds(context));
                }
            }
        }
        return sShortcutIds;
    }

    private ShortcutXmlParser() {
    }

    @NonNull
    private static Set<String> parseShortcutIds(@NonNull Context context) {
        HashSet<String> result2 = new HashSet<String>();
        Intent mainIntent = new Intent("android.intent.action.MAIN");
        mainIntent.addCategory("android.intent.category.LAUNCHER");
        mainIntent.setPackage(context.getPackageName());
        List resolveInfos = context.getPackageManager().queryIntentActivities(mainIntent, 128);
        if (resolveInfos == null || resolveInfos.size() == 0) {
            return result2;
        }
        try {
            for (ResolveInfo info : resolveInfos) {
                ActivityInfo activityInfo = info.activityInfo;
                Bundle metaData = activityInfo.metaData;
                if (metaData == null || !metaData.containsKey(META_DATA_APP_SHORTCUTS)) continue;
                XmlResourceParser parser = ShortcutXmlParser.getXmlResourceParser(context, activityInfo);
                try {
                    result2.addAll(ShortcutXmlParser.parseShortcutIds((XmlPullParser)parser));
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to parse the Xml resource: ", (Throwable)e);
        }
        return result2;
    }

    @NonNull
    private static XmlResourceParser getXmlResourceParser(Context context, ActivityInfo info) {
        XmlResourceParser parser = info.loadXmlMetaData(context.getPackageManager(), META_DATA_APP_SHORTCUTS);
        if (parser == null) {
            throw new IllegalArgumentException("Failed to open android.app.shortcuts meta-data resource of " + info.name);
        }
        return parser;
    }

    @VisibleForTesting
    @NonNull
    public static List<String> parseShortcutIds(@NonNull XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        ArrayList<String> result2 = new ArrayList<String>(1);
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > 0)) {
            String shortcutId;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (type != 2 || depth != 2 || !TAG_SHORTCUT.equals(tag) || (shortcutId = ShortcutXmlParser.getAttributeValue(parser, ATTR_SHORTCUT_ID)) == null) continue;
            result2.add(shortcutId);
        }
        return result2;
    }

    private static String getAttributeValue(XmlPullParser parser, String attribute) {
        String value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", attribute);
        if (value == null) {
            value = parser.getAttributeValue(null, attribute);
        }
        return value;
    }

    static {
        GET_INSTANCE_LOCK = new Object();
    }
}

