/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LruCache;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.TypefaceCompatApi21Impl;
import androidx.core.graphics.TypefaceCompatApi24Impl;
import androidx.core.graphics.TypefaceCompatApi26Impl;
import androidx.core.graphics.TypefaceCompatApi28Impl;
import androidx.core.graphics.TypefaceCompatApi29Impl;
import androidx.core.graphics.TypefaceCompatBaseImpl;
import androidx.core.provider.FontsContractCompat;
import androidx.core.util.Preconditions;

public class TypefaceCompat {
    private static final TypefaceCompatBaseImpl sTypefaceCompatImpl = Build.VERSION.SDK_INT >= 29 ? new TypefaceCompatApi29Impl() : (Build.VERSION.SDK_INT >= 28 ? new TypefaceCompatApi28Impl() : (Build.VERSION.SDK_INT >= 26 ? new TypefaceCompatApi26Impl() : (Build.VERSION.SDK_INT >= 24 && TypefaceCompatApi24Impl.isUsable() ? new TypefaceCompatApi24Impl() : (Build.VERSION.SDK_INT >= 21 ? new TypefaceCompatApi21Impl() : new TypefaceCompatBaseImpl()))));
    private static final LruCache<String, Typeface> sTypefaceCache = new LruCache(16);

    private TypefaceCompat() {
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static Typeface findFromCache(@NonNull Resources resources, int id2, @Nullable String path2, int cookie, int style2) {
        return sTypefaceCache.get(TypefaceCompat.createResourceUid(resources, id2, path2, cookie, style2));
    }

    @Deprecated
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface findFromCache(@NonNull Resources resources, int id2, int style2) {
        return TypefaceCompat.findFromCache(resources, id2, null, 0, style2);
    }

    private static String createResourceUid(Resources resources, int id2, String path2, int cookie, int style2) {
        return resources.getResourcePackageName(id2) + '-' + path2 + '-' + cookie + '-' + id2 + '-' + style2;
    }

    private static Typeface getSystemFontFamily(@Nullable String familyName) {
        if (familyName == null || familyName.isEmpty()) {
            return null;
        }
        Typeface typeface = Typeface.create((String)familyName, (int)0);
        Typeface defaultTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
        return typeface != null && !typeface.equals((Object)defaultTypeface) ? typeface : null;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static Typeface createFromResourcesFamilyXml(@NonNull Context context, @NonNull FontResourcesParserCompat.FamilyResourceEntry entry, @NonNull Resources resources, int id2, @Nullable String path2, int cookie, int style2, @Nullable ResourcesCompat.FontCallback fontCallback, @Nullable Handler handler, boolean isRequestFromLayoutInflator) {
        Typeface typeface;
        if (entry instanceof FontResourcesParserCompat.ProviderResourceEntry) {
            FontResourcesParserCompat.ProviderResourceEntry providerEntry = (FontResourcesParserCompat.ProviderResourceEntry)entry;
            Typeface fontFamilyTypeface = TypefaceCompat.getSystemFontFamily(providerEntry.getSystemFontFamilyName());
            if (fontFamilyTypeface != null) {
                if (fontCallback != null) {
                    fontCallback.callbackSuccessAsync(fontFamilyTypeface, handler);
                }
                return fontFamilyTypeface;
            }
            boolean isBlocking = isRequestFromLayoutInflator ? providerEntry.getFetchStrategy() == 0 : fontCallback == null;
            int timeout = isRequestFromLayoutInflator ? providerEntry.getTimeout() : -1;
            Handler newHandler = ResourcesCompat.FontCallback.getHandler(handler);
            ResourcesCallbackAdapter newCallback = new ResourcesCallbackAdapter(fontCallback);
            typeface = FontsContractCompat.requestFont(context, providerEntry.getRequest(), style2, isBlocking, timeout, newHandler, newCallback);
        } else {
            typeface = sTypefaceCompatImpl.createFromFontFamilyFilesResourceEntry(context, (FontResourcesParserCompat.FontFamilyFilesResourceEntry)entry, resources, style2);
            if (fontCallback != null) {
                if (typeface != null) {
                    fontCallback.callbackSuccessAsync(typeface, handler);
                } else {
                    fontCallback.callbackFailAsync(-3, handler);
                }
            }
        }
        if (typeface != null) {
            sTypefaceCache.put(TypefaceCompat.createResourceUid(resources, id2, path2, cookie, style2), typeface);
        }
        return typeface;
    }

    @Deprecated
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface createFromResourcesFamilyXml(@NonNull Context context, @NonNull FontResourcesParserCompat.FamilyResourceEntry entry, @NonNull Resources resources, int id2, int style2, @Nullable ResourcesCompat.FontCallback fontCallback, @Nullable Handler handler, boolean isRequestFromLayoutInflator) {
        return TypefaceCompat.createFromResourcesFamilyXml(context, entry, resources, id2, null, 0, style2, fontCallback, handler, isRequestFromLayoutInflator);
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static Typeface createFromResourcesFontFile(@NonNull Context context, @NonNull Resources resources, int id2, String path2, int cookie, int style2) {
        Typeface typeface = sTypefaceCompatImpl.createFromResourcesFontFile(context, resources, id2, path2, style2);
        if (typeface != null) {
            String resourceUid = TypefaceCompat.createResourceUid(resources, id2, path2, cookie, style2);
            sTypefaceCache.put(resourceUid, typeface);
        }
        return typeface;
    }

    @Deprecated
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface createFromResourcesFontFile(@NonNull Context context, @NonNull Resources resources, int id2, String path2, int style2) {
        return TypefaceCompat.createFromResourcesFontFile(context, resources, id2, path2, 0, style2);
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static Typeface createFromFontInfo(@NonNull Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, int style2) {
        return sTypefaceCompatImpl.createFromFontInfo(context, cancellationSignal, fonts, style2);
    }

    @Nullable
    private static Typeface getBestFontFromFamily(Context context, Typeface typeface, int style2) {
        FontResourcesParserCompat.FontFamilyFilesResourceEntry families = sTypefaceCompatImpl.getFontFamily(typeface);
        if (families == null) {
            return null;
        }
        return sTypefaceCompatImpl.createFromFontFamilyFilesResourceEntry(context, families, context.getResources(), style2);
    }

    @NonNull
    public static Typeface create(@NonNull Context context, @Nullable Typeface family, int style2) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        Typeface typefaceFromFamily = null;
        if (Build.VERSION.SDK_INT < 21 && (typefaceFromFamily = TypefaceCompat.getBestFontFromFamily(context, family, style2)) != null) {
            return typefaceFromFamily;
        }
        return Typeface.create((Typeface)family, (int)style2);
    }

    @NonNull
    public static Typeface create(@NonNull Context context, @Nullable Typeface family, @IntRange(from=1L, to=1000L) int weight, boolean italic) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        Preconditions.checkArgumentInRange(weight, 1, 1000, "weight");
        if (family == null) {
            family = Typeface.DEFAULT;
        }
        return sTypefaceCompatImpl.createWeightStyle(context, family, weight, italic);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @VisibleForTesting
    public static void clearCache() {
        sTypefaceCache.evictAll();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class ResourcesCallbackAdapter
    extends FontsContractCompat.FontRequestCallback {
        @Nullable
        private ResourcesCompat.FontCallback mFontCallback;

        public ResourcesCallbackAdapter(@Nullable ResourcesCompat.FontCallback fontCallback) {
            this.mFontCallback = fontCallback;
        }

        @Override
        public void onTypefaceRetrieved(@NonNull Typeface typeface) {
            if (this.mFontCallback != null) {
                this.mFontCallback.onFontRetrieved(typeface);
            }
        }

        @Override
        public void onTypefaceRequestFailed(int reason) {
            if (this.mFontCallback != null) {
                this.mFontCallback.onFontRetrievalFailed(reason);
            }
        }
    }
}

