/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.CancellationSignal;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.SimpleArrayMap;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompatBaseImpl;
import androidx.core.graphics.TypefaceCompatUtil;
import androidx.core.graphics.WeightTypefaceApi21;
import androidx.core.provider.FontsContractCompat;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@RequiresApi(value=24)
class TypefaceCompatApi24Impl
extends TypefaceCompatBaseImpl {
    private static final String TAG = "TypefaceCompatApi24Impl";
    private static final String FONT_FAMILY_CLASS = "android.graphics.FontFamily";
    private static final String ADD_FONT_WEIGHT_STYLE_METHOD = "addFontWeightStyle";
    private static final String CREATE_FROM_FAMILIES_WITH_DEFAULT_METHOD = "createFromFamiliesWithDefault";
    private static final Class<?> sFontFamily;
    private static final Constructor<?> sFontFamilyCtor;
    private static final Method sAddFontWeightStyle;
    private static final Method sCreateFromFamiliesWithDefault;

    TypefaceCompatApi24Impl() {
    }

    public static boolean isUsable() {
        if (sAddFontWeightStyle == null) {
            Log.w((String)TAG, (String)"Unable to collect necessary private methods.Fallback to legacy implementation.");
        }
        return sAddFontWeightStyle != null;
    }

    private static Object newFamily() {
        try {
            return sFontFamilyCtor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    private static boolean addFontWeightStyle(Object family, ByteBuffer buffer, int ttcIndex, int weight, boolean style2) {
        try {
            Boolean result2 = (Boolean)sAddFontWeightStyle.invoke(family, buffer, ttcIndex, null, weight, style2);
            return result2;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    private static Typeface createFromFamiliesWithDefault(Object family) {
        try {
            Object familyArray = Array.newInstance(sFontFamily, 1);
            Array.set(familyArray, 0, family);
            return (Typeface)sCreateFromFamiliesWithDefault.invoke(null, familyArray);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public Typeface createFromFontInfo(Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, int style2) {
        Object family = TypefaceCompatApi24Impl.newFamily();
        if (family == null) {
            return null;
        }
        SimpleArrayMap<Uri, ByteBuffer> bufferCache = new SimpleArrayMap<Uri, ByteBuffer>();
        for (FontsContractCompat.FontInfo font : fonts) {
            Uri uri = font.getUri();
            ByteBuffer buffer = (ByteBuffer)bufferCache.get(uri);
            if (buffer == null) {
                buffer = TypefaceCompatUtil.mmap(context, cancellationSignal, uri);
                bufferCache.put(uri, buffer);
            }
            if (buffer == null) {
                return null;
            }
            if (TypefaceCompatApi24Impl.addFontWeightStyle(family, buffer, font.getTtcIndex(), font.getWeight(), font.isItalic())) continue;
            return null;
        }
        Typeface typeface = TypefaceCompatApi24Impl.createFromFamiliesWithDefault(family);
        if (typeface == null) {
            return null;
        }
        return Typeface.create((Typeface)typeface, (int)style2);
    }

    @Override
    @Nullable
    public Typeface createFromFontFamilyFilesResourceEntry(Context context, FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, Resources resources, int style2) {
        Object family = TypefaceCompatApi24Impl.newFamily();
        if (family == null) {
            return null;
        }
        for (FontResourcesParserCompat.FontFileResourceEntry e : entry.getEntries()) {
            ByteBuffer buffer = TypefaceCompatUtil.copyToDirectBuffer(context, resources, e.getResourceId());
            if (buffer == null) {
                return null;
            }
            if (TypefaceCompatApi24Impl.addFontWeightStyle(family, buffer, e.getTtcIndex(), e.getWeight(), e.isItalic())) continue;
            return null;
        }
        return TypefaceCompatApi24Impl.createFromFamiliesWithDefault(family);
    }

    @Override
    @NonNull
    Typeface createWeightStyle(@NonNull Context context, @NonNull Typeface base, int weight, boolean italic) {
        Typeface out = null;
        try {
            out = WeightTypefaceApi21.createWeightStyle(base, weight, italic);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (out == null) {
            out = super.createWeightStyle(context, base, weight, italic);
        }
        return out;
    }

    static {
        Method createFromFamiliesWithDefaultMethod;
        Method addFontMethod;
        Constructor<?> fontFamilyCtor;
        Class<?> fontFamilyClass;
        try {
            fontFamilyClass = Class.forName(FONT_FAMILY_CLASS);
            fontFamilyCtor = fontFamilyClass.getConstructor(new Class[0]);
            addFontMethod = fontFamilyClass.getMethod(ADD_FONT_WEIGHT_STYLE_METHOD, ByteBuffer.class, Integer.TYPE, List.class, Integer.TYPE, Boolean.TYPE);
            Object familyArray = Array.newInstance(fontFamilyClass, 1);
            createFromFamiliesWithDefaultMethod = Typeface.class.getMethod(CREATE_FROM_FAMILIES_WITH_DEFAULT_METHOD, familyArray.getClass());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Log.e((String)TAG, (String)e.getClass().getName(), (Throwable)e);
            fontFamilyClass = null;
            fontFamilyCtor = null;
            addFontMethod = null;
            createFromFamiliesWithDefaultMethod = null;
        }
        sFontFamilyCtor = fontFamilyCtor;
        sFontFamily = fontFamilyClass;
        sAddFontWeightStyle = addFontMethod;
        sCreateFromFamiliesWithDefault = createFromFamiliesWithDefaultMethod;
    }
}

