/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.annotation.SuppressLint;
import android.location.LocationRequest;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.core.util.TimeUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class LocationRequestCompat {
    public static final long PASSIVE_INTERVAL = Long.MAX_VALUE;
    public static final int QUALITY_HIGH_ACCURACY = 100;
    public static final int QUALITY_BALANCED_POWER_ACCURACY = 102;
    public static final int QUALITY_LOW_POWER = 104;
    private static final long IMPLICIT_MIN_UPDATE_INTERVAL = -1L;
    final int mQuality;
    final long mIntervalMillis;
    final long mMinUpdateIntervalMillis;
    final long mDurationMillis;
    final int mMaxUpdates;
    final float mMinUpdateDistanceMeters;
    final long mMaxUpdateDelayMillis;

    LocationRequestCompat(long intervalMillis, int quality, long durationMillis, int maxUpdates, long minUpdateIntervalMillis, float minUpdateDistanceMeters, long maxUpdateDelayMillis) {
        this.mIntervalMillis = intervalMillis;
        this.mQuality = quality;
        this.mMinUpdateIntervalMillis = minUpdateIntervalMillis;
        this.mDurationMillis = durationMillis;
        this.mMaxUpdates = maxUpdates;
        this.mMinUpdateDistanceMeters = minUpdateDistanceMeters;
        this.mMaxUpdateDelayMillis = maxUpdateDelayMillis;
    }

    public int getQuality() {
        return this.mQuality;
    }

    @IntRange(from=0L)
    public long getIntervalMillis() {
        return this.mIntervalMillis;
    }

    @IntRange(from=0L)
    public long getMinUpdateIntervalMillis() {
        if (this.mMinUpdateIntervalMillis == -1L) {
            return this.mIntervalMillis;
        }
        return this.mMinUpdateIntervalMillis;
    }

    @IntRange(from=1L)
    public long getDurationMillis() {
        return this.mDurationMillis;
    }

    @IntRange(from=1L, to=0x7FFFFFFFL)
    public int getMaxUpdates() {
        return this.mMaxUpdates;
    }

    @FloatRange(from=0.0, to=3.4028234663852886E38)
    public float getMinUpdateDistanceMeters() {
        return this.mMinUpdateDistanceMeters;
    }

    @IntRange(from=0L)
    public long getMaxUpdateDelayMillis() {
        return this.mMaxUpdateDelayMillis;
    }

    @RequiresApi(value=31)
    @NonNull
    public LocationRequest toLocationRequest() {
        return Api31Impl.toLocationRequest(this);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public LocationRequest toLocationRequest(@NonNull String provider) {
        if (Build.VERSION.SDK_INT >= 31) {
            return this.toLocationRequest();
        }
        return (LocationRequest)Api19Impl.toLocationRequest(this, provider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationRequestCompat)) {
            return false;
        }
        LocationRequestCompat that = (LocationRequestCompat)o;
        return this.mQuality == that.mQuality && this.mIntervalMillis == that.mIntervalMillis && this.mMinUpdateIntervalMillis == that.mMinUpdateIntervalMillis && this.mDurationMillis == that.mDurationMillis && this.mMaxUpdates == that.mMaxUpdates && Float.compare(that.mMinUpdateDistanceMeters, this.mMinUpdateDistanceMeters) == 0 && this.mMaxUpdateDelayMillis == that.mMaxUpdateDelayMillis;
    }

    public int hashCode() {
        int result2 = this.mQuality;
        result2 = 31 * result2 + (int)(this.mIntervalMillis ^ this.mIntervalMillis >>> 32);
        result2 = 31 * result2 + (int)(this.mMinUpdateIntervalMillis ^ this.mMinUpdateIntervalMillis >>> 32);
        return result2;
    }

    @NonNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Request[");
        if (this.mIntervalMillis != Long.MAX_VALUE) {
            s.append("@");
            TimeUtils.formatDuration(this.mIntervalMillis, s);
            switch (this.mQuality) {
                case 100: {
                    s.append(" HIGH_ACCURACY");
                    break;
                }
                case 102: {
                    s.append(" BALANCED");
                    break;
                }
                case 104: {
                    s.append(" LOW_POWER");
                }
            }
        } else {
            s.append("PASSIVE");
        }
        if (this.mDurationMillis != Long.MAX_VALUE) {
            s.append(", duration=");
            TimeUtils.formatDuration(this.mDurationMillis, s);
        }
        if (this.mMaxUpdates != Integer.MAX_VALUE) {
            s.append(", maxUpdates=").append(this.mMaxUpdates);
        }
        if (this.mMinUpdateIntervalMillis != -1L && this.mMinUpdateIntervalMillis < this.mIntervalMillis) {
            s.append(", minUpdateInterval=");
            TimeUtils.formatDuration(this.mMinUpdateIntervalMillis, s);
        }
        if ((double)this.mMinUpdateDistanceMeters > 0.0) {
            s.append(", minUpdateDistance=").append(this.mMinUpdateDistanceMeters);
        }
        if (this.mMaxUpdateDelayMillis / 2L > this.mIntervalMillis) {
            s.append(", maxUpdateDelay=");
            TimeUtils.formatDuration(this.mMaxUpdateDelayMillis, s);
        }
        s.append(']');
        return s.toString();
    }

    @RequiresApi(value=31)
    private static class Api31Impl {
        private Api31Impl() {
        }

        @DoNotInline
        public static LocationRequest toLocationRequest(LocationRequestCompat obj) {
            return new LocationRequest.Builder(obj.getIntervalMillis()).setQuality(obj.getQuality()).setMinUpdateIntervalMillis(obj.getMinUpdateIntervalMillis()).setDurationMillis(obj.getDurationMillis()).setMaxUpdates(obj.getMaxUpdates()).setMinUpdateDistanceMeters(obj.getMinUpdateDistanceMeters()).setMaxUpdateDelayMillis(obj.getMaxUpdateDelayMillis()).build();
        }
    }

    private static class Api19Impl {
        private static Class<?> sLocationRequestClass;
        private static Method sCreateFromDeprecatedProviderMethod;
        private static Method sSetQualityMethod;
        private static Method sSetFastestIntervalMethod;
        private static Method sSetNumUpdatesMethod;
        private static Method sSetExpireInMethod;

        private Api19Impl() {
        }

        @SuppressLint(value={"BanUncheckedReflection"})
        public static Object toLocationRequest(LocationRequestCompat obj, String provider) {
            try {
                Object request;
                if (sLocationRequestClass == null) {
                    sLocationRequestClass = Class.forName("android.location.LocationRequest");
                }
                if (sCreateFromDeprecatedProviderMethod == null) {
                    sCreateFromDeprecatedProviderMethod = sLocationRequestClass.getDeclaredMethod("createFromDeprecatedProvider", String.class, Long.TYPE, Float.TYPE, Boolean.TYPE);
                    sCreateFromDeprecatedProviderMethod.setAccessible(true);
                }
                if ((request = sCreateFromDeprecatedProviderMethod.invoke(null, provider, obj.getIntervalMillis(), Float.valueOf(obj.getMinUpdateDistanceMeters()), false)) == null) {
                    return null;
                }
                if (sSetQualityMethod == null) {
                    sSetQualityMethod = sLocationRequestClass.getDeclaredMethod("setQuality", Integer.TYPE);
                    sSetQualityMethod.setAccessible(true);
                }
                sSetQualityMethod.invoke(request, obj.getQuality());
                if (sSetFastestIntervalMethod == null) {
                    sSetFastestIntervalMethod = sLocationRequestClass.getDeclaredMethod("setFastestInterval", Long.TYPE);
                    sSetFastestIntervalMethod.setAccessible(true);
                }
                sSetFastestIntervalMethod.invoke(request, obj.getMinUpdateIntervalMillis());
                if (obj.getMaxUpdates() < Integer.MAX_VALUE) {
                    if (sSetNumUpdatesMethod == null) {
                        sSetNumUpdatesMethod = sLocationRequestClass.getDeclaredMethod("setNumUpdates", Integer.TYPE);
                        sSetNumUpdatesMethod.setAccessible(true);
                    }
                    sSetNumUpdatesMethod.invoke(request, obj.getMaxUpdates());
                }
                if (obj.getDurationMillis() < Long.MAX_VALUE) {
                    if (sSetExpireInMethod == null) {
                        sSetExpireInMethod = sLocationRequestClass.getDeclaredMethod("setExpireIn", Long.TYPE);
                        sSetExpireInMethod.setAccessible(true);
                    }
                    sSetExpireInMethod.invoke(request, obj.getDurationMillis());
                }
                return request;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return null;
            }
        }
    }

    public static final class Builder {
        private long mIntervalMillis;
        private int mQuality;
        private long mDurationMillis;
        private int mMaxUpdates;
        private long mMinUpdateIntervalMillis;
        private float mMinUpdateDistanceMeters;
        private long mMaxUpdateDelayMillis;

        public Builder(long intervalMillis) {
            this.setIntervalMillis(intervalMillis);
            this.mQuality = 102;
            this.mDurationMillis = Long.MAX_VALUE;
            this.mMaxUpdates = Integer.MAX_VALUE;
            this.mMinUpdateIntervalMillis = -1L;
            this.mMinUpdateDistanceMeters = 0.0f;
            this.mMaxUpdateDelayMillis = 0L;
        }

        public Builder(@NonNull LocationRequestCompat locationRequest) {
            this.mIntervalMillis = locationRequest.mIntervalMillis;
            this.mQuality = locationRequest.mQuality;
            this.mDurationMillis = locationRequest.mDurationMillis;
            this.mMaxUpdates = locationRequest.mMaxUpdates;
            this.mMinUpdateIntervalMillis = locationRequest.mMinUpdateIntervalMillis;
            this.mMinUpdateDistanceMeters = locationRequest.mMinUpdateDistanceMeters;
            this.mMaxUpdateDelayMillis = locationRequest.mMaxUpdateDelayMillis;
        }

        @NonNull
        public Builder setIntervalMillis(@IntRange(from=0L) long intervalMillis) {
            this.mIntervalMillis = Preconditions.checkArgumentInRange(intervalMillis, 0L, Long.MAX_VALUE, "intervalMillis");
            return this;
        }

        @NonNull
        public Builder setQuality(int quality) {
            Preconditions.checkArgument(quality == 104 || quality == 102 || quality == 100, "quality must be a defined QUALITY constant, not %d", quality);
            this.mQuality = quality;
            return this;
        }

        @NonNull
        public Builder setDurationMillis(@IntRange(from=1L) long durationMillis) {
            this.mDurationMillis = Preconditions.checkArgumentInRange(durationMillis, 1L, Long.MAX_VALUE, "durationMillis");
            return this;
        }

        @NonNull
        public Builder setMaxUpdates(@IntRange(from=1L, to=0x7FFFFFFFL) int maxUpdates) {
            this.mMaxUpdates = Preconditions.checkArgumentInRange(maxUpdates, 1, Integer.MAX_VALUE, "maxUpdates");
            return this;
        }

        @NonNull
        public Builder setMinUpdateIntervalMillis(@IntRange(from=0L) long minUpdateIntervalMillis) {
            this.mMinUpdateIntervalMillis = Preconditions.checkArgumentInRange(minUpdateIntervalMillis, 0L, Long.MAX_VALUE, "minUpdateIntervalMillis");
            return this;
        }

        @NonNull
        public Builder clearMinUpdateIntervalMillis() {
            this.mMinUpdateIntervalMillis = -1L;
            return this;
        }

        @NonNull
        public Builder setMinUpdateDistanceMeters(@FloatRange(from=0.0, to=3.4028234663852886E38) float minUpdateDistanceMeters) {
            this.mMinUpdateDistanceMeters = minUpdateDistanceMeters;
            this.mMinUpdateDistanceMeters = Preconditions.checkArgumentInRange(minUpdateDistanceMeters, 0.0f, Float.MAX_VALUE, "minUpdateDistanceMeters");
            return this;
        }

        @NonNull
        public Builder setMaxUpdateDelayMillis(@IntRange(from=0L) long maxUpdateDelayMillis) {
            this.mMaxUpdateDelayMillis = maxUpdateDelayMillis;
            this.mMaxUpdateDelayMillis = Preconditions.checkArgumentInRange(maxUpdateDelayMillis, 0L, Long.MAX_VALUE, "maxUpdateDelayMillis");
            return this;
        }

        @NonNull
        public LocationRequestCompat build() {
            Preconditions.checkState(this.mIntervalMillis != Long.MAX_VALUE || this.mMinUpdateIntervalMillis != -1L, "passive location requests must have an explicit minimum update interval");
            return new LocationRequestCompat(this.mIntervalMillis, this.mQuality, this.mDurationMillis, this.mMaxUpdates, Math.min(this.mMinUpdateIntervalMillis, this.mIntervalMillis), this.mMinUpdateDistanceMeters, this.mMaxUpdateDelayMillis);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Quality {
    }
}

