/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.SparseArray;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.Serializable;
import java.util.ArrayList;

public final class BundleCompat {
    private BundleCompat() {
    }

    @Nullable
    public static <T> T getParcelable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelable(in, key, clazz);
        }
        Parcelable parcelable = in.getParcelable(key);
        return (T)(clazz.isInstance(parcelable) ? parcelable : null);
    }

    @Nullable
    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    public static Parcelable[] getParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends Parcelable> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelableArray(in, key, clazz);
        }
        return in.getParcelableArray(key);
    }

    @Nullable
    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    public static <T> ArrayList<T> getParcelableArrayList(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getParcelableArrayList(in, key, clazz);
        }
        return in.getParcelableArrayList(key);
    }

    @Nullable
    public static <T> SparseArray<T> getSparseParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getSparseParcelableArray(in, key, clazz);
        }
        return in.getSparseParcelableArray(key);
    }

    @Deprecated
    @Nullable
    public static IBinder getBinder(@NonNull Bundle bundle, @Nullable String key) {
        return bundle.getBinder(key);
    }

    @Deprecated
    public static void putBinder(@NonNull Bundle bundle, @Nullable String key, @Nullable IBinder binder2) {
        bundle.putBinder(key, binder2);
    }

    @Nullable
    public static <T extends Serializable> T getSerializable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.getSerializable(in, key, clazz);
        }
        Serializable serializable = in.getSerializable(key);
        return (T)(clazz.isInstance(serializable) ? serializable : null);
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static <T> T getParcelable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
            return (T)in.getParcelable(key, clazz);
        }

        @DoNotInline
        static <T> T[] getParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
            return in.getParcelableArray(key, clazz);
        }

        @DoNotInline
        static <T> ArrayList<T> getParcelableArrayList(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
            return in.getParcelableArrayList(key, clazz);
        }

        @DoNotInline
        static <T> SparseArray<T> getSparseParcelableArray(@NonNull Bundle in, @Nullable String key, @NonNull Class<? extends T> clazz) {
            return in.getSparseParcelableArray(key, clazz);
        }

        @DoNotInline
        static <T extends Serializable> T getSerializable(@NonNull Bundle in, @Nullable String key, @NonNull Class<T> clazz) {
            return (T)in.getSerializable(key, clazz);
        }
    }
}

