/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public final class ExecutorCompat {
    @NonNull
    public static Executor create(@NonNull Handler handler) {
        return new HandlerExecutor(handler);
    }

    private ExecutorCompat() {
    }

    private static class HandlerExecutor
    implements Executor {
        private final Handler mHandler;

        HandlerExecutor(@NonNull Handler handler) {
            this.mHandler = Preconditions.checkNotNull(handler);
        }

        @Override
        public void execute(@NonNull Runnable command2) {
            if (!this.mHandler.post(Preconditions.checkNotNull(command2))) {
                throw new RejectedExecutionException(this.mHandler + " is shutting down");
            }
        }
    }
}

